/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeView;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.projectView.AbstractFolderNode;
import org.jetbrains.plugins.groovy.mvc.projectView.AbstractMvcPsiNodeDescriptor;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectNode;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectViewState;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

public class MvcProjectViewPane
extends AbstractProjectViewPSIPane
implements IdeView {
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final JComponent myComponent;
    private final DeleteProvider myDeletePSIElementProvider;
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    @NonNls
    private final String myId;
    private final MvcToolWindowDescriptor myDescriptor;
    private final MvcProjectViewState myViewState;

    public MvcProjectViewPane(Project project, MvcToolWindowDescriptor descriptor2) {
        super(project);
        this.myDescriptor = descriptor2;
        this.myId = descriptor2.getToolWindowId();
        this.myViewState = descriptor2.getProjectViewState(project);
        class TreeUpdater
        implements Runnable,
        PsiModificationTracker.Listener {
            private volatile boolean myInQueue;

            TreeUpdater() {
            }

            @Override
            public void run() {
                if (MvcProjectViewPane.this.getTree() != null && MvcProjectViewPane.this.getTreeBuilder() != null) {
                    MvcProjectViewPane.this.updateFromRoot(true);
                }
                this.myInQueue = false;
            }

            public void modificationCountChanged() {
                if (!this.myInQueue) {
                    this.myInQueue = true;
                    ApplicationManager.getApplication().invokeLater((Runnable)this);
                }
            }
        }
        project.getMessageBus().connect((Disposable)this).subscribe(PsiModificationTracker.TOPIC, (Object)new TreeUpdater());
        this.myComponent = this.createComponent();
        DataManager.registerDataProvider((JComponent)this.myComponent, (DataProvider)this);
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollToSource = state;
            }
        };
        this.myAutoScrollFromSourceHandler.install();
        this.myAutoScrollToSourceHandler.install(this.getTree());
        this.myAutoScrollToSourceHandler.onMouseClicked((Component)this.getTree());
        this.myCopyPasteDelegator = new CopyPasteDelegator(project, this.myComponent);
        this.myDeletePSIElementProvider = new DeleteHandler.DefaultDeleteProvider();
    }

    public void setup(ToolWindowEx toolWindow) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.myComponent, "Center");
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)p, null, false);
        content.setDisposer((Disposable)this);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(this.createComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new HideEmptyMiddlePackagesAction());
        group.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        group.add((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction());
        toolWindow.setAdditionalGearActions((ActionGroup)group);
        DefaultTreeExpander expander = new DefaultTreeExpander((JTree)this.myTree);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction collapseAction = actionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)this.myTree);
        collapseAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        toolWindow.setTitleActions(new AnAction[]{new ScrollFromSourceAction(), collapseAction});
    }

    @NotNull
    public String getTitle() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myDescriptor.getFramework().getIcon();
        if (icon == null) {
            MvcProjectViewPane.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            MvcProjectViewPane.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getWeight() {
        throw new UnsupportedOperationException();
    }

    public boolean isInitiallyVisible() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            MvcProjectViewPane.$$$reportNull$$$0(2);
        }
        ProjectTreeBuilder projectTreeBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            protected AbstractTreeUpdater createUpdater() {
                return MvcProjectViewPane.this.createTreeUpdater((AbstractTreeBuilder)this);
            }
        };
        if (projectTreeBuilder == null) {
            MvcProjectViewPane.$$$reportNull$$$0(3);
        }
        return projectTreeBuilder;
    }

    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        String id = this.getId();
        ProjectTreeStructure projectTreeStructure = new ProjectTreeStructure(this.myProject, id){

            public boolean isHideEmptyMiddlePackages() {
                return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.hideEmptyMiddlePackages;
            }

            protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (settings == null) {
                    3.$$$reportNull$$$0(1);
                }
                return new MvcProjectNode(project, (ViewSettings)this, MvcProjectViewPane.this.myDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settings";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/projectView/MvcProjectViewPane$3";
                objectArray[2] = "createRoot";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (projectTreeStructure == null) {
            MvcProjectViewPane.$$$reportNull$$$0(4);
        }
        return projectTreeStructure;
    }

    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            MvcProjectViewPane.$$$reportNull$$$0(5);
        }
        ProjectViewTree projectViewTree = new ProjectViewTree(treeModel){

            public String toString() {
                return MvcProjectViewPane.this.myDescriptor.getFramework().getDisplayName() + " " + super.toString();
            }
        };
        if (projectViewTree == null) {
            MvcProjectViewPane.$$$reportNull$$$0(6);
        }
        return projectViewTree;
    }

    @NotNull
    protected AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            MvcProjectViewPane.$$$reportNull$$$0(7);
        }
        AbstractTreeUpdater abstractTreeUpdater = new AbstractTreeUpdater(treeBuilder){};
        if (abstractTreeUpdater == null) {
            MvcProjectViewPane.$$$reportNull$$$0(8);
        }
        return abstractTreeUpdater;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            MvcProjectViewPane.$$$reportNull$$$0(9);
        }
        if (CommonDataKeys.PSI_ELEMENT.getName().equals(dataId)) {
            PsiElement[] elements = this.getSelectedPSIElements();
            return elements.length == 1 ? elements[0] : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.getName().equals(dataId)) {
            return this.getSelectedPSIElements();
        }
        if (LangDataKeys.MODULE_CONTEXT.getName().equals(dataId)) {
            Object element = this.getSelectedElement();
            if (element instanceof Module) {
                return element;
            }
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT_ARRAY.getName().equals(dataId)) {
            List moduleList = ContainerUtil.findAll((Object[])this.getSelectedElements(), Module.class);
            if (!moduleList.isEmpty()) {
                return moduleList.toArray(Module.EMPTY_ARRAY);
            }
            return null;
        }
        if (dataId.equals(LangDataKeys.IDE_VIEW.getName())) {
            return this;
        }
        if (dataId.equals(PlatformDataKeys.HELP_ID.getName())) {
            return "reference.toolwindows." + this.myId.toLowerCase();
        }
        if (PlatformDataKeys.CUT_PROVIDER.getName().equals(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.getName().equals(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.getName().equals(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getName().equals(dataId)) {
            for (Object element : this.getSelectedElements()) {
                if (!(element instanceof Module)) continue;
                return this.myDeleteModuleProvider;
            }
            return this.myDeletePSIElementProvider;
        }
        return super.getData(dataId);
    }

    @Nullable
    public static MvcProjectViewPane getView(Project project, MvcFramework framework) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(MvcToolWindowDescriptor.getToolWindowId(framework));
        Content content = window == null ? null : window.getContentManager().getContent(0);
        return content == null ? null : (MvcProjectViewPane)content.getDisposer();
    }

    public void selectElement(PsiElement element) {
        Editor editor;
        PsiFileSystemItem psiFile;
        if (element instanceof PsiFileSystemItem) {
            psiFile = (PsiFileSystemItem)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.selectFile(virtualFile, false);
        boolean requestFocus = true;
        if (psiFile instanceof PsiFile && (editor = EditorHelper.openInEditor((PsiElement)element)) != null) {
            ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
            requestFocus = false;
        }
        if (requestFocus) {
            this.selectFile(virtualFile, true);
        }
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        PsiDirectory[] psiDirectoryArray = this.getSelectedDirectories();
        if (psiDirectoryArray == null) {
            MvcProjectViewPane.$$$reportNull$$$0(10);
        }
        return psiDirectoryArray;
    }

    public PsiDirectory getOrChooseDirectory() {
        return DirectoryChooserUtil.getOrChooseDirectory((IdeView)this);
    }

    public static boolean canSelectFile(@NotNull Project project, @NotNull MvcFramework framework, VirtualFile file) {
        if (project == null) {
            MvcProjectViewPane.$$$reportNull$$$0(11);
        }
        if (framework == null) {
            MvcProjectViewPane.$$$reportNull$$$0(12);
        }
        return MvcProjectViewPane.getSelectPath(project, framework, file) != null;
    }

    @Nullable
    private List<Object> getSelectPath(VirtualFile file) {
        return MvcProjectViewPane.getSelectPath(this.myProject, this.myDescriptor.getFramework(), file);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static List<Object> getSelectPath(@NotNull Project project, @NotNull MvcFramework framework, VirtualFile file) {
        AbstractTreeNode descriptor2;
        AbstractTreeNode abstractTreeNode;
        if (project == null) {
            MvcProjectViewPane.$$$reportNull$$$0(13);
        }
        if (framework == null) {
            MvcProjectViewPane.$$$reportNull$$$0(14);
        }
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || !framework.hasSupport(module)) {
            return null;
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        MvcProjectViewPane view = MvcProjectViewPane.getView(project, framework);
        if (view == null) {
            return null;
        }
        MvcProjectNode root = (MvcProjectNode)((Object)view.getTreeBuilder().getTreeStructure().getRootElement());
        result2.add((Object)root);
        Iterator<? extends AbstractTreeNode> iterator2 = root.getChildren().iterator();
        do {
            if (iterator2.hasNext()) continue;
            return null;
        } while ((abstractTreeNode = iterator2.next()).getValue() != module);
        result2.add(abstractTreeNode);
        Object cur = abstractTreeNode;
        block1: while (true) {
            Iterator iterator3 = cur.getChildren().iterator();
            do {
                AbstractFolderNode folderNode;
                VirtualFile dir;
                if (!iterator3.hasNext()) {
                    return null;
                }
                descriptor2 = (AbstractTreeNode)iterator3.next();
                if (!(descriptor2 instanceof AbstractFolderNode) || (dir = (folderNode = (AbstractFolderNode)descriptor2).getVirtualFile()) == null || !VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)false)) continue;
                cur = folderNode;
                result2.add((Object)folderNode);
                if (!dir.equals(file)) continue block1;
                return result2;
            } while (!(descriptor2 instanceof AbstractMvcPsiNodeDescriptor) || !file.equals(((AbstractMvcPsiNodeDescriptor)descriptor2).getVirtualFile()));
            break;
        }
        result2.add(descriptor2);
        return result2;
    }

    public boolean canSelectFile(VirtualFile file) {
        return this.getSelectPath(file) != null;
    }

    private void selectElementAtCaret(Editor editor, boolean requestFocus) {
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        this.selectFile(file, requestFocus);
    }

    public void selectFile(@Nullable PsiFile file, boolean requestFocus) {
        if (file == null) {
            return;
        }
        this.selectFile(file.getVirtualFile(), requestFocus);
    }

    public void selectFile(@Nullable VirtualFile file, boolean requestFocus) {
        if (file == null) {
            return;
        }
        List<Object> path = this.getSelectPath(file);
        if (path == null) {
            return;
        }
        Object value = ((AbstractTreeNode)path.get(path.size() - 1)).getValue();
        this.select(value, file, requestFocus);
    }

    public void scrollFromSource() {
        FileEditor[] editors;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        Editor selectedTextEditor = fileEditorManager.getSelectedTextEditor();
        if (selectedTextEditor != null) {
            this.selectElementAtCaret(selectedTextEditor, false);
            return;
        }
        for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            this.selectElementAtCaret(editor, false);
            return;
        }
        VirtualFile[] selectedFiles = fileEditorManager.getSelectedFiles();
        if (selectedFiles.length > 0) {
            PsiFile file = PsiManager.getInstance((Project)this.myProject).findFile(selectedFiles[0]);
            this.selectFile(file, false);
        }
    }

    private void selectElementAtCaretNotLosingFocus() {
        if (IJSwingUtilities.hasFocus((Component)this.getComponentToFocus())) {
            return;
        }
        this.scrollFromSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/projectView/MvcProjectViewPane";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/projectView/MvcProjectViewPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructure";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeUpdater";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTreeUpdater";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canSelectFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class HideEmptyMiddlePackagesAction
    extends ToggleAction
    implements DumbAware {
        private HideEmptyMiddlePackagesAction() {
            super("Compact Empty Middle Packages", "Show/Compact Empty Middle Packages", AllIcons.ObjectBrowser.CompactEmptyPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HideEmptyMiddlePackagesAction.$$$reportNull$$$0(0);
            }
            return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.hideEmptyMiddlePackages;
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                HideEmptyMiddlePackagesAction.$$$reportNull$$$0(1);
            }
            ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.hideEmptyMiddlePackages = flag;
            TreeUtil.collapseAll((JTree)MvcProjectViewPane.this.myTree, (int)1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/projectView/MvcProjectViewPane$HideEmptyMiddlePackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        protected MyAutoScrollFromSourceHandler() {
            super(MvcProjectViewPane.this.myProject, MvcProjectViewPane.this.myComponent, (Disposable)MvcProjectViewPane.this);
        }

        protected boolean isAutoScrollEnabled() {
            return ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            ((MvcProjectViewPane)MvcProjectViewPane.this).myViewState.autoScrollFromSource = state;
            if (state) {
                MvcProjectViewPane.this.selectElementAtCaretNotLosingFocus();
            }
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            MvcProjectViewPane.this.selectElementAtCaretNotLosingFocus();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/mvc/projectView/MvcProjectViewPane$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }

    private class ScrollFromSourceAction
    extends AnAction
    implements DumbAware {
        private ScrollFromSourceAction() {
            super("Scroll from Source", "Select the file open in the active editor", AllIcons.General.Locate);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollFromSourceAction.$$$reportNull$$$0(0);
            }
            MvcProjectViewPane.this.scrollFromSource();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/projectView/MvcProjectViewPane$ScrollFromSourceAction", "actionPerformed"));
        }
    }
}

