/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrClassMemberReferenceVisitor
extends GroovyRecursiveElementVisitor {
    private final PsiClass myClass;

    public GrClassMemberReferenceVisitor(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GrClassMemberReferenceVisitor.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
        PsiClass containingClass;
        GroovyResolveResult resolveResult;
        PsiElement resolved;
        GrExpression qualifier;
        if (ref == null) {
            GrClassMemberReferenceVisitor.$$$reportNull$$$0(1);
        }
        if ((qualifier = (GrExpression)ref.getQualifier()) != null && !PsiUtil.isThisOrSuperRef(qualifier)) {
            qualifier.accept(this);
            if (!(qualifier instanceof GrReferenceExpression) || !(((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
                return;
            }
        }
        if ((resolved = (resolveResult = ref.advancedResolve()).getElement()) instanceof GrMember && GrClassMemberReferenceVisitor.isPartOf(this.myClass, containingClass = ((GrMember)resolved).getContainingClass())) {
            this.visitClassMemberReferenceElement(ref, (GrMember)resolved, resolveResult);
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement reference) {
        GroovyResolveResult resolveResult;
        PsiElement referencedElement;
        if (reference == null) {
            GrClassMemberReferenceVisitor.$$$reportNull$$$0(2);
        }
        if ((referencedElement = (resolveResult = reference.advancedResolve()).getElement()) instanceof GrTypeDefinition) {
            GrTypeDefinition referencedClass = (GrTypeDefinition)referencedElement;
            if (PsiTreeUtil.isAncestor((PsiElement)this.myClass, (PsiElement)referencedElement, (boolean)true) || GrClassMemberReferenceVisitor.isPartOf(this.myClass, referencedClass.getContainingClass())) {
                this.visitClassMemberReferenceElement(reference, (GrMember)referencedElement, resolveResult);
            }
        }
    }

    private static boolean isPartOf(@NotNull PsiClass aClass, @Nullable PsiClass containingClass) {
        if (aClass == null) {
            GrClassMemberReferenceVisitor.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            return false;
        }
        return aClass.equals(containingClass) || aClass.isInheritor(containingClass, true);
    }

    protected void visitClassMemberReferenceElement(GrReferenceElement<?> ref, GrMember member, GroovyResolveResult resolveResult) {
        this.visitClassMemberReferenceElement(member, ref);
    }

    protected void visitClassMemberReferenceElement(GrMember resolved, GrReferenceElement ref) {
        throw new RuntimeException("Override one of visitClassMemberReferenceElement() methods");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/classMembers/GrClassMemberReferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCodeReferenceElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPartOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

