/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;

class InlineGroovyFieldDialog
extends InlineOptionsDialog {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.field.title");
    private final PsiField myField;

    InlineGroovyFieldDialog(Project project, PsiField field, boolean invokedOnReference) {
        super(project, true, (PsiElement)field);
        this.myField = field;
        this.myInvokedOnReference = invokedOnReference;
        this.setTitle(REFACTORING_NAME);
        this.init();
    }

    protected String getNameLabelText() {
        String fieldText = PsiFormatUtil.formatVariable((PsiVariable)this.myField, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return RefactoringBundle.message((String)"inline.field.field.name.label", (Object[])new Object[]{fieldText});
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.field.border.title");
    }

    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.the.field");
    }

    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.the.field");
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_FIELD_THIS;
    }

    protected void doAction() {
        if (this.getOKAction().isEnabled()) {
            JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
            if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
                settings.INLINE_FIELD_THIS = this.isInlineThisOnly();
            }
            this.close(0);
        }
    }

    protected String getHelpId() {
        return "refactoring.inlineField";
    }
}

