/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public abstract class GroovyUnwrapper
extends AbstractUnwrapper<Context> {
    public GroovyUnwrapper(@NotNull String description) {
        if (description == null) {
            GroovyUnwrapper.$$$reportNull$$$0(0);
        }
        super(description);
    }

    protected Context createContext() {
        return new Context();
    }

    public static boolean isElseBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof GrIfStatement && element == ((GrIfStatement)parent).getElseBranch();
    }

    @NotNull
    public List<PsiElement> unwrap(@NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (editor == null) {
            GroovyUnwrapper.$$$reportNull$$$0(1);
        }
        if (element == null) {
            GroovyUnwrapper.$$$reportNull$$$0(2);
        }
        List res = super.unwrap(editor, element);
        for (PsiElement e : res) {
            if (!PsiImplUtil.isLeafElementOfType((PsiElement)e, (IElementType)GroovyTokenTypes.mNLS)) continue;
            CodeEditUtil.setNodeGenerated((ASTNode)e.getNode(), (boolean)true);
        }
        List list = res;
        if (list == null) {
            GroovyUnwrapper.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/unwrap/GroovyUnwrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/unwrap/GroovyUnwrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        public void extractFromBlockOrSingleStatement(GrStatement block, PsiElement from) throws IncorrectOperationException {
            if (block instanceof GrBlockStatement) {
                this.extractFromCodeBlock(((GrBlockStatement)block).getBlock(), from);
            } else if (block != null) {
                this.extract(block, block, from);
            }
        }

        public void extractFromCodeBlock(GrCodeBlock block, PsiElement from) throws IncorrectOperationException {
            PsiElement lastBodyElement;
            PsiElement firstBodyElement;
            if (block == null) {
                return;
            }
            PsiElement rBrace = block.getRBrace();
            PsiElement lBrace = block.getLBrace();
            if (lBrace == null) {
                firstBodyElement = null;
            } else {
                firstBodyElement = lBrace.getNextSibling();
                if (firstBodyElement == rBrace) {
                    firstBodyElement = null;
                }
            }
            if (rBrace == null) {
                lastBodyElement = null;
            } else {
                lastBodyElement = rBrace.getPrevSibling();
                if (lastBodyElement == lBrace) {
                    lastBodyElement = null;
                }
            }
            this.extract(firstBodyElement, lastBodyElement, from);
        }

        protected boolean isWhiteSpace(PsiElement element) {
            return org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil.isWhiteSpaceOrNls(element);
        }

        public void setElseBranch(GrIfStatement ifStatement, GrStatement elseBranch) throws IncorrectOperationException {
            GrStatement toExtract = elseBranch;
            if (this.myIsEffective) {
                ifStatement.replaceElseBranch(Context.copyElement(elseBranch));
                toExtract = ifStatement.getElseBranch();
            }
            this.addElementToExtract(toExtract);
        }

        private static GrStatement copyElement(GrStatement e) throws IncorrectOperationException {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(e.getProject());
            return factory.createStatementFromText(e.getText(), null);
        }
    }
}

