/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ParamStyle;
import org.jvnet.ws.wadl.util.DSDispatcher;
import org.jvnet.ws.wadl.util.JAXBDispatcher;
import org.jvnet.ws.wadl.util.UriBuilder;
import org.jvnet.ws.wadl2java.GeneratorUtil;
import org.jvnet.ws.wadl2java.JavaDocUtil;
import org.jvnet.ws.wadl2java.Wadl2JavaMessages;
import org.jvnet.ws.wadl2java.ast.FaultNode;
import org.jvnet.ws.wadl2java.ast.MethodNode;
import org.jvnet.ws.wadl2java.ast.PathSegment;
import org.jvnet.ws.wadl2java.ast.RepresentationNode;
import org.jvnet.ws.wadl2java.ast.ResourceNode;
import org.jvnet.ws.wadl2java.ast.ResourceTypeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClassGenerator {
    private ResourceNode resource;
    private JPackage pkg;
    private S2JJAXBModel s2jModel;
    private JCodeModel codeModel;
    private JFieldVar $jaxbDispatcher;
    private JFieldVar $dsDispatcher;
    private JFieldVar $uriBuilder;
    private JFieldVar $jaxbContext;
    private JFieldVar $templateMatrixParamValMap;
    private JDefinedClass $class = null;
    private JavaDocUtil javaDoc;
    private String generatedPackages;

    public ResourceClassGenerator(S2JJAXBModel s2jModel, JCodeModel codeModel, JPackage pkg, String generatedPackages, JavaDocUtil javaDoc, ResourceNode resource) {
        this.resource = resource;
        this.codeModel = codeModel;
        this.javaDoc = javaDoc;
        this.s2jModel = s2jModel;
        this.pkg = pkg;
        this.generatedPackages = generatedPackages;
    }

    public ResourceClassGenerator(S2JJAXBModel s2jModel, JCodeModel codeModel, JPackage pkg, String generatedPackages, JavaDocUtil javaDoc, JDefinedClass clazz) {
        this.resource = null;
        this.codeModel = codeModel;
        this.javaDoc = javaDoc;
        this.s2jModel = s2jModel;
        this.pkg = pkg;
        this.$class = clazz;
        this.generatedPackages = generatedPackages;
    }

    public JDefinedClass getGeneratedClass() {
        return this.$class;
    }

    public JDefinedClass generateClass(JDefinedClass parentClass) throws JClassAlreadyExistsException {
        JDefinedClass $impl = parentClass._class(17, this.resource.getClassName());
        for (ResourceTypeNode t : this.resource.getResourceTypes()) {
            $impl._implements((JClass)t.getGeneratedInterface());
        }
        this.javaDoc.generateClassDoc(this.resource, $impl);
        this.$jaxbDispatcher = $impl.field(4, JAXBDispatcher.class, "_jaxbDispatcher");
        this.$dsDispatcher = $impl.field(4, DSDispatcher.class, "_dsDispatcher");
        this.$uriBuilder = $impl.field(4, UriBuilder.class, "_uriBuilder");
        this.$jaxbContext = $impl.field(4, JAXBContext.class, "_jc");
        JClass mapOfStringObject = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
        this.$templateMatrixParamValMap = $impl.field(4, (JType)mapOfStringObject, "_templateAndMatrixParameterValues");
        JMethod $ctor = $impl.constructor(1);
        JDocComment jdoc = $ctor.javadoc();
        jdoc.append((Object)Wadl2JavaMessages.CREATE_INSTANCE());
        for (PathSegment segment : this.resource.getPathSegments()) {
            for (Param p : segment.getTemplateParameters()) {
                $ctor.param((JType)GeneratorUtil.getJavaType(p, this.codeModel, $impl, this.javaDoc), GeneratorUtil.makeParamName(p.getName()));
                this.javaDoc.generateParamDoc(p, $ctor);
                this.generateBeanProperty($impl, p, false);
            }
            for (Param p : segment.getMatrixParameters()) {
                if (p.isRequired()) {
                    $ctor.param((JType)GeneratorUtil.getJavaType(p, this.codeModel, $impl, this.javaDoc), GeneratorUtil.makeParamName(p.getName()));
                    this.javaDoc.generateParamDoc(p, $ctor);
                }
                this.generateBeanProperty($impl, p, false);
            }
        }
        $ctor._throws(JAXBException.class);
        JBlock $ctorBody = $ctor.body();
        if (this.generatedPackages.length() > 0) {
            $ctorBody.assign((JAssignmentTarget)this.$jaxbContext, (JExpression)this.codeModel.ref(JAXBContext.class).staticInvoke("newInstance").arg(JExpr.lit((String)this.generatedPackages)));
            $ctorBody.assign((JAssignmentTarget)this.$jaxbDispatcher, (JExpression)JExpr._new((JClass)this.codeModel.ref(JAXBDispatcher.class)).arg((JExpression)this.$jaxbContext));
        }
        $ctorBody.assign((JAssignmentTarget)this.$dsDispatcher, (JExpression)JExpr._new((JClass)this.codeModel.ref(DSDispatcher.class)));
        $ctorBody.assign((JAssignmentTarget)this.$uriBuilder, (JExpression)JExpr._new((JClass)this.codeModel.ref(UriBuilder.class)));
        JClass listOfString = this.codeModel.ref(List.class).narrow(String.class);
        JVar $matrixParamSet = $ctorBody.decl((JType)listOfString, "_matrixParamSet");
        for (PathSegment segment : this.resource.getPathSegments()) {
            $ctorBody.assign((JAssignmentTarget)$matrixParamSet, (JExpression)this.$uriBuilder.invoke("addPathSegment").arg(JExpr.lit((String)segment.getTemplate())));
            for (Param p : segment.getMatrixParameters()) {
                $ctorBody.invoke((JExpression)$matrixParamSet, "add").arg(JExpr.lit((String)p.getName()));
            }
        }
        $ctorBody.assign((JAssignmentTarget)this.$templateMatrixParamValMap, (JExpression)JExpr._new((JClass)mapOfStringObject));
        for (PathSegment segment : this.resource.getPathSegments()) {
            for (Param p : segment.getTemplateParameters()) {
                $ctorBody.invoke((JExpression)this.$templateMatrixParamValMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)JExpr.ref((String)GeneratorUtil.makeParamName(p.getName())));
            }
            for (Param p : segment.getMatrixParameters()) {
                if (!p.isRequired()) continue;
                $ctorBody.invoke((JExpression)this.$templateMatrixParamValMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)JExpr.ref((String)GeneratorUtil.makeParamName(p.getName())));
            }
        }
        this.$class = $impl;
        return this.$class;
    }

    protected JDefinedClass generateExceptionClass(FaultNode f) {
        JDefinedClass $exCls = null;
        String exName = f.getClassName();
        try {
            $exCls = this.pkg._class(1, exName);
            $exCls._extends(Exception.class);
            Mapping m = this.s2jModel.get(f.getElement());
            if (m == null) {
                System.err.println(Wadl2JavaMessages.ELEMENT_NOT_FOUND(f.getElement().toString()));
            }
            JType detailType = m == null ? this.codeModel._ref(Object.class) : m.getType().getTypeClass();
            JFieldVar $detailField = $exCls.field(4, detailType, "m_faultInfo");
            JMethod $ctor = $exCls.constructor(1);
            JVar $msg = $ctor.param(String.class, "message");
            JVar $detail = $ctor.param(detailType, "faultInfo");
            JBlock $ctorBody = $ctor.body();
            $ctorBody.directStatement("super(message);");
            $ctorBody.assign((JAssignmentTarget)$detailField, (JExpression)$detail);
            JMethod $faultInfoGetter = $exCls.method(1, detailType, "getFaultInfo");
            $faultInfoGetter.body()._return((JExpression)$detailField);
        }
        catch (JClassAlreadyExistsException ex) {
            $exCls = ex.getExistingClass();
        }
        return $exCls;
    }

    protected void generateMethodDecls(MethodNode method, boolean isAbstract) {
        block9: {
            HashMap<JType, JDefinedClass> exceptionMap;
            List<RepresentationNode> supportedOutputs;
            List<RepresentationNode> supportedInputs;
            block7: {
                block8: {
                    supportedInputs = method.getSupportedInputs();
                    supportedOutputs = method.getSupportedOutputs();
                    exceptionMap = new HashMap<JType, JDefinedClass>();
                    for (FaultNode f : method.getFaults()) {
                        if (f.getElement() == null) {
                            System.err.println(Wadl2JavaMessages.FAULT_NO_ELEMENT());
                            continue;
                        }
                        JDefinedClass generatedException = this.generateExceptionClass(f);
                        Mapping m = this.s2jModel.get(f.getElement());
                        if (m == null) {
                            System.err.println(Wadl2JavaMessages.ELEMENT_NOT_FOUND(f.getElement().toString()));
                        }
                        JType faultType = m == null ? this.codeModel._ref(Object.class) : m.getType().getTypeClass();
                        exceptionMap.put(faultType, generatedException);
                    }
                    if (supportedInputs.size() != 0) break block7;
                    if (supportedOutputs.size() != 0) break block8;
                    this.generateMethodVariants(exceptionMap, method, false, null, null, isAbstract);
                    if (!method.hasOptionalParameters()) break block9;
                    this.generateMethodVariants(exceptionMap, method, true, null, null, isAbstract);
                    break block9;
                }
                for (RepresentationNode returnType : supportedOutputs) {
                    this.generateMethodVariants(exceptionMap, method, false, null, returnType, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, null, returnType, isAbstract);
                }
                break block9;
            }
            for (RepresentationNode inputType : supportedInputs) {
                if (supportedOutputs.size() == 0) {
                    this.generateMethodVariants(exceptionMap, method, false, inputType, null, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, inputType, null, isAbstract);
                    continue;
                }
                for (RepresentationNode returnType : supportedOutputs) {
                    this.generateMethodVariants(exceptionMap, method, false, inputType, returnType, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, inputType, returnType, isAbstract);
                }
            }
        }
    }

    protected JType getTypeFromElement(QName element) {
        Mapping m = this.s2jModel.get(element);
        if (m == null) {
            System.err.println(Wadl2JavaMessages.ELEMENT_NOT_FOUND(element.toString()));
        }
        JType type = m == null ? null : m.getType().getTypeClass();
        return type;
    }

    protected void generateMethodVariants(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, boolean isAbstract) {
        this.generateDSMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, isAbstract);
        this.generateJAXBMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, isAbstract);
    }

    protected String getMethodName(MethodNode method, RepresentationNode outputRep, JType returnType) {
        StringBuilder buf = new StringBuilder();
        buf.append(method.getName().toLowerCase());
        if (outputRep != null && outputRep.getId() != null) {
            buf.append(outputRep.getId().substring(0, 1).toUpperCase());
            buf.append(outputRep.getId().substring(1).toLowerCase());
        }
        if (returnType != null) {
            buf.append("As");
            buf.append(returnType.name());
        } else if (outputRep != null) {
            buf.append("As");
            buf.append(outputRep.getMediaTypeAsClassName());
        }
        return buf.toString();
    }

    protected void generateJAXBMethodDecl(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, boolean isAbstract) {
        if (outputRep != null && outputRep.getElement() == null || inputRep != null && inputRep.getElement() == null) {
            return;
        }
        JType inputType = null;
        JPrimitiveType returnType = null;
        if (inputRep != null && (inputType = this.getTypeFromElement(inputRep.getElement())) == null) {
            return;
        }
        if (outputRep != null) {
            returnType = this.getTypeFromElement(outputRep.getElement());
            if (returnType == null) {
                return;
            }
        } else {
            returnType = this.codeModel.VOID;
        }
        String methodName = this.getMethodName(method, outputRep, (JType)returnType);
        JMethod $genMethod = this.$class.method(1, (JType)returnType, methodName);
        this.javaDoc.generateMethodDoc(method, $genMethod);
        if (outputRep != null) {
            this.javaDoc.generateReturnDoc(outputRep, $genMethod);
        }
        $genMethod._throws(JAXBException.class);
        $genMethod._throws(MalformedURLException.class);
        $genMethod._throws(IOException.class);
        for (JDefinedClass $ex : exceptionMap.values()) {
            $genMethod._throws((JClass)$ex);
        }
        if (inputType != null) {
            $genMethod.param(inputType, "input");
            this.javaDoc.generateParamDoc(inputRep, $genMethod);
        }
        List<Param> params = method.getRequiredParameters();
        if (includeOptionalParams) {
            params.addAll(method.getOptionalParameters());
        }
        for (Param q : params) {
            if (q.getFixed() != null) continue;
            JClass javaType = GeneratorUtil.getJavaType(q, this.codeModel, this.$class, this.javaDoc);
            String paramName = q.getName().equals("input") ? "queryInput" : q.getName();
            q.setName(paramName);
            this.javaDoc.generateParamDoc(q, $genMethod);
            if (q.isRepeating()) {
                $genMethod.param((JType)this.codeModel.ref(List.class).narrow(javaType), GeneratorUtil.makeParamName(q.getName()));
                continue;
            }
            $genMethod.param((JType)javaType, GeneratorUtil.makeParamName(q.getName()));
        }
        if (!isAbstract) {
            JBlock $methodBody = $genMethod.body();
            JClass mapOfString = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
            JVar $queryParamMap = $methodBody.decl((JType)mapOfString, "_queryParameterValues", (JExpression)JExpr._new((JClass)mapOfString));
            JVar $headerParamMap = $methodBody.decl((JType)mapOfString, "_headerParameterValues", (JExpression)JExpr._new((JClass)mapOfString));
            for (Param q : params) {
                if (!includeOptionalParams && !q.isRequired() && q.getFixed() == null) continue;
                JFieldRef $paramArg = JExpr.ref((String)GeneratorUtil.makeParamName(q.getName()));
                if (q.isRequired() && q.getFixed() == null) {
                    JBlock $throwBlock = $methodBody._if($paramArg.eq(JExpr._null()))._then();
                    $throwBlock._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(IllegalArgumentException.class)).arg(JExpr.lit((String)Wadl2JavaMessages.PARAMETER_REQUIRED(q.getName(), methodName))));
                }
                JVar $paramMap = q.getStyle() == ParamStyle.QUERY ? $queryParamMap : $headerParamMap;
                JInvocation addParamToMap = $methodBody.invoke((JExpression)$paramMap, "put");
                if (q.getFixed() != null) {
                    addParamToMap.arg(JExpr.lit((String)q.getName())).arg(JExpr.lit((String)q.getFixed()));
                    continue;
                }
                addParamToMap.arg(JExpr.lit((String)q.getName())).arg((JExpression)$paramArg);
            }
            this.generateJAXBDBody(method, exceptionMap, outputRep, (JType)returnType, $queryParamMap, $headerParamMap, inputRep, $methodBody);
        }
    }

    protected void generateDSMethodDecl(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, boolean isAbstract) {
        JType inputType = null;
        Object returnType = null;
        if (inputRep != null) {
            inputType = this.codeModel._ref(DataSource.class);
        }
        returnType = outputRep != null ? this.codeModel._ref(DataSource.class) : this.codeModel.VOID;
        String methodName = this.getMethodName(method, outputRep, null);
        JMethod $genMethod = this.$class.method(1, (JType)returnType, methodName);
        this.javaDoc.generateMethodDoc(method, $genMethod);
        if (outputRep != null) {
            this.javaDoc.generateReturnDoc(outputRep, $genMethod);
        }
        $genMethod._throws(MalformedURLException.class);
        $genMethod._throws(IOException.class);
        if (inputType != null) {
            $genMethod.param(inputType, "input");
            this.javaDoc.generateParamDoc(inputRep, $genMethod);
        }
        List<Param> params = method.getRequiredParameters();
        if (includeOptionalParams) {
            params.addAll(method.getOptionalParameters());
        }
        for (Param q : params) {
            if (q.getFixed() != null) continue;
            JClass javaType = GeneratorUtil.getJavaType(q, this.codeModel, this.$class, this.javaDoc);
            String paramName = q.getName().equals("input") ? "queryInput" : q.getName();
            q.setName(paramName);
            this.javaDoc.generateParamDoc(q, $genMethod);
            if (q.isRepeating()) {
                $genMethod.param((JType)this.codeModel.ref(List.class).narrow(javaType), GeneratorUtil.makeParamName(q.getName()));
                continue;
            }
            $genMethod.param((JType)javaType, GeneratorUtil.makeParamName(q.getName()));
        }
        if (!isAbstract) {
            JBlock $methodBody = $genMethod.body();
            JClass mapOfString = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
            JVar $queryParamMap = $methodBody.decl((JType)mapOfString, "_queryParameterValues", (JExpression)JExpr._new((JClass)mapOfString));
            JVar $headerParamMap = $methodBody.decl((JType)mapOfString, "_headerParameterValues", (JExpression)JExpr._new((JClass)mapOfString));
            for (Param q : params) {
                if (!includeOptionalParams && !q.isRequired() && q.getFixed() == null) continue;
                JFieldRef $paramArg = JExpr.ref((String)GeneratorUtil.makeParamName(q.getName()));
                if (q.isRequired() && q.getFixed() == null) {
                    JBlock $throwBlock = $methodBody._if($paramArg.eq(JExpr._null()))._then();
                    $throwBlock._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(IllegalArgumentException.class)).arg(JExpr.lit((String)Wadl2JavaMessages.PARAMETER_REQUIRED(q.getName(), methodName))));
                }
                JVar $paramMap = q.getStyle() == ParamStyle.QUERY ? $queryParamMap : $headerParamMap;
                JInvocation addParamToMap = $methodBody.invoke((JExpression)$paramMap, "put");
                if (q.getFixed() != null) {
                    addParamToMap.arg(JExpr.lit((String)q.getName())).arg(JExpr.lit((String)q.getFixed()));
                    continue;
                }
                addParamToMap.arg(JExpr.lit((String)q.getName())).arg((JExpression)$paramArg);
            }
            this.generateDSDBody(method, outputRep, (JType)returnType, $queryParamMap, $headerParamMap, inputRep, $methodBody);
        }
    }

    protected void generateJAXBDBody(MethodNode method, Map<JType, JDefinedClass> exceptionMap, RepresentationNode outputRep, JType returnType, JVar $queryParamValueMap, JVar $headerParamValueMap, RepresentationNode inputRep, JBlock $methodBody) {
        JVar $url = $methodBody.decl((JType)this.codeModel.ref(String.class), "_url", (JExpression)this.$uriBuilder.invoke("buildUri").arg((JExpression)this.$templateMatrixParamValMap).arg((JExpression)$queryParamValueMap));
        JInvocation $executeMethod = this.$jaxbDispatcher.invoke("do" + method.getName());
        if (method.getName().equals("POST") || method.getName().equals("PUT")) {
            if (inputRep == null) {
                $executeMethod.arg(JExpr._null());
                $executeMethod.arg(JExpr._null());
            } else {
                $executeMethod.arg((JExpression)JExpr.ref((String)"input"));
                $executeMethod.arg(JExpr.lit((String)inputRep.getMediaType()));
            }
        }
        $executeMethod.arg((JExpression)$url);
        $executeMethod.arg((JExpression)$headerParamValueMap);
        if (outputRep != null) {
            $executeMethod.arg(JExpr.lit((String)outputRep.getMediaType()));
        } else {
            $executeMethod.arg(JExpr._null());
        }
        JVar $retVal = $methodBody.decl((JType)this.codeModel.ref(Object.class), "_retVal", (JExpression)$executeMethod);
        JBlock $nullBlock = $methodBody._if($retVal.eq(JExpr._null()))._then();
        if (outputRep != null) {
            $nullBlock._return(JExpr._null());
        } else {
            $nullBlock._return();
        }
        JClass jaxbElementType = this.codeModel.ref(JAXBElement.class);
        $nullBlock = $methodBody._if((JExpression)JExpr.invoke((JExpression)JExpr.dotclass((JClass)jaxbElementType), (String)"isInstance").arg((JExpression)$retVal))._then();
        JVar $jaxbelement = $nullBlock.decl((JType)jaxbElementType, "jaxbElement", (JExpression)JExpr.cast((JType)jaxbElementType, (JExpression)$retVal));
        $nullBlock.assign((JAssignmentTarget)$retVal, (JExpression)$jaxbelement.invoke("getValue"));
        for (JType faultType : exceptionMap.keySet()) {
            JDefinedClass matchingException = exceptionMap.get(faultType);
            JBlock $throwBlock = $methodBody._if((JExpression)JExpr.invoke((JExpression)JExpr.dotclass((JClass)faultType.boxify()), (String)"isInstance").arg((JExpression)$retVal))._then();
            $throwBlock._throw((JExpression)JExpr._new((JClass)matchingException).arg(JExpr.lit((String)Wadl2JavaMessages.INVOCATION_FAILED())).arg((JExpression)JExpr.cast((JType)faultType, (JExpression)$retVal)));
        }
        if (outputRep != null) {
            $methodBody._return((JExpression)JExpr.cast((JType)returnType, (JExpression)$retVal));
        } else {
            $methodBody._return();
        }
    }

    protected void generateDSDBody(MethodNode method, RepresentationNode outputRep, JType returnType, JVar $queryParamValueMap, JVar $headerParamValueMap, RepresentationNode inputRep, JBlock $methodBody) {
        JVar $url = $methodBody.decl((JType)this.codeModel.ref(String.class), "_url", (JExpression)this.$uriBuilder.invoke("buildUri").arg((JExpression)this.$templateMatrixParamValMap).arg((JExpression)$queryParamValueMap));
        JInvocation $executeMethod = this.$dsDispatcher.invoke("do" + method.getName());
        if (method.getName().equals("POST") || method.getName().equals("PUT")) {
            if (inputRep == null) {
                $executeMethod.arg(JExpr._null());
                $executeMethod.arg(JExpr._null());
            } else {
                $executeMethod.arg((JExpression)JExpr.ref((String)"input"));
                $executeMethod.arg(JExpr.lit((String)inputRep.getMediaType()));
            }
        }
        $executeMethod.arg((JExpression)$url);
        $executeMethod.arg((JExpression)$headerParamValueMap);
        if (outputRep != null) {
            $executeMethod.arg(JExpr.lit((String)outputRep.getMediaType()));
        } else {
            $executeMethod.arg(JExpr._null());
        }
        JVar $retVal = $methodBody.decl((JType)this.codeModel.ref(DataSource.class), "_retVal", (JExpression)$executeMethod);
        if (outputRep != null) {
            $methodBody._return((JExpression)$retVal);
        } else {
            $methodBody._return();
        }
    }

    public void generateBeanProperty(JDefinedClass $impl, Param p, boolean isAbstract) {
        JClass propertyType = GeneratorUtil.getJavaType(p, this.codeModel, $impl, this.javaDoc);
        String propertyName = p.getName().substring(0, 1).toUpperCase() + p.getName().substring(1);
        JMethod $getter = $impl.method(1, (JType)propertyType, "get" + propertyName);
        JDocComment jdoc = $getter.javadoc();
        jdoc.append((Object)("Get " + p.getName()));
        this.javaDoc.generateReturnDoc(p, $getter);
        if (!isAbstract) {
            JBlock $getterBody = $getter.body();
            $getterBody._return((JExpression)JExpr.cast((JType)propertyType, (JExpression)this.$templateMatrixParamValMap.invoke("get").arg(JExpr.lit((String)p.getName()))));
        }
        JMethod $setter = $impl.method(1, (JType)this.codeModel.VOID, "set" + propertyName);
        jdoc = $setter.javadoc();
        jdoc.append((Object)("Set " + p.getName()));
        $setter.param((JType)propertyType, GeneratorUtil.makeParamName(p.getName()));
        this.javaDoc.generateParamDoc(p, $setter);
        if (!isAbstract) {
            JBlock $setterBody = $setter.body();
            $setterBody.invoke((JExpression)this.$templateMatrixParamValMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)JExpr.ref((String)GeneratorUtil.makeParamName(p.getName())));
        }
    }
}

