/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.jetbrains.annotations.NotNull;

class ToggleAssociationAction
extends ToggleAction {
    private final FileAssociationsManager myFileAssociationsManager;
    private final PsiFile myPsiFile;
    private final PsiFile myAssoc;

    ToggleAssociationAction(FileAssociationsManager fileAssociationsManager, PsiFile psiFile, PsiFile assoc) {
        super(ToggleAssociationAction.getPath(assoc, psiFile), "Remove Association to " + assoc.getName(), null);
        this.myFileAssociationsManager = fileAssociationsManager;
        this.myPsiFile = psiFile;
        this.myAssoc = assoc;
    }

    private static String getPath(PsiFile assoc, PsiFile psiFile) {
        VirtualFile virtualFile = assoc.getVirtualFile();
        assert (virtualFile != null);
        String path = VfsUtilCore.findRelativePath((VirtualFile)psiFile.getVirtualFile(), (VirtualFile)virtualFile, (char)File.separatorChar);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)assoc.getProject()).getFileIndex();
        Module module = index.getModuleForFile(virtualFile);
        return path != null ? (module != null ? "[" + module.getName() + "] - " + path : path) : virtualFile.getPresentableUrl();
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleAssociationAction.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            ToggleAssociationAction.$$$reportNull$$$0(1);
        }
        assert (!state);
        this.myFileAssociationsManager.removeAssociation(this.myPsiFile, this.myAssoc);
        DaemonCodeAnalyzer.getInstance((Project)AnAction.getEventProject((AnActionEvent)e)).restart();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/ToggleAssociationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

