/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import icons.XpathIcons;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.impl.XsltElementImpl;
import org.intellij.lang.xpath.xslt.util.ParamMatcher;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltTemplateImpl
extends XsltElementImpl
implements XsltTemplate {
    XsltTemplateImpl(XmlTag target) {
        super(target);
    }

    public Icon getIcon(int flags) {
        return XpathIcons.Template;
    }

    @Override
    public String getPresentableText() {
        return this.buildSignature();
    }

    public String buildSignature() {
        StringBuilder sb = new StringBuilder(this.getName());
        XsltParameter[] parameters = this.getParameters();
        if (parameters.length > 0) {
            sb.append(" (");
            for (int i1 = 0; i1 < parameters.length; ++i1) {
                if (i1 > 0) {
                    sb.append(", ");
                }
                if (parameters[i1].hasDefault()) {
                    sb.append("[").append(parameters[i1].getName()).append("]");
                    continue;
                }
                sb.append(parameters[i1].getName());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return "XsltTemplate: " + this.getName();
    }

    @Override
    @NotNull
    public XsltParameter[] getParameters() {
        PsiElement[] elements = ResolveUtil.collect(new ParamMatcher(this.getTag(), null));
        XsltParameter[] xsltParameters = new XsltParameter[elements.length];
        System.arraycopy(elements, 0, xsltParameters, 0, elements.length);
        if (xsltParameters == null) {
            XsltTemplateImpl.$$$reportNull$$$0(0);
        }
        return xsltParameters;
    }

    @Override
    @Nullable
    public XsltParameter getParameter(String name) {
        return (XsltParameter)ResolveUtil.resolve(new ParamMatcher(this.getTag(), name));
    }

    @Override
    @Nullable
    public XPathExpression getMatchExpression() {
        return XsltCodeInsightUtil.getXPathExpression(this, "match");
    }

    @Override
    @Nullable
    public QName getMode() {
        String mode = this.getTag().getAttributeValue("mode");
        return mode != null ? QNameUtil.createQName(mode, (PsiElement)this.getTag()) : null;
    }

    @Override
    public boolean isAbstract() {
        return "true".equals(this.getTag().getAttributeValue("abstract", "urn:idea:xslt-plugin#extensions"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/psi/impl/XsltTemplateImpl", "getParameters"));
    }
}

