/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.KotlinCodeStyleChangedNotification;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"KOTLIN_UPDATE_CODE_STYLE_GROUP_ID", "", "KOTLIN_UPDATE_CODE_STYLE_PROPERTY_NAME", "notifyKotlinStyleUpdateIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "idea-jvm"})
public final class NewCodeStyleNotificationKt {
    private static final String KOTLIN_UPDATE_CODE_STYLE_GROUP_ID = "Update Kotlin code style";
    private static final String KOTLIN_UPDATE_CODE_STYLE_PROPERTY_NAME = "update.kotlin.code.style.notified";

    public static final void notifyKotlinStyleUpdateIfNeeded(@NotNull Project project) {
        PropertiesComponent propertiesComponent;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!FormatterUtilKt.isDefaultOfficialCodeStyle()) {
            return;
        }
        boolean isProjectSettings = CodeStyleSettingsManager.getInstance((Project)project).USE_PER_PROJECT_SETTINGS;
        if (isProjectSettings) {
            PropertiesComponent propertiesComponent2 = PropertiesComponent.getInstance((Project)project);
            propertiesComponent = propertiesComponent2;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent2, (String)"PropertiesComponent.getInstance(project)");
        } else {
            PropertiesComponent propertiesComponent3 = PropertiesComponent.getInstance();
            propertiesComponent = propertiesComponent3;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent3, (String)"PropertiesComponent.getInstance()");
        }
        PropertiesComponent settingsComponent = propertiesComponent;
        if (settingsComponent.getBoolean(KOTLIN_UPDATE_CODE_STYLE_PROPERTY_NAME, false)) {
            return;
        }
        KotlinCodeStyleChangedNotification kotlinCodeStyleChangedNotification = KotlinCodeStyleChangedNotification.Companion.create(project, isProjectSettings);
        if (kotlinCodeStyleChangedNotification == null) {
            return;
        }
        KotlinCodeStyleChangedNotification notification = kotlinCodeStyleChangedNotification;
        notification.setImportant(true);
        NotificationsConfiguration.getNotificationsConfiguration().register(KOTLIN_UPDATE_CODE_STYLE_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        settingsComponent.setValue(KOTLIN_UPDATE_CODE_STYLE_PROPERTY_NAME, true, false);
        notification.notify(project);
    }
}

