/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExtractFunctionForDebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExtractFunctionForDebuggerUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableAnalysisUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractorUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiRangeKt;
import org.jetbrains.kotlin.psi.CopyablePsiUserDataProperty;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.NotNullablePsiCopyableUserDataProperty;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0002\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a$\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a \u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001b\u001a\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0013H\u0002\u001a\u0012\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020\u0013H\u0002\u001a\f\u0010,\u001a\u00020\u001d*\u00020\u0015H\u0002\u001a\f\u0010-\u001a\u00020\u001d*\u00020\u0015H\u0002\u001a\u000e\u0010.\u001a\u0004\u0018\u00010/*\u00020\u0019H\u0002\u001a\f\u00100\u001a\u00020\u001d*\u00020\u0013H\u0002\u001a\f\u00101\u001a\u00020\u001d*\u00020\u0015H\u0002\u001a\f\u00102\u001a\u00020\u001d*\u00020\u0015H\u0002\"3\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\b\u0010\u0000\u001a\u0004\u0018\u00010\u00018B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\"/\u0010\n\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00063"}, d2={"<set-?>", "Lcom/intellij/psi/PsiElement;", "DEBUG_SMART_CAST", "getDEBUG_SMART_CAST", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "setDEBUG_SMART_CAST", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "DEBUG_SMART_CAST$delegate", "Lorg/jetbrains/kotlin/psi/CopyablePsiUserDataProperty;", "", "IS_CONTEXT_ELEMENT", "getIS_CONTEXT_ELEMENT", "(Lcom/intellij/psi/PsiElement;)Z", "setIS_CONTEXT_ELEMENT", "(Lcom/intellij/psi/PsiElement;Z)V", "IS_CONTEXT_ELEMENT$delegate", "Lorg/jetbrains/kotlin/psi/NotNullablePsiCopyableUserDataProperty;", "addDebugExpressionBeforeContextElement", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "contextElement", "addDebugExpressionIntoTmpFileForExtractFunction", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "addImportsToFile", "", "newImportList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "tmpFile", "findElementBefore", "getExpressionToAddDebugExpressionBefore", "getFunctionForExtractedFragment", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionResult;", "breakpointFile", "Lcom/intellij/psi/PsiFile;", "breakpointLine", "replaceByLambdaCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "expression", "wrapInLambdaCall", "clearContextElement", "clearSmartCasts", "findContextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "insertSmartCasts", "markContextElement", "markSmartCasts", "idea-jvm"})
public final class ExtractFunctionForDebuggerUtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final NotNullablePsiCopyableUserDataProperty IS_CONTEXT_ELEMENT$delegate;
    private static final CopyablePsiUserDataProperty DEBUG_SMART_CAST$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinPackage(ExtractFunctionForDebuggerUtilKt.class, (String)"idea-jvm"), "IS_CONTEXT_ELEMENT", "getIS_CONTEXT_ELEMENT(Lcom/intellij/psi/PsiElement;)Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinPackage(ExtractFunctionForDebuggerUtilKt.class, (String)"idea-jvm"), "DEBUG_SMART_CAST", "getDEBUG_SMART_CAST(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;"))};
        Key key = Key.create((String)"IS_CONTEXT_ELEMENT");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"IS_CONTEXT_ELEMENT\")");
        IS_CONTEXT_ELEMENT$delegate = new NotNullablePsiCopyableUserDataProperty(key, (Object)false);
        Key key2 = Key.create((String)"DEBUG_SMART_CAST");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DEBUG_SMART_CAST\")");
        DEBUG_SMART_CAST$delegate = new CopyablePsiUserDataProperty(key2);
    }

    @Nullable
    public static final ExtractionResult getFunctionForExtractedFragment(@NotNull KtCodeFragment codeFragment, @NotNull PsiFile breakpointFile, int breakpointLine) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)breakpointFile, (String)"breakpointFile");
        Function2<AnalysisResult, KtFile, String> getErrorMessageForExtractFunctionResult$ = new Function2<AnalysisResult, KtFile, String>(breakpointFile, codeFragment, breakpointLine){
            final /* synthetic */ PsiFile $breakpointFile;
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ int $breakpointLine;

            @NotNull
            public final String invoke(@NotNull AnalysisResult analysisResult, @NotNull KtFile tmpFile) {
                Intrinsics.checkParameterIsNotNull((Object)analysisResult, (String)"analysisResult");
                Intrinsics.checkParameterIsNotNull((Object)tmpFile, (String)"tmpFile");
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) {
                    Attachment[] attachmentArray = new Attachment[6];
                    attachmentArray[0] = AttachmentUtilsKt.attachmentByPsiFile((PsiFile)((PsiFile)tmpFile));
                    attachmentArray[1] = AttachmentUtilsKt.attachmentByPsiFile((PsiFile)this.$breakpointFile);
                    attachmentArray[2] = AttachmentUtilsKt.attachmentByPsiFile((PsiFile)((PsiFile)this.$codeFragment));
                    attachmentArray[3] = new Attachment("breakpoint.info", "line: " + this.$breakpointLine);
                    Object object = this.$codeFragment.getContext();
                    if (object == null || (object = object.getText()) == null) {
                        object = "null";
                    }
                    attachmentArray[4] = new Attachment("context.info", (String)object);
                    attachmentArray[5] = new Attachment("errors.info", CollectionsKt.joinToString$default((Iterable)analysisResult.getMessages(), (CharSequence)"\n", null, null, (int)0, null, (Function1)getFunctionForExtractedFragment.attachments.1.INSTANCE, (int)30, null));
                    Attachment[] attachments2 = attachmentArray;
                    KotlinEvaluationBuilderKt.getLOG().error((Object)LogMessageEx.createEvent((String)"Internal error during evaluate expression", (String)ExceptionUtil.getThrowableText((Throwable)new Throwable("Extract function fails with " + CollectionsKt.joinToString$default((Iterable)analysisResult.getMessages(), null, null, null, (int)0, null, (Function1)getFunctionForExtractedFragment.1.INSTANCE, (int)31, null))), (Attachment[])new Attachment[]{AttachmentUtilsKt.mergeAttachments((Attachment[])Arrays.copyOf(attachments2, attachments2.length))}));
                }
                return CollectionsKt.joinToString$default((Iterable)analysisResult.getMessages(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<AnalysisResult.ErrorMessage, CharSequence>(this){
                    final /* synthetic */ getFunctionForExtractedFragment.1 this$0;

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final CharSequence invoke(@NotNull AnalysisResult.ErrorMessage errorMessage) {
                        CharSequence charSequence;
                        String string;
                        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                        switch (ExtractFunctionForDebuggerUtilKt$WhenMappings.$EnumSwitchMapping$0[errorMessage.ordinal()]) {
                            case 1: {
                                string = "Cannot perform an action without an expression";
                                break;
                            }
                            case 2: {
                                string = "Cannot perform an action at this breakpoint " + this.this$0.$breakpointFile.getName() + ':' + this.this$0.$breakpointLine;
                                break;
                            }
                            case 3: {
                                string = "Cannot perform an action due to erroneous code";
                                break;
                            }
                            case 4: {
                                string = "Cannot perform an action for expression with super call";
                                break;
                            }
                            case 5: {
                                string = "Cannot perform an action because following types are unavailable from debugger scope";
                                break;
                            }
                            case 6: {
                                string = "Cannot perform an action because this code fragment contains erroneous types";
                                break;
                            }
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: {
                                string = "Cannot perform an action for this expression";
                                break;
                            }
                            case 11: {
                                throw (Throwable)((Object)new AssertionError((Object)("Unexpected error: " + errorMessage)));
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        String message = string;
                        Object object = errorMessage.getAdditionalInfo();
                        if (object != null) {
                            List list2;
                            List it = list2 = object;
                            object = message + ": " + CollectionsKt.joinToString$default((Iterable)it, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                            if (object != null) {
                                charSequence = (CharSequence)object;
                                return charSequence;
                            }
                        }
                        charSequence = message;
                        return charSequence;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)30, null);
            }
            {
                this.$breakpointFile = psiFile;
                this.$codeFragment = ktCodeFragment;
                this.$breakpointLine = n;
                super(2);
            }
        };
        Function0<ExtractionResult> generateFunction$ = new Function0<ExtractionResult>(codeFragment, breakpointLine, getErrorMessageForExtractFunctionResult$){
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ int $breakpointLine;
            final /* synthetic */ getFunctionForExtractedFragment.1 $getErrorMessageForExtractFunctionResult$1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final ExtractionResult invoke() {
                KtFile ktFile = this.$codeFragment.getContextContainingFile();
                if (ktFile == null) {
                    return null;
                }
                KtFile originalFile = ktFile;
                List<KtExpression> newDebugExpressions = ExtractFunctionForDebuggerUtilKt.addDebugExpressionIntoTmpFileForExtractFunction(originalFile, this.$codeFragment, this.$breakpointLine);
                if (newDebugExpressions.isEmpty()) {
                    return null;
                }
                KtFile ktFile2 = ((KtExpression)CollectionsKt.first(newDebugExpressions)).getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"newDebugExpressions.first().containingKtFile");
                KtFile tmpFile = ktFile2;
                if (KotlinEvaluationBuilderKt.getLOG().isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("TMP_FILE:\n" + (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(tmpFile){
                        final /* synthetic */ KtFile $tmpFile;

                        public final String invoke() {
                            return this.$tmpFile.getText();
                        }
                        {
                            this.$tmpFile = ktFile;
                            super(0);
                        }
                    })));
                }
                KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull((List)tmpFile.getDeclarations());
                if (ktDeclaration == null) {
                    return null;
                }
                KtDeclaration targetSibling = ktDeclaration;
                ExtractionOptions options = new ExtractionOptions(false, true, false, true, true, true, 4, null);
                ExtractionData extractionData = new ExtractionData(tmpFile, KotlinPsiRangeKt.toRange$default(newDebugExpressions, (boolean)false, (int)1, null), (PsiElement)targetSibling, null, options);
                try {
                    ExtractableCodeDescriptorWithConflicts validationResult;
                    AnalysisResult analysisResult = ExtractableAnalysisUtilKt.performAnalysis((ExtractionData)extractionData);
                    if (analysisResult.getStatus() != AnalysisResult.Status.SUCCESS) {
                        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)this.$getErrorMessageForExtractFunctionResult$1.invoke(analysisResult, tmpFile));
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026analysisResult, tmpFile))");
                        throw (Throwable)evaluateException;
                    }
                    ExtractableCodeDescriptor extractableCodeDescriptor = analysisResult.getDescriptor();
                    if (extractableCodeDescriptor == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(validationResult = ExtractableAnalysisUtilKt.validate$default((ExtractableCodeDescriptor)extractableCodeDescriptor, null, (int)1, null)).getConflicts().isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder().append("Following declarations are unavailable in debug scope: ");
                        Set set = validationResult.getConflicts().keySet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"validationResult.conflicts.keySet()");
                        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, (Function1)getFunctionForExtractedFragment.2.INSTANCE, (int)30, null)).toString());
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026tring(\",\") { it.text }}\")");
                        throw (Throwable)evaluateException;
                    }
                    ExtractionGeneratorOptions generatorOptions = new ExtractionGeneratorOptions(true, null, KotlinEvaluationBuilderKt.getGENERATED_FUNCTION_NAME(), false, false, 18, null);
                    ExtractionResult extractionResult = ExtractorUtilKt.generateDeclaration$default((ExtractionGeneratorConfiguration)new ExtractionGeneratorConfiguration(validationResult.getDescriptor(), generatorOptions), null, (int)1, null);
                    return extractionResult;
                }
                finally {
                    Disposer.dispose((Disposable)((Disposable)extractionData));
                }
            }
            {
                this.$codeFragment = ktCodeFragment;
                this.$breakpointLine = n;
                this.$getErrorMessageForExtractFunctionResult$1 = var3_3;
                super(0);
            }
        };
        return (ExtractionResult)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<ExtractionResult>(generateFunction$){
            final /* synthetic */ getFunctionForExtractedFragment.2 $generateFunction$2;

            @Nullable
            public final ExtractionResult invoke() {
                return this.$generateFunction$2.invoke();
            }
            {
                this.$generateFunction$2 = var1_1;
                super(0);
            }
        }));
    }

    @NotNull
    public static final List<KtExpression> addDebugExpressionIntoTmpFileForExtractFunction(@NotNull KtFile originalFile, @NotNull KtCodeFragment codeFragment, int line) {
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        ExtractFunctionForDebuggerUtilKt.markContextElement(codeFragment);
        ExtractFunctionForDebuggerUtilKt.markSmartCasts(codeFragment);
        PsiElement psiElement = originalFile.copy();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile tmpFile = (KtFile)psiElement;
        CodeFragmentUtilKt.setSuppressDiagnosticsInDebugMode((KtFile)tmpFile, (boolean)true);
        KtPsiFactoryKt.setAnalysisContext((KtFile)tmpFile, (PsiElement)KtPsiFactoryKt.getAnalysisContext((KtFile)originalFile));
        PsiElement psiElement2 = ExtractFunctionForDebuggerUtilKt.getExpressionToAddDebugExpressionBefore(tmpFile, (PsiElement)codeFragment.getOriginalContext(), line);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement contextElement = psiElement2;
        ExtractFunctionForDebuggerUtilKt.addImportsToFile(codeFragment.importsAsImportList(), tmpFile);
        List<KtExpression> contentElementsInTmpFile = ExtractFunctionForDebuggerUtilKt.addDebugExpressionBeforeContextElement(codeFragment, contextElement);
        Iterable $receiver$iv = contentElementsInTmpFile;
        for (Object element$iv : $receiver$iv) {
            KtExpression it = (KtExpression)element$iv;
            ExtractFunctionForDebuggerUtilKt.insertSmartCasts(it);
        }
        ExtractFunctionForDebuggerUtilKt.clearContextElement(codeFragment);
        ExtractFunctionForDebuggerUtilKt.clearSmartCasts(codeFragment);
        return contentElementsInTmpFile;
    }

    private static final boolean getIS_CONTEXT_ELEMENT(@NotNull PsiElement $receiver) {
        return (Boolean)IS_CONTEXT_ELEMENT$delegate.getValue($receiver, $$delegatedProperties[0]);
    }

    private static final void setIS_CONTEXT_ELEMENT(@NotNull PsiElement $receiver, boolean bl) {
        IS_CONTEXT_ELEMENT$delegate.setValue($receiver, $$delegatedProperties[0], (Object)bl);
    }

    private static final void markContextElement(@NotNull KtCodeFragment $receiver) {
        block0: {
            KtElement ktElement = $receiver.getOriginalContext();
            if (ktElement == null) break block0;
            ExtractFunctionForDebuggerUtilKt.setIS_CONTEXT_ELEMENT((PsiElement)ktElement, true);
        }
    }

    private static final void clearContextElement(@NotNull KtCodeFragment $receiver) {
        block0: {
            KtElement ktElement = $receiver.getOriginalContext();
            if (ktElement == null) break block0;
            ExtractFunctionForDebuggerUtilKt.setIS_CONTEXT_ELEMENT((PsiElement)ktElement, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final KtElement findContextElement(@NotNull KtFile $receiver) {
        void result$iv$iv;
        void $receiver$iv;
        PsiElement psiElement = (PsiElement)$receiver;
        Function1 predicate$iv = findContextElement.1.INSTANCE;
        void $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof KtElement && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                super.visitElement(element);
            }
        });
        return (KtElement)((PsiElement)result$iv$iv.element);
    }

    private static final PsiElement getDEBUG_SMART_CAST(@NotNull PsiElement $receiver) {
        return (PsiElement)DEBUG_SMART_CAST$delegate.getValue($receiver, $$delegatedProperties[1]);
    }

    private static final void setDEBUG_SMART_CAST(@NotNull PsiElement $receiver, PsiElement psiElement) {
        DEBUG_SMART_CAST$delegate.setValue($receiver, $$delegatedProperties[1], (Object)psiElement);
    }

    /*
     * WARNING - void declaration
     */
    private static final void markSmartCasts(@NotNull KtCodeFragment $receiver) {
        block0: {
            void $receiver$iv;
            BindingContext bindingContext2 = (BindingContext)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)((Function0)new Function0<BindingContext>($receiver){
                final /* synthetic */ KtCodeFragment $this_markSmartCasts;

                @NotNull
                public final BindingContext invoke() {
                    KtDeclarationContainer $receiver$iv = (KtDeclarationContainer)this.$this_markSmartCasts;
                    return ResolutionUtils.getResolutionFacade((KtElement)((KtElement)$receiver$iv)).analyzeWithAllCompilerChecks((Collection)CollectionsKt.listOf((Object)$receiver$iv)).getBindingContext();
                }
                {
                    this.$this_markSmartCasts = ktCodeFragment;
                    super(0);
                }
            }));
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            KtPsiFactory factory = new KtPsiFactory(project, false, 2, null);
            KtElement ktElement = $receiver.getContentElement();
            if (ktElement == null) break block0;
            PsiElement psiElement = (PsiElement)ktElement;
            Function1 action$iv = (Function1)new Function1<KtExpression, Unit>(bindingContext2, factory){
                final /* synthetic */ BindingContext $bindingContext;
                final /* synthetic */ KtPsiFactory $factory;

                public final void invoke(@NotNull KtExpression expression) {
                    KotlinType smartCast;
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    ExplicitSmartCasts explicitSmartCasts = (ExplicitSmartCasts)this.$bindingContext.get((ReadOnlySlice)BindingContext.SMARTCAST, (Object)expression);
                    Object object = smartCast = explicitSmartCasts != null ? explicitSmartCasts.getDefaultType() : null;
                    if (smartCast != null) {
                        KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)this.$factory, (String)("($0 as " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(smartCast) + ')'), (Object[])new Object[]{expression}, (boolean)false, (int)4, null);
                        if (ktExpression == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        KtParenthesizedExpression smartCastedExpression = (KtParenthesizedExpression)ktExpression;
                        ExtractFunctionForDebuggerUtilKt.access$setDEBUG_SMART_CAST$p((PsiElement)expression, (PsiElement)smartCastedExpression);
                    }
                }
                {
                    this.$bindingContext = bindingContext2;
                    this.$factory = ktPsiFactory;
                    super(1);
                }
            };
            void $receiver$iv$iv = $receiver$iv;
            $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    PsiElement it = element;
                    super.visitElement(element);
                    if (element instanceof KtExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void insertSmartCasts(@NotNull KtExpression $receiver) {
        void $receiver$iv;
        PsiElement psiElement = (PsiElement)$receiver;
        Function1 action$iv = insertSmartCasts.1.INSTANCE;
        void $receiver$iv$iv = $receiver$iv;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                PsiElement it = element;
                super.visitElement(element);
                if (element instanceof KtExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void clearSmartCasts(@NotNull KtCodeFragment $receiver) {
        block0: {
            void $receiver$iv;
            KtElement ktElement = $receiver.getContentElement();
            if (ktElement == null) break block0;
            PsiElement psiElement = (PsiElement)ktElement;
            Function1 action$iv = clearSmartCasts.1.INSTANCE;
            void $receiver$iv$iv = $receiver$iv;
            $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    PsiElement it = element;
                    super.visitElement(element);
                    if (element instanceof KtExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
        }
    }

    private static final void addImportsToFile(KtImportList newImportList, KtFile tmpFile) {
        if (newImportList != null) {
            List list2 = newImportList.getImports();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"newImportList.imports");
            Collection collection = list2;
            if (!collection.isEmpty()) {
                KtImportList tmpFileImportList = tmpFile.getImportList();
                KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)tmpFile), (boolean)false, (int)2, null);
                if (tmpFileImportList == null) {
                    KtPackageDirective packageDirective = tmpFile.getPackageDirective();
                    tmpFile.addAfter(psiFactory.createNewLine(), (PsiElement)packageDirective);
                    tmpFile.addAfter((PsiElement)newImportList, (PsiElement)tmpFile.getPackageDirective());
                } else {
                    List list3 = newImportList.getImports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"newImportList.imports");
                    Iterable $receiver$iv = list3;
                    for (Object element$iv : $receiver$iv) {
                        KtImportDirective it = (KtImportDirective)element$iv;
                        tmpFileImportList.add(psiFactory.createNewLine());
                        tmpFileImportList.add((PsiElement)it);
                    }
                    tmpFileImportList.add(psiFactory.createNewLine());
                }
            }
        }
    }

    private static final PsiElement getExpressionToAddDebugExpressionBefore(KtFile tmpFile, PsiElement contextElement, int line) {
        PsiElement parentOfParent;
        PsiElement parent;
        KtElement elementAt;
        if (contextElement == null) {
            Integer n = CodeInsightUtils.getStartLineOffset((PsiFile)((PsiFile)tmpFile), (int)line);
            if (n == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"CodeInsightUtils.getStar\u2026ile, line) ?: return null");
            int lineStart = n;
            PsiElement psiElement = tmpFile.findElementAt(lineStart);
            if (psiElement == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"tmpFile.findElementAt(lineStart) ?: return null");
            PsiElement elementAtOffset = psiElement;
            return CodeInsightUtils.getTopmostElementAtOffset((PsiElement)elementAtOffset, (int)lineStart);
        }
        getExpressionToAddDebugExpressionBefore.1 shouldStop$ = getExpressionToAddDebugExpressionBefore.1.INSTANCE;
        KtElement ktElement = elementAt = ExtractFunctionForDebuggerUtilKt.findContextElement(tmpFile);
        Object object = parent = ktElement != null ? ktElement.getParent() : null;
        if (shouldStop$.invoke((PsiElement)elementAt, parent)) {
            return (PsiElement)elementAt;
        }
        PsiElement psiElement = parent;
        Object object2 = parentOfParent = psiElement != null ? psiElement.getParent() : null;
        while (parent != null && parentOfParent != null && !shouldStop$.invoke(parent, parentOfParent)) {
            PsiElement psiElement2 = parent = parent.getParent();
            parentOfParent = psiElement2 != null ? psiElement2.getParent() : null;
        }
        return parent;
    }

    private static final List<KtExpression> addDebugExpressionBeforeContextElement(KtCodeFragment codeFragment, PsiElement contextElement) {
        PsiFile containingFile;
        PsiElement elementBefore = ExtractFunctionForDebuggerUtilKt.findElementBefore(contextElement);
        PsiElement psiElement = elementBefore;
        if (psiElement == null || (psiElement = psiElement.getParent()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement parent = psiElement;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)codeFragment), (boolean)false, (int)2, null);
        parent.addBefore(psiFactory.createNewLine(), elementBefore);
        Function1<KtElement, List<? extends KtExpression>> insertExpression$ = new Function1<KtElement, List<? extends KtExpression>>(parent, elementBefore, psiFactory){
            final /* synthetic */ PsiElement $parent;
            final /* synthetic */ PsiElement $elementBefore;
            final /* synthetic */ KtPsiFactory $psiFactory;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<KtExpression> invoke(@Nullable KtElement expr) {
                KtElement ktElement = expr;
                if (ktElement instanceof KtBlockExpression) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    List list2 = ((KtBlockExpression)expr).getStatements();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"expr.statements");
                    Iterable iterable = $receiver$iv = (Iterable)list2;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        KtElement p1 = (KtElement)element$iv$iv;
                        Iterable list$iv$iv = this.invoke(p1);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                if (ktElement instanceof KtExpression) {
                    PsiElement newDebugExpression = this.$parent.addBefore((PsiElement)expr, this.$elementBefore);
                    if (newDebugExpression == null) {
                        KotlinEvaluationBuilderKt.getLOG().error("Couldn't insert debug expression " + ((KtExpression)expr).getText() + " to context file before " + this.$elementBefore.getText());
                        return CollectionsKt.emptyList();
                    }
                    this.$parent.addBefore(this.$psiFactory.createNewLine(), this.$elementBefore);
                    return CollectionsKt.listOf((Object)((KtExpression)newDebugExpression));
                }
                return CollectionsKt.emptyList();
            }
            {
                this.$parent = psiElement;
                this.$elementBefore = psiElement2;
                this.$psiFactory = ktPsiFactory;
                super(1);
            }
        };
        PsiElement psiElement2 = codeFragment.getContext();
        Object object = containingFile = psiElement2 != null ? psiElement2.getContainingFile() : null;
        if (containingFile instanceof KtCodeFragment) {
            KtElement ktElement = ((KtCodeFragment)containingFile).getContentElement();
            if (!(ktElement instanceof KtExpression)) {
                ktElement = null;
            }
            insertExpression$.invoke((KtElement)((KtExpression)ktElement));
        }
        KtElement ktElement = codeFragment.getContentElement();
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement debugExpression = ktElement;
        return insertExpression$.invoke(debugExpression);
    }

    private static final PsiElement findElementBefore(PsiElement contextElement) {
        PsiElement psiElement;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)contextElement, (boolean)false, (int)2, null);
        Function1<KtClassBody, PsiElement> insertNewInitializer$ = new Function1<KtClassBody, PsiElement>(psiFactory){
            final /* synthetic */ KtPsiFactory $psiFactory;

            @Nullable
            public final PsiElement invoke(@NotNull KtClassBody classBody) {
                KtBlockExpression block;
                Intrinsics.checkParameterIsNotNull((Object)classBody, (String)"classBody");
                KtAnonymousInitializer initializer = this.$psiFactory.createAnonymousInitializer();
                PsiElement psiElement = classBody.addAfter((PsiElement)initializer, classBody.getFirstChild());
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnonymousInitializer");
                }
                KtAnonymousInitializer newInitializer = (KtAnonymousInitializer)psiElement;
                KtBlockExpression ktBlockExpression = block = (KtBlockExpression)newInitializer.getBody();
                return ktBlockExpression != null ? ktBlockExpression.getLastChild() : null;
            }
            {
                this.$psiFactory = ktPsiFactory;
                super(1);
            }
        };
        if (contextElement instanceof KtFile) {
            KtNamedFunction fakeFunction = psiFactory.createFunction("fun _debug_fun_() {}");
            contextElement.add(psiFactory.createNewLine());
            PsiElement psiElement2 = contextElement.add((PsiElement)fakeFunction);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtNamedFunction newFakeFun = (KtNamedFunction)psiElement2;
            KtExpression ktExpression = newFakeFun.getBodyExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"newFakeFun.bodyExpression!!");
            psiElement = ktExpression.getLastChild();
        } else if (contextElement instanceof KtProperty && !((KtProperty)contextElement).isLocal()) {
            KtExpression delegateExpressionOrInitializer = ((KtProperty)contextElement).getDelegateExpressionOrInitializer();
            if (delegateExpressionOrInitializer != null) {
                psiElement = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(delegateExpressionOrInitializer);
            } else {
                KtExpression bodyExpression;
                KtPropertyAccessor getter;
                KtPropertyAccessor ktPropertyAccessor = getter = ((KtProperty)contextElement).getGetter();
                Object object = bodyExpression = ktPropertyAccessor != null ? ktPropertyAccessor.getBodyExpression() : null;
                if (getter != null && bodyExpression != null) {
                    if (!getter.hasBlockBody()) {
                        psiElement = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(bodyExpression);
                    } else {
                        List list2 = ((KtBlockExpression)bodyExpression).getStatements();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"(bodyExpression as KtBlockExpression).statements");
                        psiElement = (PsiElement)CollectionsKt.first((List)list2);
                    }
                } else {
                    psiElement = contextElement;
                }
            }
        } else if (contextElement instanceof KtParameter) {
            KtDeclarationWithBody ktDeclarationWithBody = ((KtParameter)contextElement).getOwnerFunction();
            if (ktDeclarationWithBody == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclarationWithBody, (String)"contextElement.ownerFunction!!");
            KtDeclarationWithBody ownerFunction = ktDeclarationWithBody;
            psiElement = ExtractFunctionForDebuggerUtilKt.findElementBefore((PsiElement)ownerFunction);
        } else if (contextElement instanceof KtPrimaryConstructor) {
            KtClassOrObject classOrObject = ((KtPrimaryConstructor)contextElement).getContainingClassOrObject();
            psiElement = insertNewInitializer$.invoke(KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)classOrObject));
        } else if (contextElement instanceof KtClassOrObject) {
            psiElement = insertNewInitializer$.invoke(KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)((KtClassOrObject)contextElement)));
        } else if (contextElement instanceof KtFunctionLiteral) {
            KtBlockExpression ktBlockExpression = ((KtFunctionLiteral)contextElement).getBodyExpression();
            if (ktBlockExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression, (String)"contextElement.bodyExpression!!");
            KtBlockExpression block = ktBlockExpression;
            List list3 = block.getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"block.statements");
            KtExpression ktExpression = (KtExpression)CollectionsKt.firstOrNull((List)list3);
            psiElement = ktExpression != null ? (PsiElement)ktExpression : block.getLastChild();
        } else if (contextElement instanceof KtDeclarationWithBody && !((KtDeclarationWithBody)contextElement).hasBody()) {
            KtBlockExpression block = psiFactory.createBlock("");
            PsiElement psiElement3 = contextElement.add((PsiElement)block);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            }
            KtBlockExpression newBlock = (KtBlockExpression)psiElement3;
            psiElement = newBlock.getRBrace();
        } else if (contextElement instanceof KtDeclarationWithBody && !((KtDeclarationWithBody)contextElement).hasBlockBody()) {
            KtExpression ktExpression = ((KtDeclarationWithBody)contextElement).getBodyExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"contextElement.bodyExpression!!");
            psiElement = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(ktExpression);
        } else if (contextElement instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)contextElement).hasBlockBody()) {
            KtExpression ktExpression = ((KtDeclarationWithBody)contextElement).getBodyExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            }
            KtBlockExpression block = (KtBlockExpression)ktExpression;
            List list4 = block.getStatements();
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"block.statements");
            KtExpression last = (KtExpression)CollectionsKt.lastOrNull((List)list4);
            KtExpression ktExpression2 = last;
            if (!(ktExpression2 instanceof KtReturnExpression)) {
                ktExpression2 = null;
            }
            KtReturnExpression ktReturnExpression = (KtReturnExpression)ktExpression2;
            psiElement = ktReturnExpression != null ? (PsiElement)ktReturnExpression : block.getRBrace();
        } else if (contextElement instanceof KtWhenEntry) {
            KtExpression entryExpression = ((KtWhenEntry)contextElement).getExpression();
            if (entryExpression instanceof KtBlockExpression) {
                List list5 = ((KtBlockExpression)entryExpression).getStatements();
                Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"entryExpression.statements");
                KtExpression ktExpression = (KtExpression)CollectionsKt.firstOrNull((List)list5);
                psiElement = ktExpression != null ? (PsiElement)ktExpression : ((KtBlockExpression)entryExpression).getLastChild();
            } else {
                KtExpression ktExpression = entryExpression;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                psiElement = ExtractFunctionForDebuggerUtilKt.wrapInLambdaCall(ktExpression);
            }
        } else {
            psiElement = contextElement;
        }
        return psiElement;
    }

    private static final KtCallExpression replaceByLambdaCall(KtExpression expression) {
        KtCallExpression ktCallExpression;
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)expression), (boolean)false, (int)2, null).createExpression("{ \n" + expression.getText() + " \n}()");
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        PsiElement $receiver$iv = (PsiElement)expression;
        KtCallExpression callExpression = (KtCallExpression)ktExpression;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)callExpression);
        PsiElement psiElement = result$iv;
        if (!(psiElement instanceof KtCallExpression)) {
            psiElement = null;
        }
        if ((ktCallExpression = (KtCallExpression)psiElement) == null) {
            PsiElement psiElement2 = result$iv;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement2).getExpression();
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            ktCallExpression = (KtCallExpression)ktExpression2;
        }
        return ktCallExpression;
    }

    private static final PsiElement wrapInLambdaCall(KtExpression expression) {
        KtLambdaExpression ktLambdaExpression;
        KtCallExpression replacedBody = ExtractFunctionForDebuggerUtilKt.replaceByLambdaCall(expression);
        KtExpression ktExpression = replacedBody.getCalleeExpression();
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        return (ktLambdaExpression = (KtLambdaExpression)ktExpression) != null && (ktLambdaExpression = ktLambdaExpression.getBodyExpression()) != null ? ktLambdaExpression.getFirstChild() : null;
    }

    public static final /* synthetic */ boolean access$getIS_CONTEXT_ELEMENT$p(@NotNull PsiElement $receiver) {
        return ExtractFunctionForDebuggerUtilKt.getIS_CONTEXT_ELEMENT($receiver);
    }

    public static final /* synthetic */ void access$setIS_CONTEXT_ELEMENT$p(@NotNull PsiElement $receiver, boolean bl) {
        ExtractFunctionForDebuggerUtilKt.setIS_CONTEXT_ELEMENT($receiver, bl);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$getDEBUG_SMART_CAST$p(@NotNull PsiElement $receiver) {
        return ExtractFunctionForDebuggerUtilKt.getDEBUG_SMART_CAST($receiver);
    }

    public static final /* synthetic */ void access$setDEBUG_SMART_CAST$p(@NotNull PsiElement $receiver, @Nullable PsiElement psiElement) {
        ExtractFunctionForDebuggerUtilKt.setDEBUG_SMART_CAST($receiver, psiElement);
    }
}

