/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.stepping.Action;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProvider;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;

public class DebuggerSteppingHelper {
    public static DebugProcessImpl.ResumeCommand createStepOverCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final KotlinSteppingCommandProvider.KotlinSourcePosition kotlinSourcePosition) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        debugProcessImpl.getClass();
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                debugProcessImpl2.getClass();
                super(debugProcessImpl2, x1);
            }

            public void contextAction() {
                boolean isDexDebug = NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)suspendContext.getDebugProcess());
                try {
                    StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                    if (frameProxy != null) {
                        Action action2 = KotlinSteppingCommandProviderKt.getStepOverAction(frameProxy.location(), kotlinSourcePosition, frameProxy, isDexDebug);
                        DebuggerSteppingHelper.createStepRequest(suspendContext, this.getContextThread(), debugProcess.getVirtualMachineProxy().eventRequestManager(), -2, 3);
                        action2.apply(debugProcess, suspendContext, ignoreBreakpoints);
                        return;
                    }
                    debugProcess.createStepOutCommand(suspendContext).contextAction();
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
            }
        };
    }

    public static DebugProcessImpl.ResumeCommand createStepOutCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final List<KtNamedFunction> inlineFunctions, final KtFunctionLiteral inlineArgument) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        debugProcessImpl.getClass();
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                debugProcessImpl2.getClass();
                super(debugProcessImpl2, x1);
            }

            public void contextAction() {
                try {
                    StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                    if (frameProxy != null) {
                        Action action2 = KotlinSteppingCommandProviderKt.getStepOutAction(frameProxy.location(), suspendContext, inlineFunctions, inlineArgument);
                        DebuggerSteppingHelper.createStepRequest(suspendContext, this.getContextThread(), debugProcess.getVirtualMachineProxy().eventRequestManager(), -2, 3);
                        action2.apply(debugProcess, suspendContext, ignoreBreakpoints);
                        return;
                    }
                    debugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints).contextAction();
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
            }
        };
    }

    private static void createStepRequest(@NotNull SuspendContextImpl suspendContext, @Nullable ThreadReferenceProxyImpl stepThread, @NotNull EventRequestManager requestManager, int size, int depth) {
        if (suspendContext == null) {
            DebuggerSteppingHelper.$$$reportNull$$$0(0);
        }
        if (requestManager == null) {
            DebuggerSteppingHelper.$$$reportNull$$$0(1);
        }
        if (stepThread == null) {
            return;
        }
        try {
            String currentClassName;
            ThreadReference stepThreadReference = stepThread.getThreadReference();
            requestManager.deleteEventRequests(requestManager.stepRequests());
            StepRequest stepRequest = requestManager.createStepRequest(stepThreadReference, size, depth);
            List<ClassFilter> activeFilters = DebuggerSteppingHelper.getActiveFilters();
            if (!(activeFilters.isEmpty() || (currentClassName = DebuggerSteppingHelper.getCurrentClassName(stepThread)) != null && DebuggerUtilsEx.isFiltered((String)currentClassName, activeFilters))) {
                for (ClassFilter filter2 : activeFilters) {
                    stepRequest.addClassExclusionFilter(filter2.getPattern());
                }
            }
            stepRequest.setSuspendPolicy(suspendContext.getSuspendPolicy() == 1 ? 1 : 2);
            stepRequest.enable();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @NotNull
    private static List<ClassFilter> getActiveFilters() {
        ArrayList<ClassFilter> activeFilters = new ArrayList<ClassFilter>();
        DebuggerSettings settings = DebuggerSettings.getInstance();
        if (settings.TRACING_FILTERS_ENABLED) {
            for (ClassFilter classFilter : settings.getSteppingFilters()) {
                if (!classFilter.isEnabled()) continue;
                activeFilters.add(classFilter);
            }
        }
        for (ClassFilter classFilter : (DebuggerClassFilterProvider[])Extensions.getExtensions((ExtensionPointName)DebuggerClassFilterProvider.EP_NAME)) {
            for (ClassFilter filter3 : classFilter.getFilters()) {
                if (!filter3.isEnabled()) continue;
                activeFilters.add(filter3);
            }
        }
        ArrayList<ClassFilter> arrayList = activeFilters;
        if (arrayList == null) {
            DebuggerSteppingHelper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static String getCurrentClassName(ThreadReferenceProxyImpl thread) {
        try {
            StackFrameProxyImpl stackFrame;
            if (thread != null && thread.frameCount() > 0 && (stackFrame = thread.frame(0)) != null) {
                ReferenceType referenceType;
                Location location2 = stackFrame.location();
                ReferenceType referenceType2 = referenceType = location2 == null ? null : location2.declaringType();
                if (referenceType != null) {
                    return referenceType.name();
                }
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/stepping/DebuggerSteppingHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/stepping/DebuggerSteppingHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepRequest";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

