/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.formatter.KotlinPredefinedCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.idea.framework.FrameworkSupportInModuleProviderUtilKt;
import org.jetbrains.kotlin.idea.framework.FrameworksCompatibilityUtils;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JavaFrameworkType;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u00042\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/framework/JavaFrameworkSupportProvider;", "Lcom/intellij/framework/addSupport/FrameworkSupportInModuleProvider;", "()V", "canAddSupport", "", "module", "Lcom/intellij/openapi/module/Module;", "facetsProvider", "Lcom/intellij/openapi/roots/ui/configuration/FacetsProvider;", "createConfigurable", "Lcom/intellij/framework/addSupport/FrameworkSupportInModuleConfigurable;", "model", "Lcom/intellij/ide/util/frameworkSupport/FrameworkSupportModel;", "getFrameworkType", "Lcom/intellij/framework/FrameworkTypeEx;", "isEnabledForModuleType", "moduleType", "Lcom/intellij/openapi/module/ModuleType;", "idea-jvm"})
public final class JavaFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return JavaFrameworkType.Companion.getInstance();
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return new FrameworkSupportInModuleConfigurable(this, model){
            private JavaRuntimeLibraryDescription description;
            final /* synthetic */ JavaFrameworkSupportProvider this$0;
            final /* synthetic */ FrameworkSupportModel $model;

            @Nullable
            public CustomLibraryDescription createLibraryDescription() {
                this.description = new JavaRuntimeLibraryDescription(this.$model.getProject());
                return this.description;
            }

            @Nullable
            public JComponent createComponent() {
                return null;
            }

            public boolean isOnlyLibraryAdded() {
                return true;
            }

            public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
                Intrinsics.checkParameterIsNotNull((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
                FrameworksCompatibilityUtils.suggestRemoveIncompatibleFramework(rootModel, JSLibraryStdDescription.Companion.getSUITABLE_LIBRARY_KINDS(), "Kotlin/\u200bJS");
                JavaRuntimeLibraryDescription javaRuntimeLibraryDescription = this.description;
                if (javaRuntimeLibraryDescription == null) {
                    Intrinsics.throwNpe();
                }
                javaRuntimeLibraryDescription.finishLibConfiguration(module, rootModel, false);
                if (FrameworkSupportInModuleProviderUtilKt.isInNewProject((FrameworkSupportInModuleProvider)this.this$0, (Module)module)) {
                    Project project = module.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                    ProjectCodeStyleImporter.INSTANCE.apply(project, (KotlinPredefinedCodeStyle)KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
                }
            }

            public void onFrameworkSelectionChanged(boolean selected) {
                String providerId;
                if (selected && this.$model.isFrameworkSelected(providerId = "kotlin-js-framework-id")) {
                    this.$model.setFrameworkComponentEnabled(providerId, false);
                }
            }
            {
                this.this$0 = $outer;
                this.$model = $captured_local_variable$1;
            }
        };
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType<?> moduleType) {
        Intrinsics.checkParameterIsNotNull(moduleType, (String)"moduleType");
        return moduleType instanceof JavaModuleType;
    }

    public boolean canAddSupport(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)facetsProvider, (String)"facetsProvider");
        return super.canAddSupport(module, facetsProvider) && Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType((Module)module), (Object)BuildSystemType.JPS.INSTANCE);
    }
}

