/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.highlighter.KotlinSuppressableWarningProblemGroupKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspectionKt;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIJavaVisitor;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIKotlinVisitor;
import org.jetbrains.kotlin.idea.inspections.api.ProblemsCache;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001f\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CustomSuppressableInspectionTool;", "()V", "problems", "", "Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection$Problem;", "getProblems", "()Ljava/util/List;", "setProblems", "(Ljava/util/List;)V", "problemsCache", "Lorg/jetbrains/kotlin/idea/inspections/api/ProblemsCache;", "suppressionKey", "", "getSuppressionKey", "()Ljava/lang/String;", "addProblem", "", "reference", "reason", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/SuppressIntentionAction;", "isSuppressedFor", "readSettings", "node", "Lorg/jdom/Element;", "Companion", "Problem", "idea-jvm"})
public final class IncompatibleAPIInspection
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    @NotNull
    private List<Problem> problems;
    private final ProblemsCache problemsCache;
    @NotNull
    public static final String SHORT_NAME = "IncompatibleAPI";
    @NotNull
    public static final String DEFAULT_REASON = "Incompatible API";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Problem> getProblems() {
        return this.problems;
    }

    public final void setProblems(@NotNull List<Problem> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.problems = list2;
    }

    public final void addProblem(@NotNull String reference, @Nullable String reason) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        this.problems = CollectionsKt.plus((Collection)this.problems, (Object)new Problem(reference, reason));
        this.problemsCache.update(this.problems);
    }

    public void readSettings(@NotNull Element node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super.readSettings(node);
        this.problemsCache.update(this.problems);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        if (this.problems.isEmpty()) {
            PsiElementVisitor psiElementVisitor2 = super.buildVisitor(holder, isOnTheFly);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor2, (String)"super.buildVisitor(holder, isOnTheFly)");
            return psiElementVisitor2;
        }
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"holder.file");
        Language language = psiFile.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            psiElementVisitor = (PsiElementVisitor)new IncompatibleAPIKotlinVisitor(holder, this.problemsCache);
        } else if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            psiElementVisitor = (PsiElementVisitor)new IncompatibleAPIJavaVisitor(holder, this.problemsCache);
        } else {
            PsiElementVisitor psiElementVisitor3 = super.buildVisitor(holder, isOnTheFly);
            psiElementVisitor = psiElementVisitor3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElementVisitor3, (String)"super.buildVisitor(holder, isOnTheFly)");
        }
        return psiElementVisitor;
    }

    @Nullable
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        SuppressIntentionAction[] suppressIntentionActionArray;
        if (element == null) {
            suppressIntentionActionArray = new SuppressIntentionAction[]{};
        } else {
            if (Intrinsics.areEqual((Object)element.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
                HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)this.getShortName());
                if (highlightDisplayKey == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("HighlightDisplayKey.find(" + this.getShortName() + ") is null. Inspection: " + ((Object)((Object)this)).getClass())));
                }
                HighlightDisplayKey key = highlightDisplayKey;
                return SuppressManager.getInstance().createSuppressActions(key);
            }
            if (Intrinsics.areEqual((Object)element.getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
                Collection $receiver$iv;
                HighlightDisplayLevel highlightDisplayLevel = this.getDefaultLevel();
                Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"defaultLevel");
                Collection collection = $receiver$iv = (Collection)KotlinSuppressableWarningProblemGroupKt.createSuppressWarningActions((PsiElement)element, (Severity)AbstractKotlinInspectionKt.toSeverity((HighlightDisplayLevel)highlightDisplayLevel), (String)this.getSuppressionKey());
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                SuppressIntentionAction[] suppressIntentionActionArray2 = thisCollection$iv.toArray(new SuppressIntentionAction[0]);
                if (suppressIntentionActionArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                suppressIntentionActionArray = suppressIntentionActionArray2;
            } else {
                suppressIntentionActionArray = new SuppressIntentionAction[]{};
            }
        }
        return suppressIntentionActionArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        SuppressManager suppressManager = SuppressManager.getInstance();
        if (suppressManager == null) {
            Intrinsics.throwNpe();
        }
        if (suppressManager.isSuppressedFor(element, this.getID())) {
            return true;
        }
        Project project = element.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        Project project2 = project;
        KotlinSuppressCache kotlinSuppressCache = KotlinCacheService.Companion.getInstance(project2).getSuppressionCache();
        String string = this.getSuppressionKey();
        HighlightDisplayLevel highlightDisplayLevel = this.getDefaultLevel();
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightDisplayLevel, (String)"defaultLevel");
        return kotlinSuppressCache.isSuppressed(element, string, AbstractKotlinInspectionKt.toSeverity((HighlightDisplayLevel)highlightDisplayLevel));
    }

    private final String getSuppressionKey() {
        String string = this.getShortName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.shortName");
        return string;
    }

    public IncompatibleAPIInspection() {
        IncompatibleAPIInspection incompatibleAPIInspection = this;
        ArrayList arrayList = new ArrayList();
        incompatibleAPIInspection.problems = arrayList;
        this.problemsCache = new ProblemsCache();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R \u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection$Problem;", "", "reference", "", "reason", "(Ljava/lang/String;Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "setReason", "(Ljava/lang/String;)V", "getReference", "setReference", "idea-jvm"})
    public static final class Problem {
        @Attribute
        @Nullable
        private String reference;
        @Attribute
        @Nullable
        private String reason;

        @Nullable
        public final String getReference() {
            return this.reference;
        }

        public final void setReference(@Nullable String string) {
            this.reference = string;
        }

        @Nullable
        public final String getReason() {
            return this.reason;
        }

        public final void setReason(@Nullable String string) {
            this.reason = string;
        }

        public Problem(@Nullable String reference, @Nullable String reason) {
            this.reference = reference;
            this.reason = reason;
        }

        public /* synthetic */ Problem(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        public Problem() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection$Companion;", "", "()V", "DEFAULT_REASON", "", "SHORT_NAME", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

