/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspection;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspectionKt;
import org.jetbrains.kotlin.idea.inspections.api.ProblemsCache;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.synthetic.JavaSyntheticPropertiesScope;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIKotlinVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "problemsCache", "Lorg/jetbrains/kotlin/idea/inspections/api/ProblemsCache;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lorg/jetbrains/kotlin/idea/inspections/api/ProblemsCache;)V", "checkReference", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitSimpleNameExpression", "idea-jvm"})
public final class IncompatibleAPIKotlinVisitor
extends KtVisitorVoid {
    private final ProblemsHolder holder;
    private final ProblemsCache problemsCache;

    public void visitImportList(@NotNull KtImportList importList) {
        Intrinsics.checkParameterIsNotNull((Object)importList, (String)"importList");
    }

    /*
     * WARNING - void declaration
     */
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        boolean bl;
        block7: {
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            String nameStr = expression.getText();
            if (!Name.isValidIdentifier((String)nameStr)) {
                return;
            }
            HashSet<String> names = new HashSet<String>();
            names.add(nameStr);
            Name name = Name.identifier((String)nameStr);
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(nameStr)");
            List gettersNames = JavaSyntheticPropertiesScope.Companion.possibleGetMethodNames(name);
            if (!gettersNames.isEmpty()) {
                Collection<String> collection;
                void $receiver$iv$iv;
                Iterable iterable = gettersNames;
                HashSet<String> hashSet = names;
                Iterable iterable2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Name name2 = (Name)item$iv$iv;
                    collection = destination$iv$iv;
                    String string = it.getIdentifier();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                hashSet.addAll(collection);
                names.add(JavaSyntheticPropertiesScope.Companion.setMethodName((Name)CollectionsKt.first((List)gettersNames)).getIdentifier());
            }
            if (($receiver$iv = (Iterable)names) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String name3 = (String)element$iv;
                    if (!this.problemsCache.containsWord(name3)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.checkReference(expression);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        super.visitNamedFunction(function);
        KtModifierList ktModifierList = function.getModifierList();
        if ((ktModifierList != null ? ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD) : null) == null) {
            return;
        }
        String funName = function.getName();
        if (funName == null || !this.problemsCache.containsWord(funName)) {
            return;
        }
        FunctionDescriptor functionDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtNamedFunction)function, null, (int)1, null);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        FunctionDescriptor functionDescriptor3 = functionDescriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"functionDescriptor.original");
        Iterator iterator = functionDescriptor3.getOverriddenDescriptors().iterator();
        while (iterator.hasNext()) {
            PsiElement psi;
            FunctionDescriptor overriddenDescriptor;
            FunctionDescriptor functionDescriptor4 = overriddenDescriptor = (FunctionDescriptor)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor4, (String)"overriddenDescriptor");
            SourceElement sourceElement = functionDescriptor4.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"overriddenDescriptor.source");
            if (KotlinSourceElementKt.getPsi((SourceElement)sourceElement) == null) {
                continue;
            }
            IncompatibleAPIInspection.Problem problem = IncompatibleAPIInspectionKt.findProblem(psi, this.problemsCache);
            if (problem == null) continue;
            IncompatibleAPIInspectionKt.registerProblemForElement(function.getNameIdentifier(), this.holder, problem);
            return;
        }
    }

    private final void checkReference(KtSimpleNameExpression expression) {
        if (KtPsiUtilKt.isInImportDirective((KtExpression)((KtExpression)expression))) {
            return;
        }
        for (PsiReference reference : expression.getReferences()) {
            PsiElement resolveTo = reference.resolve();
            IncompatibleAPIInspection.Problem problem = IncompatibleAPIInspectionKt.findProblem(resolveTo, this.problemsCache);
            if (problem == null) {
                continue;
            }
            IncompatibleAPIInspection.Problem problem2 = problem;
            IncompatibleAPIInspectionKt.registerProblemForReference(reference, this.holder, problem2);
            break;
        }
    }

    public IncompatibleAPIKotlinVisitor(@NotNull ProblemsHolder holder, @NotNull ProblemsCache problemsCache) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)problemsCache, (String)"problemsCache");
        this.holder = holder;
        this.problemsCache = problemsCache;
    }
}

