/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/KtScratchFile;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/TextEditor;)V", "getExpressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "psiFile", "Lcom/intellij/psi/PsiFile;", "idea-jvm"})
public final class KtScratchFile
extends ScratchFile {
    @Override
    @NotNull
    public List<ScratchExpression> getExpressions(@NotNull PsiFile psiFile) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"PsiDocumentManager.getIn\u2026le) ?: return emptyList()");
        Document doc = document;
        int line = 0;
        ArrayList<ScratchExpression> result2 = new ArrayList<ScratchExpression>();
        while (line < doc.getLineCount()) {
            Integer n = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)psiFile, (int)line);
            if (n == null) {
                continue;
            }
            int start = n;
            KtElement elementAtOffset = (KtElement)CodeInsightUtils.getTopmostElementAtOffset((PsiElement)PsiUtil.getElementAtOffset((PsiFile)psiFile, (int)start), (int)start, (Class[])new Class[]{KtImportDirective.class, KtDeclaration.class});
            if (elementAtOffset instanceof PsiWhiteSpace) {
                line = doc.getLineNumber(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)elementAtOffset))) + 1;
                continue;
            }
            if (elementAtOffset == null) {
                ++line;
                continue;
            }
            result2.add(new ScratchExpression((PsiElement)elementAtOffset, KotlinRefactoringUtilKt.getLineNumber((PsiElement)((PsiElement)elementAtOffset), (boolean)true), KotlinRefactoringUtilKt.getLineNumber((PsiElement)((PsiElement)elementAtOffset), (boolean)false)));
            line = KotlinRefactoringUtilKt.getLineNumber((PsiElement)((PsiElement)elementAtOffset), (boolean)false) + 1;
        }
        return result2;
    }

    public KtScratchFile(@NotNull Project project, @NotNull TextEditor editor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        super(project, editor);
    }
}

