/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;
import one.util.streamex.StreamExInternals;

class TailConcatSpliterator<T>
implements StreamExInternals.TailSpliterator<T> {
    private Spliterator<T> left;
    private Spliterator<T> right;
    private int characteristics;
    private long size;

    public TailConcatSpliterator(Spliterator<? extends T> left, Spliterator<? extends T> right) {
        this.left = left;
        this.right = right;
        this.characteristics = left.characteristics() & right.characteristics() & 0x4050;
        this.size = left.estimateSize() + right.estimateSize();
        if (this.size < 0L) {
            this.size = Long.MAX_VALUE;
            this.characteristics &= 0xFFFFBFBF;
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.left != null) {
            if (this.left.tryAdvance(action)) {
                if (this.size > 0L && this.size != Long.MAX_VALUE) {
                    --this.size;
                }
                return true;
            }
            this.left = null;
        }
        if (this.right != null) {
            this.right = StreamExInternals.TailSpliterator.tryAdvanceWithTail(this.right, action);
        }
        return this.right != null;
    }

    @Override
    public Spliterator<T> tryAdvanceOrTail(Consumer<? super T> action) {
        if (this.left == null || !this.left.tryAdvance(action)) {
            Spliterator<T> s = this.right;
            this.right = null;
            return s;
        }
        if (this.size > 0L && this.size != Long.MAX_VALUE) {
            --this.size;
        }
        return this;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (this.left != null) {
            this.left.forEachRemaining(action);
        }
        if (this.right != null) {
            StreamExInternals.TailSpliterator.forEachWithTail(this.right, action);
        }
    }

    @Override
    public Spliterator<T> forEachOrTail(Consumer<? super T> action) {
        if (this.left != null) {
            this.left.forEachRemaining(action);
        }
        Spliterator<T> s = this.right;
        this.right = null;
        return s;
    }

    @Override
    public Spliterator<T> trySplit() {
        if (this.left == null) {
            return this.right.trySplit();
        }
        Spliterator<T> s = this.left;
        this.left = null;
        return s;
    }

    @Override
    public long estimateSize() {
        if (this.left == null) {
            return this.right == null ? 0L : this.right.estimateSize();
        }
        return this.size;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

