/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.DefaultCachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactCache;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.ModuleComponentFileArtifactIdentifierSerializer;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentFileArtifactIdentifier;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.resource.cached.AbstractCachedIndex;
import org.gradle.internal.resource.local.FileAccessTracker;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.BuildCommencedTimeProvider;

public class DefaultModuleArtifactCache
extends AbstractCachedIndex<ArtifactAtRepositoryKey, CachedArtifact>
implements ModuleArtifactCache {
    private static final ArtifactAtRepositoryKeySerializer KEY_SERIALIZER = DefaultModuleArtifactCache.keySerializer();
    private static final CachedArtifactSerializer VALUE_SERIALIZER = new CachedArtifactSerializer();
    private final BuildCommencedTimeProvider timeProvider;
    private final Map<ArtifactAtRepositoryKey, CachedArtifact> inMemoryCache = Maps.newConcurrentMap();

    public DefaultModuleArtifactCache(String persistentCacheFile, BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingManager artifactCacheLockingManager, FileAccessTracker fileAccessTracker) {
        super(persistentCacheFile, KEY_SERIALIZER, VALUE_SERIALIZER, artifactCacheLockingManager, fileAccessTracker);
        this.timeProvider = timeProvider;
    }

    protected static ArtifactAtRepositoryKeySerializer keySerializer() {
        DefaultSerializerRegistry serializerRegistry = new DefaultSerializerRegistry();
        serializerRegistry.register(DefaultModuleComponentArtifactIdentifier.class, new ComponentArtifactIdentifierSerializer());
        serializerRegistry.register(ModuleComponentFileArtifactIdentifier.class, new ModuleComponentFileArtifactIdentifierSerializer());
        return new ArtifactAtRepositoryKeySerializer(serializerRegistry.build(ComponentArtifactIdentifier.class));
    }

    @Override
    public void store(ArtifactAtRepositoryKey key, File artifactFile, BigInteger moduleDescriptorHash) {
        this.assertArtifactFileNotNull(artifactFile);
        this.assertKeyNotNull(key);
        this.storeInternal(key, this.createEntry(artifactFile, moduleDescriptorHash));
    }

    private DefaultCachedArtifact createEntry(File artifactFile, BigInteger moduleDescriptorHash) {
        return new DefaultCachedArtifact(artifactFile, this.timeProvider.getCurrentTime(), moduleDescriptorHash);
    }

    @Override
    public void storeMissing(ArtifactAtRepositoryKey key, List<String> attemptedLocations, BigInteger descriptorHash) {
        this.storeInternal(key, this.createMissingEntry(attemptedLocations, descriptorHash));
    }

    private CachedArtifact createMissingEntry(List<String> attemptedLocations, BigInteger descriptorHash) {
        return new DefaultCachedArtifact(attemptedLocations, this.timeProvider.getCurrentTime(), descriptorHash);
    }

    @Override
    protected void storeInternal(ArtifactAtRepositoryKey key, CachedArtifact entry) {
        this.inMemoryCache.put(key, entry);
        super.storeInternal(key, entry);
    }

    @Override
    public CachedArtifact lookup(ArtifactAtRepositoryKey key) {
        this.assertKeyNotNull(key);
        CachedArtifact inMemoryCachedArtifact = this.inMemoryCache.get(key);
        if (inMemoryCachedArtifact != null) {
            return inMemoryCachedArtifact;
        }
        CachedArtifact cachedArtifact = (CachedArtifact)super.lookup(key);
        if (cachedArtifact != null) {
            this.inMemoryCache.put(key, cachedArtifact);
            return cachedArtifact;
        }
        return null;
    }

    @Override
    public void clear(ArtifactAtRepositoryKey key) {
        super.clear(key);
        this.inMemoryCache.remove(key);
    }

    private static class CachedArtifactSerializer
    implements Serializer<CachedArtifact> {
        private CachedArtifactSerializer() {
        }

        @Override
        public void write(Encoder encoder, CachedArtifact value) throws Exception {
            encoder.writeBoolean(value.isMissing());
            encoder.writeLong(value.getCachedAt());
            byte[] hash = value.getDescriptorHash().toByteArray();
            encoder.writeBinary(hash);
            if (!value.isMissing()) {
                encoder.writeString(value.getCachedFile().getPath());
            } else {
                encoder.writeSmallInt(value.attemptedLocations().size());
                for (String location : value.attemptedLocations()) {
                    encoder.writeString(location);
                }
            }
        }

        @Override
        public CachedArtifact read(Decoder decoder) throws Exception {
            boolean isMissing = decoder.readBoolean();
            long createTimestamp = decoder.readLong();
            byte[] encodedHash = decoder.readBinary();
            BigInteger hash = new BigInteger(encodedHash);
            if (!isMissing) {
                File file = new File(decoder.readString());
                return new DefaultCachedArtifact(file, createTimestamp, hash);
            }
            int size = decoder.readSmallInt();
            ArrayList<String> attempted = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                attempted.add(decoder.readString());
            }
            return new DefaultCachedArtifact(attempted, createTimestamp, hash);
        }
    }

    private static class ArtifactAtRepositoryKeySerializer
    implements Serializer<ArtifactAtRepositoryKey> {
        private final Serializer<ComponentArtifactIdentifier> artifactIdSerializer;

        public ArtifactAtRepositoryKeySerializer(Serializer<ComponentArtifactIdentifier> artifactIdSerializer) {
            this.artifactIdSerializer = artifactIdSerializer;
        }

        @Override
        public void write(Encoder encoder, ArtifactAtRepositoryKey value) throws Exception {
            encoder.writeString(value.getRepositoryId());
            this.artifactIdSerializer.write(encoder, value.getArtifactId());
        }

        @Override
        public ArtifactAtRepositoryKey read(Decoder decoder) throws Exception {
            String repositoryId = decoder.readString();
            ComponentArtifactIdentifier artifactIdentifier = this.artifactIdSerializer.read(decoder);
            return new ArtifactAtRepositoryKey(repositoryId, artifactIdentifier);
        }
    }
}

