/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions;

import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultCachedModuleVersionList;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCacheEntry;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.util.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryModuleVersionsCache
implements ModuleVersionsCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultModuleVersionsCache.class);
    private final BuildCommencedTimeProvider timeProvider;
    private final Map<ModuleAtRepositoryKey, ModuleVersionsCacheEntry> inMemoryCache = Maps.newConcurrentMap();

    public InMemoryModuleVersionsCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public void cacheModuleVersionList(ModuleComponentRepository repository, ModuleIdentifier moduleId, Set<String> listedVersions) {
        LOGGER.debug("Caching version list in module versions cache: Using '{}' for '{}'", listedVersions, (Object)moduleId);
        ModuleAtRepositoryKey key = this.createKey(repository, moduleId);
        ModuleVersionsCacheEntry entry = this.createEntry(listedVersions);
        this.store(key, entry);
    }

    protected void store(ModuleAtRepositoryKey key, ModuleVersionsCacheEntry entry) {
        this.inMemoryCache.put(key, entry);
    }

    @Override
    public ModuleVersionsCache.CachedModuleVersionList getCachedModuleResolution(ModuleComponentRepository repository, ModuleIdentifier moduleId) {
        ModuleAtRepositoryKey key = this.createKey(repository, moduleId);
        ModuleVersionsCacheEntry entry = this.get(key);
        return entry == null ? null : this.versionList(entry);
    }

    protected ModuleVersionsCacheEntry get(ModuleAtRepositoryKey key) {
        return this.inMemoryCache.get(key);
    }

    private ModuleVersionsCache.CachedModuleVersionList versionList(ModuleVersionsCacheEntry moduleVersionsCacheEntry) {
        return new DefaultCachedModuleVersionList(moduleVersionsCacheEntry, this.timeProvider);
    }

    private ModuleAtRepositoryKey createKey(ModuleComponentRepository repository, ModuleIdentifier moduleId) {
        return new ModuleAtRepositoryKey(repository.getId(), moduleId);
    }

    private ModuleVersionsCacheEntry createEntry(Set<String> listedVersions) {
        return new ModuleVersionsCacheEntry(listedVersions, this.timeProvider.getCurrentTime());
    }
}

