/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.specs.Spec;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class NoBuildDependenciesArtifactSet
implements ArtifactSet {
    private final ArtifactSet set;

    public NoBuildDependenciesArtifactSet(ArtifactSet set) {
        this.set = set;
    }

    @Override
    public ResolvedArtifactSet select(Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector) {
        ResolvedArtifactSet selectedArtifacts = this.set.select(componentFilter, selector);
        if (selectedArtifacts == ResolvedArtifactSet.EMPTY) {
            return selectedArtifacts;
        }
        return new NoDepsResolvedArtifactSet(selectedArtifacts);
    }

    private static class NoDepsResolvedArtifactSet
    implements ResolvedArtifactSet {
        private final ResolvedArtifactSet selectedArtifacts;

        public NoDepsResolvedArtifactSet(ResolvedArtifactSet selectedArtifacts) {
            this.selectedArtifacts = selectedArtifacts;
        }

        @Override
        public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
            return this.selectedArtifacts.startVisit(actions, listener);
        }

        @Override
        public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
        }
    }
}

