/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.CompositeVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.InverseVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.MessageBuilderHelper;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class RejectedModuleMessageBuilder {
    public String buildFailureMessage(ModuleResolveState module) {
        boolean hasRejectAll = false;
        for (SelectorState candidate : module.getSelectors()) {
            hasRejectAll |= candidate.getVersionConstraint().isRejectAll();
        }
        StringBuilder sb = new StringBuilder();
        if (hasRejectAll) {
            sb.append("Module '").append(module.getId()).append("' has been rejected:\n");
        } else {
            sb.append("Cannot find a version of '").append(module.getId()).append("' that satisfies the version constraints: \n");
        }
        this.renderEdges(sb, module.getIncomingEdges());
        return sb.toString();
    }

    private void renderEdges(StringBuilder sb, Set<EdgeState> incomingEdges) {
        for (EdgeState incomingEdge : incomingEdges) {
            SelectorState selector = incomingEdge.getSelector();
            for (String path : MessageBuilderHelper.pathTo(incomingEdge, false)) {
                sb.append("   ").append(path);
                sb.append(" --> ");
                RejectedModuleMessageBuilder.renderSelector(sb, selector);
                RejectedModuleMessageBuilder.renderReason(sb, selector);
                sb.append("\n");
            }
        }
    }

    static void renderSelector(StringBuilder sb, SelectorState selectorState) {
        ResolvedVersionConstraint constraint = selectorState.getVersionConstraint();
        ModuleIdentifier moduleId = selectorState.getTargetModule().getId();
        sb.append('\'').append(moduleId.getGroup()).append(':').append(moduleId.getName());
        if (constraint.isRejectAll()) {
            sb.append("' rejects all versions");
            return;
        }
        VersionSelector preferredSelector = constraint.getPreferredSelector();
        VersionSelector rejectedSelector = constraint.getRejectedSelector();
        if (rejectedSelector instanceof InverseVersionSelector) {
            sb.append("' strictly '").append(preferredSelector.getSelector()).append("'");
            return;
        }
        if (!constraint.isPrefer()) {
            sb.append(':');
        } else {
            sb.append("' prefers '");
        }
        sb.append(preferredSelector.getSelector()).append("'");
        if (rejectedSelector == null) {
            return;
        }
        sb.append(" rejects ");
        if (rejectedSelector instanceof CompositeVersionSelector) {
            sb.append("any of \"");
            int i = 0;
            for (VersionSelector selector : ((CompositeVersionSelector)rejectedSelector).getSelectors()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append('\'');
                sb.append(selector.getSelector());
                sb.append('\'');
            }
            sb.append("\"");
        } else {
            sb.append('\'');
            sb.append(rejectedSelector.getSelector());
            sb.append('\'');
        }
    }

    private static void renderReason(StringBuilder sb, SelectorState selector) {
        ComponentSelectionReasonInternal selectionReason = selector.getSelectionReason();
        if (selectionReason.hasCustomDescriptions()) {
            sb.append(" because of the following reason");
            ArrayList reasons = Lists.newArrayListWithExpectedSize((int)1);
            for (ComponentSelectionDescriptor componentSelectionDescriptor : selectionReason.getDescriptions()) {
                ComponentSelectionDescriptorInternal next = (ComponentSelectionDescriptorInternal)componentSelectionDescriptor;
                if (!next.hasCustomDescription()) continue;
                reasons.add(next.getDescription());
            }
            if (reasons.size() == 1) {
                sb.append(": ").append((String)reasons.get(0));
            } else {
                sb.append("s: ");
                Joiner.on((String)", ").appendTo(sb, (Iterable)reasons);
            }
        }
    }
}

