/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildableSingleResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformArtifactOperation;
import org.gradle.api.internal.artifacts.transform.TransformFileOperation;
import org.gradle.api.internal.artifacts.transform.UserCodeBackedTransformer;
import org.gradle.execution.taskgraph.TaskDependencyResolver;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public abstract class TransformInfo
extends WorkInfo {
    private static final AtomicInteger ORDER_COUNTER = new AtomicInteger();
    private final int order = ORDER_COUNTER.incrementAndGet();
    protected final UserCodeBackedTransformer artifactTransformer;
    protected List<File> result;
    protected Throwable failure;

    public static TransformInfo chained(UserCodeBackedTransformer current, TransformInfo previous, ComponentArtifactIdentifier artifactId) {
        return new ChainedTransformInfo(current, previous, artifactId);
    }

    public static TransformInfo initial(UserCodeBackedTransformer initial, BuildableSingleResolvedArtifactSet artifact) {
        return new InitialTransformInfo(initial, artifact);
    }

    protected TransformInfo(UserCodeBackedTransformer artifactTransformer) {
        this.artifactTransformer = artifactTransformer;
    }

    public abstract void execute(BuildOperationExecutor var1);

    @Override
    public String toString() {
        return this.artifactTransformer.getDisplayName();
    }

    private List<File> getResult() {
        if (this.failure != null) {
            throw new IllegalStateException("Transformation has failed", this.failure);
        }
        if (this.result == null) {
            throw new IllegalStateException("Transformation hasn't been executed yet");
        }
        return this.result;
    }

    @Nullable
    private Throwable getFailure() {
        if (this.result == null) {
            throw new IllegalStateException("Transformation hasn't been executed yet");
        }
        return this.failure;
    }

    @Override
    public void prepareForExecution() {
    }

    @Override
    public void collectTaskInto(ImmutableCollection.Builder<Task> builder) {
    }

    @Override
    public Throwable getWorkFailure() {
        return null;
    }

    @Override
    public void rethrowFailure() {
    }

    @Override
    public int compareTo(WorkInfo other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        TransformInfo otherTransform = (TransformInfo)other;
        return this.order - otherTransform.order;
    }

    private static class ResolveOnlyAsyncArtifactListener
    implements ResolvedArtifactSet.AsyncArtifactListener {
        private ResolveOnlyAsyncArtifactListener() {
        }

        @Override
        public void artifactAvailable(ResolvableArtifact artifact) {
        }

        @Override
        public boolean requireArtifactFiles() {
            return true;
        }

        @Override
        public boolean includeFileDependencies() {
            return false;
        }

        @Override
        public void fileAvailable(File file) {
        }
    }

    private static class ResolveArtifacts
    implements Action<BuildOperationQueue<RunnableBuildOperation>> {
        private final ResolvedArtifactSet artifactSet;
        private ResolvedArtifactSet.Completion result;

        public ResolveArtifacts(ResolvedArtifactSet artifactSet) {
            this.artifactSet = artifactSet;
        }

        @Override
        public void execute(BuildOperationQueue<RunnableBuildOperation> actions) {
            this.result = this.artifactSet.startVisit(actions, new ResolveOnlyAsyncArtifactListener());
        }

        public ResolvedArtifactSet.Completion getResult() {
            return this.result;
        }
    }

    private static class ChainedTransformInfo
    extends TransformInfo {
        private final TransformInfo previousTransform;
        private final ComponentArtifactIdentifier artifactId;

        public ChainedTransformInfo(UserCodeBackedTransformer artifactTransformer, TransformInfo previousTransform, ComponentArtifactIdentifier artifactId) {
            super(artifactTransformer);
            this.previousTransform = previousTransform;
            this.artifactId = artifactId;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor) {
            ChainedArtifactTransformStepOperation chainedArtifactTransformStep = new ChainedArtifactTransformStepOperation();
            buildOperationExecutor.run(chainedArtifactTransformStep);
            this.result = chainedArtifactTransformStep.getResult();
            this.failure = chainedArtifactTransformStep.getFailure();
        }

        @Override
        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<WorkInfo> processHardSuccessor) {
            this.addDependencySuccessor(this.previousTransform);
            processHardSuccessor.execute(this.previousTransform);
        }

        private class ChainedArtifactTransformStepOperation
        implements RunnableBuildOperation {
            private List<File> result;
            private Throwable failure;

            private ChainedArtifactTransformStepOperation() {
            }

            @Override
            public void run(BuildOperationContext context) {
                Throwable previousFailure = ChainedTransformInfo.this.previousTransform.getFailure();
                if (previousFailure != null) {
                    this.failure = previousFailure;
                    this.result = Collections.emptyList();
                    return;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (File inputFile : ChainedTransformInfo.this.previousTransform.getResult()) {
                    TransformFileOperation operation = new TransformFileOperation(inputFile, ChainedTransformInfo.this.artifactTransformer);
                    operation.run(context);
                    if (operation.getFailure() != null) {
                        this.failure = operation.getFailure();
                        this.result = Collections.emptyList();
                        return;
                    }
                    List<File> result = operation.getResult();
                    if (result == null) continue;
                    builder.addAll(result);
                }
                this.result = builder.build();
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                String displayName = "Transform " + ChainedTransformInfo.this.artifactId.getDisplayName() + " with " + ChainedTransformInfo.this.artifactTransformer.getDisplayName();
                return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.TRANSFORM);
            }

            public List<File> getResult() {
                return this.result;
            }

            public Throwable getFailure() {
                return this.failure;
            }
        }
    }

    private static class InitialTransformInfo
    extends TransformInfo {
        private final BuildableSingleResolvedArtifactSet artifactSet;

        public InitialTransformInfo(UserCodeBackedTransformer artifactTransformer, BuildableSingleResolvedArtifactSet artifactSet) {
            super(artifactTransformer);
            this.artifactSet = artifactSet;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor) {
            InitialArtifactTransformationStepOperation transformationStep = new InitialArtifactTransformationStepOperation(buildOperationExecutor);
            buildOperationExecutor.run(transformationStep);
            this.result = transformationStep.getResult();
            this.failure = transformationStep.getFailure();
        }

        @Override
        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<WorkInfo> processHardSuccessor) {
            Set<WorkInfo> dependencies = this.getDependencies(dependencyResolver);
            for (WorkInfo dependency : dependencies) {
                this.addDependencySuccessor(dependency);
                processHardSuccessor.execute(dependency);
            }
        }

        private Set<WorkInfo> getDependencies(TaskDependencyResolver dependencyResolver) {
            return dependencyResolver.resolveDependenciesFor(null, this.artifactSet.getBuildDependencies());
        }

        private class InitialArtifactTransformationStepOperation
        implements RunnableBuildOperation {
            private List<File> result;
            private Throwable failure;
            private final BuildOperationExecutor buildOperationExecutor;

            public InitialArtifactTransformationStepOperation(BuildOperationExecutor buildOperationExecutor) {
                this.buildOperationExecutor = buildOperationExecutor;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                String displayName = "Transform " + InitialTransformInfo.this.artifactSet.getArtifactId().getDisplayName() + " with " + InitialTransformInfo.this.artifactTransformer.getDisplayName();
                return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.TRANSFORM);
            }

            @Override
            public void run(BuildOperationContext context) {
                ResolveArtifacts resolveArtifacts = new ResolveArtifacts(InitialTransformInfo.this.artifactSet);
                this.buildOperationExecutor.runAll(resolveArtifacts);
                ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor();
                resolveArtifacts.getResult().visit(visitor);
                Set<Throwable> failures = visitor.getFailures();
                if (!failures.isEmpty()) {
                    Throwable failure = failures.size() == 1 && Iterables.getOnlyElement(failures) instanceof ResolveException ? (Throwable)Iterables.getOnlyElement(failures) : new DefaultLenientConfiguration.ArtifactResolveException("artifacts", InitialTransformInfo.this.artifactTransformer.getDisplayName(), "artifact transform", failures);
                    this.failure = failure;
                    this.result = Collections.emptyList();
                    return;
                }
                ResolvedArtifactResult artifact = (ResolvedArtifactResult)Iterables.getOnlyElement(visitor.getArtifacts());
                TransformArtifactOperation operation = new TransformArtifactOperation(artifact.getId(), artifact.getFile(), InitialTransformInfo.this.artifactTransformer);
                operation.run(context);
                this.failure = operation.getFailure();
                this.result = operation.getResult();
            }

            public List<File> getResult() {
                return this.result;
            }

            public Throwable getFailure() {
                return this.failure;
            }
        }
    }
}

