/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshotBuilder;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshotFilter;
import org.gradle.api.internal.changedetection.state.mirror.MirrorUpdatingDirectoryWalker;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalFileSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalMissingSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

@NonNullApi
public class DefaultFileSystemSnapshotter
implements FileSystemSnapshotter {
    private final FileHasher hasher;
    private final StringInterner stringInterner;
    private final FileSystem fileSystem;
    private final FileSystemMirror fileSystemMirror;
    private final ProducerGuard<String> producingSnapshots = ProducerGuard.striped();
    private final MirrorUpdatingDirectoryWalker mirrorUpdatingDirectoryWalker;

    public DefaultFileSystemSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, FileSystemMirror fileSystemMirror) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.fileSystem = fileSystem;
        this.fileSystemMirror = fileSystemMirror;
        this.mirrorUpdatingDirectoryWalker = new MirrorUpdatingDirectoryWalker(hasher, fileSystem, stringInterner);
    }

    @Override
    public boolean exists(File file) {
        FileMetadataSnapshot metadata = this.fileSystemMirror.getMetadata(file.getAbsolutePath());
        if (metadata != null) {
            return metadata.getType() != FileType.Missing;
        }
        PhysicalSnapshot snapshot = this.fileSystemMirror.getSnapshot(file.getAbsolutePath());
        if (snapshot != null) {
            return snapshot.getType() != FileType.Missing;
        }
        return file.exists();
    }

    @Override
    public HashCode getRegularFileContentHash(final File file) {
        final String absolutePath = file.getAbsolutePath();
        FileMetadataSnapshot metadata = this.fileSystemMirror.getMetadata(absolutePath);
        if (metadata != null) {
            if (metadata.getType() != FileType.RegularFile) {
                return null;
            }
            PhysicalSnapshot snapshot = this.fileSystemMirror.getSnapshot(absolutePath);
            if (snapshot != null) {
                return snapshot.getHash();
            }
        }
        return this.producingSnapshots.guardByKey(absolutePath, new Factory<HashCode>(){

            @Override
            @Nullable
            public HashCode create() {
                InternableString internableAbsolutePath = new InternableString(absolutePath);
                FileMetadataSnapshot metadata = DefaultFileSystemSnapshotter.this.statAndCache(internableAbsolutePath, file);
                if (metadata.getType() != FileType.RegularFile) {
                    return null;
                }
                PhysicalSnapshot snapshot = DefaultFileSystemSnapshotter.this.snapshotAndCache(internableAbsolutePath, file, metadata, null);
                return snapshot.getHash();
            }
        });
    }

    @Override
    public PhysicalSnapshot snapshot(final File file) {
        String absolutePath = file.getAbsolutePath();
        PhysicalSnapshot result = this.fileSystemMirror.getSnapshot(absolutePath);
        if (result == null) {
            result = this.producingSnapshots.guardByKey(absolutePath, new Factory<PhysicalSnapshot>(){

                @Override
                public PhysicalSnapshot create() {
                    return DefaultFileSystemSnapshotter.this.snapshotAndCache(file, null);
                }
            });
        }
        return result;
    }

    @Override
    public List<FileSystemSnapshot> snapshot(FileCollectionInternal fileCollection) {
        FileCollectionVisitorImpl visitor = new FileCollectionVisitorImpl();
        fileCollection.visitRootElements(visitor);
        return visitor.getRoots();
    }

    private PhysicalSnapshot snapshotAndCache(File file, @Nullable PatternSet patternSet) {
        InternableString internableAbsolutePath = new InternableString(file.getAbsolutePath());
        FileMetadataSnapshot metadata = this.statAndCache(internableAbsolutePath, file);
        return this.snapshotAndCache(internableAbsolutePath, file, metadata, patternSet);
    }

    private FileMetadataSnapshot statAndCache(InternableString internableAbsolutePath, File file) {
        FileMetadataSnapshot metadata = this.fileSystemMirror.getMetadata(internableAbsolutePath.asNonInterned());
        if (metadata == null) {
            metadata = this.fileSystem.stat(file);
            this.fileSystemMirror.putMetadata(internableAbsolutePath.asInterned(), metadata);
        }
        return metadata;
    }

    private PhysicalSnapshot snapshotAndCache(InternableString internableAbsolutePath, File file, FileMetadataSnapshot metadata, @Nullable PatternSet patternSet) {
        PhysicalSnapshot physicalSnapshot = this.fileSystemMirror.getSnapshot(internableAbsolutePath.asNonInterned());
        if (physicalSnapshot == null) {
            MutableBoolean hasBeenFiltered = new MutableBoolean(false);
            physicalSnapshot = this.snapshot(internableAbsolutePath.asInterned(), patternSet, file, metadata, hasBeenFiltered);
            if (!hasBeenFiltered.get()) {
                this.fileSystemMirror.putSnapshot(physicalSnapshot);
            }
        }
        return physicalSnapshot;
    }

    private PhysicalSnapshot snapshot(String absolutePath, @Nullable PatternSet patternSet, File file, FileMetadataSnapshot metadata, MutableBoolean hasBeenFiltered) {
        String name = this.stringInterner.intern(file.getName());
        switch (metadata.getType()) {
            case Missing: {
                return new PhysicalMissingSnapshot(absolutePath, name);
            }
            case RegularFile: {
                return new PhysicalFileSnapshot(absolutePath, name, this.hasher.hash(file, metadata), metadata.getLastModified());
            }
            case Directory: {
                return this.mirrorUpdatingDirectoryWalker.walkDir(absolutePath, patternSet, hasBeenFiltered);
            }
        }
        throw new IllegalArgumentException("Unrecognized file type: " + (Object)((Object)metadata.getType()));
    }

    @VisibleForTesting
    FileSystemSnapshot snapshotDirectoryTree(final DirectoryFileTree dirTree) {
        final String path = dirTree.getDir().getAbsolutePath();
        final PatternSet patterns = dirTree.getPatterns();
        PhysicalSnapshot snapshot = this.fileSystemMirror.getSnapshot(path);
        if (snapshot != null) {
            return this.filterSnapshot(snapshot, patterns);
        }
        return this.producingSnapshots.guardByKey(path, new Factory<FileSystemSnapshot>(){

            @Override
            public FileSystemSnapshot create() {
                PhysicalSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getSnapshot(path);
                if (snapshot == null) {
                    snapshot = DefaultFileSystemSnapshotter.this.snapshotAndCache(dirTree.getDir(), patterns);
                    return snapshot.getType() == FileType.Missing ? FileSystemSnapshot.EMPTY : snapshot;
                }
                return DefaultFileSystemSnapshotter.this.filterSnapshot(snapshot, patterns);
            }
        });
    }

    private FileSystemSnapshot snapshotTree(FileTreeInternal tree) {
        final FileSystemSnapshotBuilder builder = new FileSystemSnapshotBuilder(this.stringInterner);
        tree.visitTreeOrBackingFile(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
                builder.addDir(dirDetails.getFile(), dirDetails.getRelativePath().getSegments());
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                builder.addFile(fileDetails.getFile(), fileDetails.getRelativePath().getSegments(), this.physicalFileSnapshot(fileDetails));
            }

            private PhysicalFileSnapshot physicalFileSnapshot(FileVisitDetails fileDetails) {
                return new PhysicalFileSnapshot(DefaultFileSystemSnapshotter.this.stringInterner.intern(fileDetails.getFile().getAbsolutePath()), fileDetails.getName(), DefaultFileSystemSnapshotter.this.hasher.hash(fileDetails), fileDetails.getLastModified());
            }
        });
        return builder.build();
    }

    private FileSystemSnapshot filterSnapshot(PhysicalSnapshot snapshot, PatternSet patterns) {
        if (patterns.isEmpty()) {
            return snapshot;
        }
        if (snapshot.getType() == FileType.Missing) {
            return FileSystemSnapshot.EMPTY;
        }
        Spec<FileTreeElement> spec = patterns.getAsSpec();
        return FileSystemSnapshotFilter.filterSnapshot(spec, snapshot, this.fileSystem);
    }

    private class InternableString {
        private String string;
        private boolean interned;

        public InternableString(String nonInternedString) {
            this.string = nonInternedString;
        }

        public String asInterned() {
            if (!this.interned) {
                this.interned = true;
                this.string = DefaultFileSystemSnapshotter.this.stringInterner.intern(this.string);
            }
            return this.string;
        }

        public String asNonInterned() {
            return this.string;
        }
    }

    private class FileCollectionVisitorImpl
    implements FileCollectionVisitor {
        private final List<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();

        private FileCollectionVisitorImpl() {
        }

        @Override
        public void visitCollection(FileCollectionInternal fileCollection) {
            for (File file : fileCollection) {
                PhysicalSnapshot fileSnapshot = DefaultFileSystemSnapshotter.this.snapshot(file);
                this.roots.add(fileSnapshot);
            }
        }

        @Override
        public void visitTree(FileTreeInternal fileTree) {
            FileSystemSnapshot treeSnapshot = DefaultFileSystemSnapshotter.this.snapshotTree(fileTree);
            this.roots.add(treeSnapshot);
        }

        @Override
        public void visitDirectoryTree(DirectoryFileTree directoryTree) {
            FileSystemSnapshot treeSnapshot = DefaultFileSystemSnapshotter.this.snapshotDirectoryTree(directoryTree);
            this.roots.add(treeSnapshot);
        }

        public List<FileSystemSnapshot> getRoots() {
            return this.roots;
        }
    }
}

