/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state.mirror;

import java.util.List;
import org.gradle.api.internal.changedetection.state.mirror.AbstractPhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;

public class PhysicalDirectorySnapshot
extends AbstractPhysicalSnapshot
implements PhysicalSnapshot {
    private final List<PhysicalSnapshot> children;
    private final HashCode contentHash;

    public PhysicalDirectorySnapshot(String absolutePath, String name, List<PhysicalSnapshot> children, HashCode contentHash) {
        super(absolutePath, name);
        this.children = children;
        this.contentHash = contentHash;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    @Override
    public FileType getType() {
        return FileType.Directory;
    }

    @Override
    public boolean isContentAndMetadataUpToDate(PhysicalSnapshot other) {
        return other instanceof PhysicalDirectorySnapshot;
    }

    @Override
    public void accept(PhysicalSnapshotVisitor visitor) {
        if (!visitor.preVisitDirectory(this)) {
            return;
        }
        for (PhysicalSnapshot child : this.children) {
            child.accept(visitor);
        }
        visitor.postVisitDirectory(this);
    }
}

