/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecWrapper;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.file.copy.DestinationRootCopySpec;
import org.gradle.api.internal.file.copy.FileCopyAction;
import org.gradle.api.internal.file.copy.SyncCopyActionDecorator;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.reflect.Instantiator;

public class FileCopier {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final FileLookup fileLookup;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public FileCopier(Instantiator instantiator, FileResolver fileResolver, FileLookup fileLookup, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
        this.fileLookup = fileLookup;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
    }

    private DestinationRootCopySpec createCopySpec(Action<? super CopySpec> action) {
        DefaultCopySpec copySpec = new DefaultCopySpec(this.fileResolver, this.instantiator);
        DestinationRootCopySpec destinationRootCopySpec = new DestinationRootCopySpec(this.fileResolver, copySpec);
        CopySpec wrapped = this.instantiator.newInstance(CopySpecWrapper.class, destinationRootCopySpec);
        action.execute(wrapped);
        return destinationRootCopySpec;
    }

    public WorkResult copy(Action<? super CopySpec> action) {
        DestinationRootCopySpec copySpec = this.createCopySpec(action);
        File destinationDir = copySpec.getDestinationDir();
        return this.doCopy(copySpec, this.getCopyVisitor(destinationDir));
    }

    public WorkResult sync(Action<? super CopySpec> action) {
        DestinationRootCopySpec copySpec = this.createCopySpec(action);
        File destinationDir = copySpec.getDestinationDir();
        return this.doCopy(copySpec, new SyncCopyActionDecorator(destinationDir, this.getCopyVisitor(destinationDir), this.directoryFileTreeFactory));
    }

    private FileCopyAction getCopyVisitor(File destination) {
        return new FileCopyAction(this.fileLookup.getFileResolver(destination));
    }

    private WorkResult doCopy(CopySpecInternal copySpec, CopyAction visitor) {
        CopyActionExecuter visitorDriver = new CopyActionExecuter(this.instantiator, this.fileLookup.getFileSystem(), false);
        return visitorDriver.execute(copySpec, visitor);
    }
}

