/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins.osgi;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePluginConvention;

public class OsgiHelper {
    private static final Pattern OSGI_VERSION_PATTERN = Pattern.compile("[0-9]+(\\.[0-9]+(\\.[0-9]+(\\.[0-9A-Za-z_-]+)?)?)?");
    private static final Pattern ONLY_NUMBERS = Pattern.compile("[0-9]+");
    private static final Pattern QUALIFIER = Pattern.compile("[0-9A-Za-z_\\-]*");

    public String getBundleSymbolicName(Project project) {
        String lastSection;
        String group = project.getGroup().toString();
        String archiveBaseName = project.getConvention().getPlugin(BasePluginConvention.class).getArchivesBaseName();
        if (archiveBaseName.startsWith(group)) {
            return archiveBaseName;
        }
        int i = group.lastIndexOf(46);
        if (archiveBaseName.equals(lastSection = group.substring(++i))) {
            return group;
        }
        if (archiveBaseName.startsWith(lastSection)) {
            String artifactId = archiveBaseName.substring(lastSection.length());
            if (Character.isLetterOrDigit(artifactId.charAt(0))) {
                return this.getBundleSymbolicName(group, artifactId);
            }
            return this.getBundleSymbolicName(group, artifactId.substring(1));
        }
        return this.getBundleSymbolicName(group, archiveBaseName);
    }

    private String getBundleSymbolicName(String groupId, String artifactId) {
        return groupId + "." + artifactId;
    }

    public String getVersion(String version) {
        Matcher m = OSGI_VERSION_PATTERN.matcher(version);
        if (m.matches()) {
            return version;
        }
        int group = 0;
        boolean groupToken = true;
        String[] groups = new String[]{"0", "0", "0", ""};
        StringTokenizer st = new StringTokenizer(version, ",./;'?:\\|=+-_*&^%$#@!~", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (groupToken) {
                if (group < 3) {
                    if (ONLY_NUMBERS.matcher(token).matches()) {
                        groups[group++] = token;
                        groupToken = false;
                        continue;
                    }
                    groups[3] = token + this.fillQualifier(st);
                    continue;
                }
                groups[3] = token + this.fillQualifier(st);
                continue;
            }
            if (".".equals(token)) {
                groupToken = true;
                continue;
            }
            groups[3] = this.fillQualifier(st);
        }
        String ver = groups[0] + "." + groups[1] + "." + groups[2];
        String result = groups[3].length() > 0 ? ver + "." + groups[3] : ver;
        if (!OSGI_VERSION_PATTERN.matcher(result).matches()) {
            throw new GradleException("OSGi plugin unable to convert version to a compliant version");
        }
        return result;
    }

    private String fillQualifier(StringTokenizer st) {
        StringBuilder buf = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (QUALIFIER.matcher(token).matches()) {
                buf.append(token);
                continue;
            }
            buf.append("_");
        }
        return buf.toString();
    }
}

