/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.util.MergeOptionsUtil;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.SimpleActionExecutionSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerFactory;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;
    private final WorkerFactory workerFactory;

    public AbstractDaemonCompiler(Compiler<T> delegate, WorkerFactory workerFactory) {
        this.delegate = delegate;
        this.workerFactory = workerFactory;
    }

    public Compiler<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public WorkResult execute(T spec) {
        InvocationContext invocationContext = this.toInvocationContext(spec);
        DaemonForkOptions daemonForkOptions = invocationContext.getDaemonForkOptions();
        Worker worker = this.workerFactory.getWorker(daemonForkOptions);
        DefaultWorkResult result = worker.execute(new SimpleActionExecutionSpec(CompilerCallable.class, "compiler daemon", invocationContext.getInvocationWorkingDir(), new Object[]{this.delegate, spec}));
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException(result.getException());
    }

    protected abstract InvocationContext toInvocationContext(T var1);

    protected BaseForkOptions mergeForkOptions(BaseForkOptions left, BaseForkOptions right) {
        BaseForkOptions merged = new BaseForkOptions();
        merged.setMemoryInitialSize(MergeOptionsUtil.mergeHeapSize(left.getMemoryInitialSize(), right.getMemoryInitialSize()));
        merged.setMemoryMaximumSize(MergeOptionsUtil.mergeHeapSize(left.getMemoryMaximumSize(), right.getMemoryMaximumSize()));
        Set<String> mergedJvmArgs = MergeOptionsUtil.normalized(left.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized(right.getJvmArgs()));
        merged.setJvmArgs(Lists.newArrayList(mergedJvmArgs));
        return merged;
    }

    protected static class InvocationContext {
        private File invocationWorkingDir;
        private DaemonForkOptions daemonForkOptions;

        public InvocationContext(File invocationWorkingDir, DaemonForkOptions daemonForkOptions) {
            this.invocationWorkingDir = invocationWorkingDir;
            this.daemonForkOptions = daemonForkOptions;
        }

        File getInvocationWorkingDir() {
            return this.invocationWorkingDir;
        }

        DaemonForkOptions getDaemonForkOptions() {
            return this.daemonForkOptions;
        }

        public InvocationContext mergeWith(InvocationContext invocationContext) {
            if (!this.getInvocationWorkingDir().equals(invocationContext.getInvocationWorkingDir())) {
                throw new IllegalArgumentException("Cannot merge an InvocationContext with a different invocation working directory (this: " + this.getInvocationWorkingDir() + ", other: " + invocationContext.getInvocationWorkingDir() + ").");
            }
            DaemonForkOptions mergedForkOptions = this.getDaemonForkOptions().mergeWith(invocationContext.getDaemonForkOptions());
            return new InvocationContext(this.getInvocationWorkingDir(), mergedForkOptions);
        }
    }

    private static class CompilerCallable<T extends CompileSpec>
    implements Callable<WorkResult> {
        private final Compiler<T> compiler;
        private final T compileSpec;

        @Inject
        public CompilerCallable(Compiler<T> compiler, T compileSpec) {
            this.compiler = compiler;
            this.compileSpec = compileSpec;
        }

        @Override
        public WorkResult call() throws Exception {
            return this.compiler.execute(this.compileSpec);
        }
    }
}

