/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotFactory;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class ClasspathSnapshotMaker
implements ClasspathSnapshotProvider {
    private static final Logger LOG = Logging.getLogger(ClasspathSnapshotMaker.class);
    private final ClasspathSnapshotFactory classpathSnapshotFactory;
    private ClasspathSnapshot classpathSnapshot;

    public ClasspathSnapshotMaker(ClasspathSnapshotFactory classpathSnapshotFactory) {
        this.classpathSnapshotFactory = classpathSnapshotFactory;
    }

    @Override
    public ClasspathSnapshot getClasspathSnapshot(Iterable<File> classpath) {
        this.maybeInitialize(classpath);
        return this.classpathSnapshot;
    }

    private void maybeInitialize(Iterable<File> classpath) {
        if (this.classpathSnapshot != null) {
            return;
        }
        Timer clock = Time.startTimer();
        this.classpathSnapshot = this.classpathSnapshotFactory.createSnapshot(classpath);
        int duplicatesCount = this.classpathSnapshot.getData().getDuplicateClasses().size();
        String duplicateClassesMessage = duplicatesCount == 0 ? "" : ". " + duplicatesCount + " duplicate classes found in classpath (see all with --debug)";
        LOG.info("Created classpath snapshot for incremental compilation in {}{}.", clock.getElapsed(), duplicateClassesMessage);
        LOG.debug("While calculating classpath snapshot {} duplicate classes were found: {}.", duplicatesCount, this.classpathSnapshot.getData().getDuplicateClasses());
    }
}

