/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;

public class ResolveBuildCacheKeyExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(ResolveBuildCacheKeyExecuter.class);
    private static final String BUILD_OPERATION_NAME = "Snapshot task inputs";
    private final TaskExecuter delegate;
    private final BuildOperationExecutor buildOperationExecutor;
    private final boolean buildCacheDebugLogging;

    public ResolveBuildCacheKeyExecuter(TaskExecuter delegate, BuildOperationExecutor buildOperationExecutor, boolean buildCacheDebugLogging) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildCacheDebugLogging = buildCacheDebugLogging;
    }

    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        this.resolve(task, context);
        this.delegate.execute(task, state, context);
    }

    private void resolve(final TaskInternal task, final TaskExecutionContext context) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext buildOperationContext) {
                TaskOutputCachingBuildCacheKey cacheKey = ResolveBuildCacheKeyExecuter.this.doResolve(task, context);
                buildOperationContext.setResult(new OperationResultImpl(cacheKey));
                context.setBuildCacheKey(cacheKey);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Snapshot task inputs for " + task.getIdentityPath()).name(ResolveBuildCacheKeyExecuter.BUILD_OPERATION_NAME).details(OperationDetailsImpl.INSTANCE);
            }
        });
    }

    private TaskOutputCachingBuildCacheKey doResolve(TaskInternal task, TaskExecutionContext context) {
        TaskArtifactState taskState = context.getTaskArtifactState();
        TaskOutputCachingBuildCacheKey cacheKey = taskState.calculateCacheKey();
        if (context.getTaskProperties().hasDeclaredOutputs() && cacheKey.isValid()) {
            LogLevel logLevel = this.buildCacheDebugLogging ? LogLevel.LIFECYCLE : LogLevel.INFO;
            LOGGER.log(logLevel, "Build cache key for {} is {}", task, cacheKey.getHashCode());
        }
        return cacheKey;
    }

    @VisibleForTesting
    static class OperationResultImpl
    implements SnapshotTaskInputsBuildOperationType.Result,
    CustomOperationTraceSerialization {
        @VisibleForTesting
        final TaskOutputCachingBuildCacheKey key;

        OperationResultImpl(TaskOutputCachingBuildCacheKey key) {
            this.key = key;
        }

        @Override
        @Nullable
        public Map<String, String> getInputValueHashes() {
            ImmutableSortedMap<String, HashCode> inputHashes = this.key.getInputs().getInputValueHashes();
            if (inputHashes == null || inputHashes.isEmpty()) {
                return null;
            }
            return Maps.transformValues(inputHashes, (Function)new Function<HashCode, String>(){

                public String apply(HashCode input) {
                    return input.toString();
                }
            });
        }

        @Override
        public Map<String, String> getInputHashes() {
            ImmutableSortedMap map;
            ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles;
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            Map<String, String> inputValueHashes = this.getInputValueHashes();
            if (inputValueHashes != null) {
                builder.putAll(inputValueHashes);
            }
            if ((inputFiles = this.key.getInputs().getInputFiles()) != null) {
                for (Map.Entry entry : inputFiles.entrySet()) {
                    builder.put(entry.getKey(), (Object)((CurrentFileCollectionFingerprint)entry.getValue()).getHash().toString());
                }
            }
            return (map = builder.build()).isEmpty() ? null : map;
        }

        @Override
        public void visitInputFileProperties(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
            State state = new State(visitor);
            ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles = this.key.getInputs().getInputFiles();
            if (inputFiles == null) {
                return;
            }
            for (Map.Entry entry : inputFiles.entrySet()) {
                CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)entry.getValue();
                state.propertyName = (String)entry.getKey();
                state.propertyHash = fingerprint.getHash();
                state.propertyNormalizationStrategyIdentifier = fingerprint.getStrategyIdentifier();
                state.normalizedSnapshots = fingerprint.getSnapshots();
                visitor.preProperty(state);
                fingerprint.visitRoots(state);
                visitor.postProperty();
            }
        }

        @Override
        @Nullable
        public Set<String> getInputPropertiesLoadedByUnknownClassLoader() {
            ImmutableSortedSet<String> inputPropertiesLoadedByUnknownClassLoader = this.key.getInputs().getInputPropertiesLoadedByUnknownClassLoader();
            if (inputPropertiesLoadedByUnknownClassLoader == null || inputPropertiesLoadedByUnknownClassLoader.isEmpty()) {
                return null;
            }
            return inputPropertiesLoadedByUnknownClassLoader;
        }

        @Override
        @Nullable
        public String getClassLoaderHash() {
            HashCode classLoaderHash = this.key.getInputs().getClassLoaderHash();
            return classLoaderHash == null ? null : classLoaderHash.toString();
        }

        @Override
        @Nullable
        public List<String> getActionClassLoaderHashes() {
            List<HashCode> actionClassLoaderHashes = this.key.getInputs().getActionClassLoaderHashes();
            if (actionClassLoaderHashes == null || actionClassLoaderHashes.isEmpty()) {
                return null;
            }
            return Lists.transform(actionClassLoaderHashes, (Function)new Function<HashCode, String>(){

                public String apply(HashCode input) {
                    return input == null ? null : input.toString();
                }
            });
        }

        @Override
        @Nullable
        public List<String> getActionClassNames() {
            ImmutableList<String> actionClassNames = this.key.getInputs().getActionClassNames();
            if (actionClassNames == null || actionClassNames.isEmpty()) {
                return null;
            }
            return actionClassNames;
        }

        @Override
        @Nullable
        public List<String> getOutputPropertyNames() {
            ImmutableSortedSet<String> outputPropertyNames = this.key.getInputs().getOutputPropertyNames();
            if (outputPropertyNames == null || outputPropertyNames.isEmpty()) {
                return null;
            }
            return ImmutableSortedSet.copyOf(outputPropertyNames).asList();
        }

        @Override
        @Nullable
        public String getBuildCacheKey() {
            return this.key.isValid() ? this.key.getHashCode() : null;
        }

        @Override
        public Object getCustomOperationTraceSerializableModel() {
            TreeMap<String, Object> model = new TreeMap<String, Object>();
            model.put("actionClassLoaderHashes", this.getActionClassLoaderHashes());
            model.put("actionClassNames", this.getActionClassNames());
            model.put("buildCacheKey", this.getBuildCacheKey());
            model.put("classLoaderHash", this.getClassLoaderHash());
            model.put("inputFileProperties", this.fileProperties());
            model.put("inputHashes", this.getInputHashes());
            model.put("inputPropertiesLoadedByUnknownClassLoader", this.getInputPropertiesLoadedByUnknownClassLoader());
            model.put("inputValueHashes", this.getInputValueHashes());
            model.put("outputPropertyNames", this.getOutputPropertyNames());
            return model;
        }

        protected Map<String, Object> fileProperties() {
            final TreeMap<String, Object> fileProperties = new TreeMap<String, Object>();
            this.visitInputFileProperties(new SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor(){
                Property property;
                Deque<DirEntry> dirStack = new ArrayDeque<DirEntry>();

                @Override
                public void preProperty(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                    this.property = new Property(state.getPropertyHash(), state.getPropertyNormalizationStrategyName());
                    fileProperties.put(state.getPropertyName(), this.property);
                }

                @Override
                public void preRoot(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                }

                @Override
                public void preDirectory(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                    boolean isRoot = this.dirStack.isEmpty();
                    DirEntry dir = new DirEntry(isRoot ? state.getPath() : state.getName());
                    if (isRoot) {
                        this.property.roots.add(dir);
                    } else {
                        this.dirStack.peek().children.add(dir);
                    }
                    this.dirStack.push(dir);
                }

                @Override
                public void file(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                    boolean isRoot = this.dirStack.isEmpty();
                    FileEntry file = new FileEntry(isRoot ? state.getPath() : state.getName(), state.getHash());
                    if (isRoot) {
                        this.property.roots.add(file);
                    } else {
                        this.dirStack.peek().children.add(file);
                    }
                }

                @Override
                public void postDirectory() {
                    this.dirStack.pop();
                }

                @Override
                public void postRoot() {
                }

                @Override
                public void postProperty() {
                }

                class DirEntry
                extends Entry {
                    private final List<Entry> children;

                    DirEntry(String path) {
                        super(path);
                        this.children = new ArrayList<Entry>();
                    }

                    public Collection<Entry> getChildren() {
                        return this.children;
                    }
                }

                class FileEntry
                extends Entry {
                    private final String hash;

                    FileEntry(String path, String hash) {
                        super(path);
                        this.hash = hash;
                    }

                    public String getHash() {
                        return this.hash;
                    }
                }

                abstract class Entry {
                    private final String path;

                    public Entry(String path) {
                        this.path = path;
                    }

                    public String getPath() {
                        return this.path;
                    }
                }

                class Property {
                    private final String hash;
                    private final String normalization;
                    private final List<Entry> roots = new ArrayList<Entry>();

                    public Property(String hash, String normalization) {
                        this.hash = hash;
                        this.normalization = normalization;
                    }

                    public String getHash() {
                        return this.hash;
                    }

                    public String getNormalization() {
                        return this.normalization;
                    }

                    public Collection<Entry> getRoots() {
                        return this.roots;
                    }
                }
            });
            return fileProperties;
        }

        @NonNullApi
        private static class State
        implements SnapshotTaskInputsBuildOperationType.Result.VisitState,
        PhysicalSnapshotVisitor {
            final SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor;
            Map<String, NormalizedFileSnapshot> normalizedSnapshots;
            String propertyName;
            HashCode propertyHash;
            FingerprintingStrategy.Identifier propertyNormalizationStrategyIdentifier;
            String name;
            String path;
            HashCode hash;
            int depth;

            public State(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
                this.visitor = visitor;
            }

            @Override
            public String getPropertyName() {
                return this.propertyName;
            }

            @Override
            public String getPropertyHash() {
                return this.propertyHash.toString();
            }

            @Override
            public String getPropertyNormalizationStrategyName() {
                return this.propertyNormalizationStrategyIdentifier.name();
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getPath() {
                return this.path;
            }

            @Override
            public String getHash() {
                return this.hash.toString();
            }

            @Override
            public boolean preVisitDirectory(PhysicalDirectorySnapshot physicalSnapshot) {
                this.path = physicalSnapshot.getAbsolutePath();
                this.name = physicalSnapshot.getName();
                this.hash = null;
                if (this.depth++ == 0) {
                    this.visitor.preRoot(this);
                }
                this.visitor.preDirectory(this);
                return true;
            }

            @Override
            public void visit(PhysicalSnapshot physicalSnapshot) {
                boolean isRoot;
                this.path = physicalSnapshot.getAbsolutePath();
                this.name = physicalSnapshot.getName();
                NormalizedFileSnapshot snapshot = this.normalizedSnapshots.get(this.path);
                if (snapshot == null) {
                    return;
                }
                this.hash = snapshot.getNormalizedContentHash();
                boolean bl = isRoot = this.depth == 0;
                if (isRoot) {
                    this.visitor.preRoot(this);
                }
                this.visitor.file(this);
                if (isRoot) {
                    this.visitor.postRoot();
                }
            }

            @Override
            public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                this.visitor.postDirectory();
                if (--this.depth == 0) {
                    this.visitor.postRoot();
                }
            }
        }
    }

    private static class OperationDetailsImpl
    implements SnapshotTaskInputsBuildOperationType.Details {
        private static final OperationDetailsImpl INSTANCE = new OperationDetailsImpl();

        private OperationDetailsImpl() {
        }
    }
}

