/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.GenericJUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.internal.tasks.testing.junitplatform.VintageTestNameAdapter;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.impldep.org.junit.platform.engine.TestExecutionResult;
import org.gradle.internal.impldep.org.junit.platform.engine.UniqueId;
import org.gradle.internal.impldep.org.junit.platform.engine.support.descriptor.ClassSource;
import org.gradle.internal.impldep.org.junit.platform.engine.support.descriptor.MethodSource;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestIdentifier;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestPlan;
import org.gradle.internal.time.Clock;

public class JUnitPlatformTestExecutionListener
implements TestExecutionListener {
    private final GenericJUnitTestEventAdapter<String> adapter;
    private final IdGenerator<?> idGenerator;
    private final TestClassExecutionListener executionListener;
    private final CurrentRunningTestClass currentRunningTestClass;
    private TestPlan currentTestPlan;

    public JUnitPlatformTestExecutionListener(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator, TestClassExecutionListener executionListener) {
        this.adapter = new GenericJUnitTestEventAdapter(resultProcessor, clock);
        this.idGenerator = idGenerator;
        this.executionListener = executionListener;
        this.currentRunningTestClass = new CurrentRunningTestClass();
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.currentTestPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.currentTestPlan = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (this.isLeafTest(testIdentifier)) {
            this.adapter.testIgnored(this.getDescriptor(testIdentifier));
        } else if (this.isClass(testIdentifier)) {
            this.reportTestClassStarted(testIdentifier);
            this.currentTestPlan.getChildren(testIdentifier).forEach(child -> this.executionSkipped((TestIdentifier)child, reason));
            this.reportTestClassFinished(testIdentifier);
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (this.isClass(testIdentifier)) {
            this.reportTestClassStarted(testIdentifier);
        }
        if (this.isLeafTest(testIdentifier)) {
            this.adapter.testStarted(testIdentifier.getUniqueId(), this.getDescriptor(testIdentifier));
        }
    }

    private boolean isLeafTest(TestIdentifier identifier) {
        return identifier.isTest() && !VintageTestNameAdapter.isVintageDynamicTestClass(identifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.testFailedBeforeTestClassStart(testIdentifier, testExecutionResult)) {
            this.executionFailedBeforeTestClassStart(testIdentifier, testExecutionResult);
        } else {
            this.executionFinishedAfterTestClassStart(testIdentifier, testExecutionResult);
        }
    }

    private void executionFailedBeforeTestClassStart(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.reportTestClassStarted(testIdentifier);
        this.reportTestClassFinished(testIdentifier, (Throwable)testExecutionResult.getThrowable().get());
    }

    private void executionFinishedAfterTestClassStart(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.isFailedContainer(testIdentifier, testExecutionResult)) {
            this.adapter.testStarted(testIdentifier.getUniqueId(), this.getDescriptor(testIdentifier));
            this.testFinished(testIdentifier, testExecutionResult);
        } else if (this.isLeafTest(testIdentifier)) {
            this.testFinished(testIdentifier, testExecutionResult);
        }
        if (this.isClass(testIdentifier)) {
            this.reportTestClassFinished(testIdentifier);
        }
    }

    private boolean testFailedBeforeTestClassStart(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        return this.isFailedContainer(testIdentifier, testExecutionResult) && this.currentRunningTestClass.count == 0;
    }

    private void testFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case SUCCESSFUL: {
                break;
            }
            case FAILED: {
                this.adapter.testFailure(testIdentifier.getUniqueId(), this.getDescriptor(testIdentifier), (Throwable)testExecutionResult.getThrowable().get());
                break;
            }
            case ABORTED: {
                this.adapter.testAssumptionFailure(testIdentifier.getUniqueId());
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid Status: " + testExecutionResult.getStatus()));
            }
        }
        this.adapter.testFinished(testIdentifier.getUniqueId());
    }

    private void reportTestClassStarted(TestIdentifier testIdentifier) {
        this.currentRunningTestClass.start(this.className(testIdentifier), this.classDisplayName(testIdentifier));
    }

    private void reportTestClassFinished(TestIdentifier testIdentifier, Throwable failure) {
        this.currentRunningTestClass.end(this.className(testIdentifier), failure);
    }

    private void reportTestClassFinished(TestIdentifier testIdentifier) {
        this.currentRunningTestClass.end(this.className(testIdentifier), null);
    }

    private boolean isFailedContainer(TestIdentifier testIdentifier, TestExecutionResult result) {
        return result.getStatus() != TestExecutionResult.Status.SUCCESSFUL && testIdentifier.isContainer();
    }

    private TestDescriptorInternal getDescriptor(TestIdentifier test) {
        if (this.isMethod(test)) {
            return this.createDescriptor(test, test.getLegacyReportingName(), test.getDisplayName());
        }
        if (VintageTestNameAdapter.isVintageDynamicLeafTest(test)) {
            UniqueId uniqueId = UniqueId.parse((String)test.getUniqueId());
            return new DefaultTestDescriptor(this.idGenerator.generateId(), VintageTestNameAdapter.vintageDynamicClassName(uniqueId), VintageTestNameAdapter.vintageDynamicMethodName(uniqueId));
        }
        if (this.isClass(test) || VintageTestNameAdapter.isVintageDynamicTestClass(test)) {
            return this.createDescriptor(test, "classMethod", "classMethod");
        }
        return this.createDescriptor(test, test.getDisplayName(), test.getDisplayName());
    }

    private TestDescriptorInternal createDescriptor(TestIdentifier test, String name, String displayName) {
        TestIdentifier classIdentifier = this.findClassSource(test);
        String className = this.className(classIdentifier);
        String classDisplayName = this.classDisplayName(classIdentifier);
        return new DefaultTestDescriptor(this.idGenerator.generateId(), className, name, classDisplayName, displayName);
    }

    private boolean isMethod(TestIdentifier test) {
        return test.getSource().isPresent() && test.getSource().get() instanceof MethodSource;
    }

    private boolean isClass(TestIdentifier test) {
        return test.getSource().isPresent() && test.getSource().get() instanceof ClassSource;
    }

    private TestIdentifier findClassSource(TestIdentifier testIdentifier) {
        if (this.isClass(testIdentifier)) {
            return testIdentifier;
        }
        while (testIdentifier.getParentId().isPresent()) {
            if (!this.isClass(testIdentifier = this.currentTestPlan.getTestIdentifier((String)testIdentifier.getParentId().get()))) continue;
            return testIdentifier;
        }
        return null;
    }

    private String className(TestIdentifier testClassIdentifier) {
        if (testClassIdentifier != null && testClassIdentifier.getSource().isPresent()) {
            return ((ClassSource)ClassSource.class.cast(testClassIdentifier.getSource().get())).getClassName();
        }
        return "UnknownClass";
    }

    private String classDisplayName(TestIdentifier testClassIdentifier) {
        if (testClassIdentifier != null) {
            return testClassIdentifier.getDisplayName();
        }
        return "UnknownClass";
    }

    private class CurrentRunningTestClass {
        private String name;
        private int count;

        private CurrentRunningTestClass() {
        }

        private void start(String className, String displayName) {
            if (this.name == null) {
                this.name = className;
                JUnitPlatformTestExecutionListener.this.executionListener.testClassStarted(className, displayName);
                this.count = 1;
            } else if (className.equals(this.name)) {
                ++this.count;
            }
        }

        private void end(String className, Throwable failure) {
            if (className.equals(this.name)) {
                --this.count;
                if (this.count == 0) {
                    JUnitPlatformTestExecutionListener.this.executionListener.testClassFinished(failure);
                    this.name = null;
                }
            }
        }
    }
}

