/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparisonResult;
import org.gradle.api.plugins.buildcomparison.gradle.GradleBuildInvocationSpec;
import org.gradle.api.plugins.buildcomparison.gradle.internal.ComparableGradleBuildExecuter;
import org.gradle.api.plugins.buildcomparison.gradle.internal.DefaultGradleBuildInvocationSpec;
import org.gradle.api.plugins.buildcomparison.gradle.internal.GradleBuildComparison;
import org.gradle.api.plugins.buildcomparison.gradle.internal.MovableFileStore;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcomeComparator;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcomeComparisonResultHtmlRenderer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.archive.GeneratedArchiveBuildOutcomeHtmlRenderer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.unknown.UnknownBuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.unknown.UnknownBuildOutcomeComparator;
import org.gradle.api.plugins.buildcomparison.outcome.internal.unknown.UnknownBuildOutcomeComparisonResultHtmlRenderer;
import org.gradle.api.plugins.buildcomparison.outcome.internal.unknown.UnknownBuildOutcomeHtmlRenderer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreException;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathNormalisingKeyFileStore;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

@Incubating
public class CompareGradleBuilds
extends DefaultTask
implements VerificationTask {
    public static final List<String> DEFAULT_TASKS = Arrays.asList("clean", "assemble");
    private static final String TMP_FILESTORAGE_PREFIX = "tmp-filestorage";
    private final GradleBuildInvocationSpec sourceBuild;
    private final GradleBuildInvocationSpec targetBuild;
    private boolean ignoreFailures;
    private Object reportDir;

    public CompareGradleBuilds() {
        PathToFileResolver fileResolver = this.getFileResolver();
        ObjectFactory objectFactory = this.getObjectFactory();
        this.sourceBuild = objectFactory.newInstance(DefaultGradleBuildInvocationSpec.class, fileResolver, this.getProject().getRootDir());
        this.sourceBuild.setTasks(DEFAULT_TASKS);
        this.targetBuild = objectFactory.newInstance(DefaultGradleBuildInvocationSpec.class, fileResolver, this.getProject().getRootDir());
        this.targetBuild.setTasks(DEFAULT_TASKS);
        this.getOutputs().upToDateWhen((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                return false;
            }
        });
    }

    @Inject
    protected PathToFileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProgressLoggerFactory getProgressLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Nested
    public GradleBuildInvocationSpec getSourceBuild() {
        return this.sourceBuild;
    }

    public void sourceBuild(Action<GradleBuildInvocationSpec> config) {
        config.execute(this.getSourceBuild());
    }

    @Nested
    public GradleBuildInvocationSpec getTargetBuild() {
        return this.targetBuild;
    }

    public void targetBuild(Action<GradleBuildInvocationSpec> config) {
        config.execute(this.getTargetBuild());
    }

    @Override
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @OutputDirectory
    public File getReportDir() {
        return this.reportDir == null ? null : this.getFileResolver().resolve(this.reportDir);
    }

    public void setReportDir(File reportDir) {
        this.setReportDir((Object)reportDir);
    }

    public void setReportDir(Object reportDir) {
        if (reportDir == null) {
            throw new IllegalArgumentException("reportDir cannot be null");
        }
        this.reportDir = reportDir;
    }

    @TaskAction
    void compare() {
        GradleBuildInvocationSpec targetBuild;
        GradleBuildInvocationSpec sourceBuild = this.getSourceBuild();
        if (sourceBuild.equals(targetBuild = this.getTargetBuild())) {
            this.getLogger().warn("The source build and target build are identical. Set '{}.targetBuild.gradleVersion' if you want to compare with a different Gradle version.", this.getName());
        }
        ComparableGradleBuildExecuter sourceBuildExecuter = new ComparableGradleBuildExecuter(sourceBuild);
        ComparableGradleBuildExecuter targetBuildExecuter = new ComparableGradleBuildExecuter(targetBuild);
        Logger logger = this.getLogger();
        ProgressLogger progressLogger = this.getProgressLoggerFactory().newOperation(this.getClass());
        progressLogger.setDescription("Gradle Build Comparison");
        GradleBuildComparison comparison = new GradleBuildComparison(sourceBuildExecuter, targetBuildExecuter, logger, progressLogger, this.getProject().getGradle());
        comparison.registerType(GeneratedArchiveBuildOutcome.class, new GeneratedArchiveBuildOutcomeComparator(), new GeneratedArchiveBuildOutcomeComparisonResultHtmlRenderer(), new GeneratedArchiveBuildOutcomeHtmlRenderer());
        comparison.registerType(UnknownBuildOutcome.class, new UnknownBuildOutcomeComparator(), new UnknownBuildOutcomeComparisonResultHtmlRenderer(), new UnknownBuildOutcomeHtmlRenderer());
        File fileStoreTmpBase = this.getFileResolver().resolve(String.format("tmp-filestorage-%s-%s", this.getName(), System.currentTimeMillis()));
        Files fileStore = new Files(fileStoreTmpBase);
        LinkedHashMap<String, String> hostAttributes = new LinkedHashMap<String, String>(4);
        hostAttributes.put("Project", this.getProject().getRootDir().getAbsolutePath());
        hostAttributes.put("Task", this.getPath());
        hostAttributes.put("Gradle version", GradleVersion.current().getVersion());
        hostAttributes.put("Executed at", new SimpleDateFormat().format(new Date()));
        BuildComparisonResult result = comparison.compare(fileStore, this.getReportDir(), hostAttributes);
        this.communicateResult(result);
    }

    private void communicateResult(BuildComparisonResult result) {
        File reportFile = new File(this.getReportDir(), "index.html");
        String reportUrl = new ConsoleRenderer().asClickableFileUrl(reportFile);
        if (result.isBuildsAreIdentical()) {
            this.getLogger().info("The build outcomes were found to be identical. See the report at: {}", reportUrl);
        } else {
            String message = String.format("The build outcomes were not found to be identical. See the report at: %s", reportUrl);
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
            } else {
                throw new GradleException(message);
            }
        }
    }

    private static class Files
    implements MovableFileStore<String> {
        private final File baseDir;
        private final FileStore<String> delegate;

        public Files(File baseDir) {
            this.baseDir = baseDir;
            this.delegate = new PathNormalisingKeyFileStore(baseDir);
        }

        @Override
        public void moveFileStore(File destination) {
            if (this.baseDir.isDirectory()) {
                GFileUtils.moveDirectory(this.baseDir, destination);
            }
        }

        @Override
        public LocallyAvailableResource move(String key, File source) throws FileStoreException {
            return this.delegate.move(key, source);
        }

        @Override
        public LocallyAvailableResource add(String key, Action<File> addAction) throws FileStoreException {
            return this.delegate.add(key, addAction);
        }
    }
}

