/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.mirror.MerkleDirectorySnapshotBuilder;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalFileSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.api.internal.changedetection.state.mirror.RelativePathStringTracker;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.caching.internal.tasks.RelativePathParser;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.TaskOutputPackerUtils;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.ArchiveEntry;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.commons.io.input.CloseShieldInputStream;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;

@NonNullApi
public class TarTaskOutputPacker
implements TaskOutputPacker {
    private static final String METADATA_PATH = "METADATA";
    private static final Pattern PROPERTY_PATH = Pattern.compile("(missing-)?property-([^/]+)(?:/(.*))?");
    private static final int FILE_PERMISSION_MASK = 511;
    private static final int BUFFER_SIZE = 65536;
    private static final ThreadLocal<byte[]> COPY_BUFFERS = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };
    private final FileSystem fileSystem;
    private final StreamHasher streamHasher;
    private final StringInterner stringInterner;

    public TarTaskOutputPacker(FileSystem fileSystem, StreamHasher streamHasher, StringInterner stringInterner) {
        this.fileSystem = fileSystem;
        this.streamHasher = streamHasher;
        this.stringInterner = stringInterner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutputPacker.PackResult pack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, Map<String, CurrentFileCollectionFingerprint> outputFingerprints, OutputStream output, TaskOutputOriginWriter writeOrigin) throws IOException {
        BufferedOutputStream bufferedOutput = output instanceof BufferedOutputStream ? (BufferedOutputStream)output : new BufferedOutputStream(output);
        TarArchiveOutputStream tarOutput = new TarArchiveOutputStream((OutputStream)bufferedOutput, "utf-8");
        try {
            tarOutput.setLongFileMode(3);
            tarOutput.setBigNumberMode(2);
            tarOutput.setAddPaxHeadersForNonAsciiNames(true);
            this.packMetadata(writeOrigin, tarOutput);
            long entryCount = this.pack(propertySpecs, outputFingerprints, tarOutput);
            TaskOutputPacker.PackResult packResult = new TaskOutputPacker.PackResult(entryCount + 1L);
            return packResult;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)tarOutput);
        }
    }

    private void packMetadata(TaskOutputOriginWriter writeMetadata, TarArchiveOutputStream tarOutput) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writeMetadata.execute(baos);
        TarTaskOutputPacker.createTarEntry(METADATA_PATH, baos.size(), 33188, tarOutput);
        tarOutput.write(baos.toByteArray());
        tarOutput.closeArchiveEntry();
    }

    private long pack(Collection<ResolvedTaskOutputFilePropertySpec> propertySpecs, Map<String, CurrentFileCollectionFingerprint> outputFingerprints, TarArchiveOutputStream tarOutput) {
        long entries = 0L;
        for (ResolvedTaskOutputFilePropertySpec propertySpec : propertySpecs) {
            String propertyName = propertySpec.getPropertyName();
            CurrentFileCollectionFingerprint outputFingerprint = outputFingerprints.get(propertyName);
            try {
                entries += this.packProperty(propertySpec, outputFingerprint, tarOutput);
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not pack property '%s': %s", propertyName, ex.getMessage()), ex);
            }
        }
        return entries;
    }

    private long packProperty(CacheableTaskOutputFilePropertySpec propertySpec, CurrentFileCollectionFingerprint outputFingerprint, TarArchiveOutputStream tarOutput) {
        String propertyName = propertySpec.getPropertyName();
        File root = propertySpec.getOutputFile();
        if (root == null) {
            return 0L;
        }
        PackingVisitor packingVisitor = new PackingVisitor(tarOutput, propertyName, propertySpec.getOutputType(), this.fileSystem);
        outputFingerprint.visitRoots(packingVisitor);
        return packingVisitor.finish();
    }

    private static void createTarEntry(String path, long size, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path, true);
        entry.setSize(size);
        entry.setMode(mode);
        tarOutput.putArchiveEntry((ArchiveEntry)entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskOutputPacker.UnpackResult unpack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, InputStream input, TaskOutputOriginReader readOrigin) throws IOException {
        TarArchiveInputStream tarInput = new TarArchiveInputStream(input);
        try {
            TaskOutputPacker.UnpackResult unpackResult = this.unpack(propertySpecs, tarInput, readOrigin);
            return unpackResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)tarInput);
        }
    }

    private TaskOutputPacker.UnpackResult unpack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, TarArchiveInputStream tarInput, TaskOutputOriginReader readOriginAction) throws IOException {
        ImmutableMap propertySpecsMap = Maps.uniqueIndex(propertySpecs, (Function)new Function<TaskFilePropertySpec, String>(){

            public String apply(TaskFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
        OriginTaskExecutionMetadata originMetadata = null;
        HashMap<String, PhysicalSnapshot> fileSnapshots = new HashMap<String, PhysicalSnapshot>();
        TarArchiveEntry tarEntry = tarInput.getNextTarEntry();
        AtomicInteger entries = new AtomicInteger(0);
        while (tarEntry != null) {
            entries.incrementAndGet();
            String path = tarEntry.getName();
            if (path.equals(METADATA_PATH)) {
                originMetadata = readOriginAction.execute((InputStream)new CloseShieldInputStream((InputStream)tarInput));
                tarEntry = tarInput.getNextTarEntry();
                continue;
            }
            Matcher matcher = PROPERTY_PATH.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached result format error, invalid contents: " + path);
            }
            String propertyName = TarTaskOutputPacker.unescape(matcher.group(2));
            ResolvedTaskOutputFilePropertySpec propertySpec = (ResolvedTaskOutputFilePropertySpec)propertySpecsMap.get(propertyName);
            if (propertySpec == null) {
                throw new IllegalStateException(String.format("No output property '%s' registered", propertyName));
            }
            boolean outputMissing = matcher.group(1) != null;
            String childPath = matcher.group(3);
            tarEntry = this.unpackPropertyEntry(propertySpec, tarInput, tarEntry, childPath, outputMissing, fileSnapshots, entries);
        }
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new TaskOutputPacker.UnpackResult(originMetadata, entries.get(), fileSnapshots);
    }

    @Nullable
    private TarArchiveEntry unpackPropertyEntry(ResolvedTaskOutputFilePropertySpec propertySpec, TarArchiveInputStream input, TarArchiveEntry rootEntry, String childPath, boolean missing, Map<String, PhysicalSnapshot> snapshots, AtomicInteger entries) throws IOException {
        File propertyRoot = propertySpec.getOutputFile();
        String propertyName = propertySpec.getPropertyName();
        if (propertyRoot == null) {
            throw new IllegalStateException("Optional property should have a value: " + propertyName);
        }
        boolean isDirEntry = rootEntry.isDirectory();
        boolean root = Strings.isNullOrEmpty((String)childPath);
        if (!root) {
            throw new IllegalStateException("Root needs to be the first entry in a property");
        }
        if (missing) {
            this.unpackMissingFile(propertyRoot);
            return input.getNextTarEntry();
        }
        OutputType outputType = propertySpec.getOutputType();
        TaskOutputPackerUtils.ensureDirectoryForProperty(outputType, propertyRoot);
        if (outputType == OutputType.FILE) {
            if (isDirEntry) {
                throw new IllegalStateException("Property should be an output file property: " + propertyName);
            }
            PhysicalFileSnapshot fileSnapshot = this.unpackFile(input, rootEntry, propertyRoot, propertyRoot.getAbsolutePath(), propertyRoot.getName());
            snapshots.put(propertyName, fileSnapshot);
            return input.getNextTarEntry();
        }
        if (!isDirEntry) {
            throw new IllegalStateException("Property should be an output directory property: " + propertyName);
        }
        this.chmodUnpackedFile(rootEntry, propertyRoot);
        return this.unpackDirectoryTree(input, rootEntry, snapshots, entries, propertyRoot, propertyName);
    }

    private void unpackMissingFile(File propertyRoot) throws IOException {
        if (!TaskOutputPackerUtils.makeDirectory(propertyRoot.getParentFile()) && propertyRoot.exists()) {
            FileUtils.forceDelete((File)propertyRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhysicalFileSnapshot unpackFile(TarArchiveInputStream input, TarArchiveEntry entry, File outputFile, String absolutePath, String fileName) throws IOException {
        HashCode hash;
        FileOutputStream output = new FileOutputStream(outputFile);
        try {
            hash = this.streamHasher.hashCopy((InputStream)input, output);
            this.chmodUnpackedFile(entry, outputFile);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
        String outputPath = this.stringInterner.intern(absolutePath);
        String outputFileName = this.stringInterner.intern(fileName);
        return new PhysicalFileSnapshot(outputPath, outputFileName, hash, outputFile.lastModified());
    }

    @Nullable
    private TarArchiveEntry unpackDirectoryTree(TarArchiveInputStream input, TarArchiveEntry rootEntry, Map<String, PhysicalSnapshot> snapshots, AtomicInteger entries, File propertyRoot, String propertyName) throws IOException {
        TarArchiveEntry entry;
        RelativePathParser parser = new RelativePathParser();
        parser.rootPath(rootEntry.getName());
        MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        String rootPath = this.stringInterner.intern(propertyRoot.getAbsolutePath());
        String rootDirName = this.stringInterner.intern(propertyRoot.getName());
        builder.preVisitDirectory(rootPath, rootDirName);
        while ((entry = input.getNextTarEntry()) != null) {
            entries.incrementAndGet();
            boolean isDir = entry.isDirectory();
            int directoriesLeft = parser.nextPath(entry.getName(), isDir);
            for (int i = 0; i < directoriesLeft; ++i) {
                builder.postVisitDirectory();
            }
            if (parser.getDepth() == 0) break;
            File outputFile = new File(propertyRoot, parser.getRelativePath());
            if (isDir) {
                FileUtils.forceMkdir((File)outputFile);
                this.chmodUnpackedFile(entry, outputFile);
                String outputPath = this.stringInterner.intern(outputFile.getAbsolutePath());
                String outputDirName = this.stringInterner.intern(parser.getName());
                builder.preVisitDirectory(outputPath, outputDirName);
                continue;
            }
            PhysicalFileSnapshot fileSnapshot = this.unpackFile(input, entry, outputFile, outputFile.getAbsolutePath(), parser.getName());
            builder.visit(fileSnapshot);
        }
        for (int i = 0; i < parser.getDepth(); ++i) {
            builder.postVisitDirectory();
        }
        snapshots.put(propertyName, builder.getResult());
        return entry;
    }

    private void chmodUnpackedFile(TarArchiveEntry entry, File outputFile) {
        this.fileSystem.chmod(outputFile, entry.getMode() & 0x1FF);
    }

    private static String escape(String name) {
        try {
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new AssertionError();
        }
    }

    private static String unescape(String name) {
        try {
            return URLDecoder.decode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class PackingVisitor
    implements PhysicalSnapshotVisitor {
        private final RelativePathStringTracker relativePathStringTracker;
        private final TarArchiveOutputStream tarOutput;
        private final String propertyPath;
        private final String propertyRoot;
        private final FileSystem fileSystem;
        private final OutputType outputType;
        private long entries;

        public PackingVisitor(TarArchiveOutputStream tarOutput, String propertyName, OutputType outputType, FileSystem fileSystem) {
            this.tarOutput = tarOutput;
            this.propertyPath = "property-" + TarTaskOutputPacker.escape(propertyName);
            this.propertyRoot = this.propertyPath + "/";
            this.outputType = outputType;
            this.fileSystem = fileSystem;
            this.relativePathStringTracker = new RelativePathStringTracker();
        }

        @Override
        public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
            boolean root = this.relativePathStringTracker.isRoot();
            this.relativePathStringTracker.enter(directorySnapshot);
            this.assertCorrectType(root, directorySnapshot);
            String targetPath = this.getTargetPath(root);
            int mode = root ? 493 : this.fileSystem.getUnixMode(new File(directorySnapshot.getAbsolutePath()));
            this.storeDirectoryEntry(targetPath, mode, this.tarOutput);
            ++this.entries;
            return true;
        }

        @Override
        public void visit(PhysicalSnapshot fileSnapshot) {
            boolean root = this.relativePathStringTracker.isRoot();
            this.relativePathStringTracker.enter(fileSnapshot);
            String targetPath = this.getTargetPath(root);
            if (fileSnapshot.getType() == FileType.Missing) {
                this.storeMissingProperty(targetPath, this.tarOutput);
            } else {
                this.assertCorrectType(root, fileSnapshot);
                File file = new File(fileSnapshot.getAbsolutePath());
                int mode = this.fileSystem.getUnixMode(file);
                this.storeFileEntry(file, targetPath, file.length(), mode, this.tarOutput);
            }
            this.relativePathStringTracker.leave();
            ++this.entries;
        }

        @Override
        public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
            this.relativePathStringTracker.leave();
        }

        public long finish() {
            if (this.entries == 0L) {
                this.storeMissingProperty(this.propertyPath, this.tarOutput);
                ++this.entries;
            }
            return this.entries;
        }

        private void assertCorrectType(boolean root, PhysicalSnapshot snapshot) {
            if (root) {
                switch (this.outputType) {
                    case DIRECTORY: {
                        if (snapshot.getType() == FileType.Directory) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", snapshot.getAbsolutePath()));
                    }
                    case FILE: {
                        if (snapshot.getType() == FileType.RegularFile) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a file", snapshot.getAbsolutePath()));
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        private String getTargetPath(boolean root) {
            if (root) {
                return this.propertyPath;
            }
            String relativePath = this.relativePathStringTracker.getRelativePathString();
            return this.propertyRoot + relativePath;
        }

        private void storeMissingProperty(String propertyPath, TarArchiveOutputStream tarOutput) {
            try {
                TarTaskOutputPacker.createTarEntry("missing-" + propertyPath, 0L, 33188, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void storeDirectoryEntry(String path, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarTaskOutputPacker.createTarEntry(path + "/", 0L, 0x4000 | mode, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeFileEntry(File inputFile, String path, long size, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarTaskOutputPacker.createTarEntry(path, size, 0x8000 | mode, tarOutput);
                FileInputStream input = new FileInputStream(inputFile);
                try {
                    IOUtils.copyLarge((InputStream)input, (OutputStream)tarOutput, (byte[])((byte[])COPY_BUFFERS.get()));
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

