/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import java.lang.reflect.Type;
import java.util.List;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ImplicitInputRecorder;
import org.gradle.internal.resolve.caching.ImplicitInputsProvidingService;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;

public class ImplicitInputsCapturingInstantiator
implements Instantiator {
    private final ServiceRegistry serviceRegistry;
    private final InstantiatorFactory factory;

    public ImplicitInputsCapturingInstantiator(ServiceRegistry serviceRegistry, InstantiatorFactory factory) {
        this.serviceRegistry = serviceRegistry;
        this.factory = factory;
    }

    @Override
    public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
        return this.factory.inject(this.serviceRegistry).newInstance(type, parameters);
    }

    public Instantiator capturing(final ImplicitInputRecorder registrar) {
        return new Instantiator(){

            @Override
            public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
                return ImplicitInputsCapturingInstantiator.this.factory.inject(ImplicitInputsCapturingInstantiator.this.capturingRegistry(registrar)).newInstance(type, parameters);
            }
        };
    }

    public <IN, OUT, SERVICE> ImplicitInputsProvidingService<IN, OUT, SERVICE> findInputCapturingServiceByName(String name) {
        try {
            return (ImplicitInputsProvidingService)Cast.uncheckedCast(this.serviceRegistry.find(Class.forName(name)));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ServiceRegistry capturingRegistry(ImplicitInputRecorder registrar) {
        return new DefaultCapturingServicesRegistry(registrar);
    }

    private class DefaultCapturingServicesRegistry
    implements ServiceRegistry {
        private final ImplicitInputRecorder registrar;

        private DefaultCapturingServicesRegistry(ImplicitInputRecorder registrar) {
            this.registrar = registrar;
        }

        @Override
        public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.get(serviceType);
        }

        @Override
        public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.getAll(serviceType);
        }

        @Override
        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.get(serviceType);
        }

        @Override
        public Object find(Type serviceType) throws ServiceLookupException {
            Object service = ImplicitInputsCapturingInstantiator.this.serviceRegistry.find(serviceType);
            if (ImplicitInputsProvidingService.class.isInstance(service)) {
                return ((ImplicitInputsProvidingService)service).withImplicitInputRecorder(this.registrar);
            }
            return service;
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> type) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.getFactory(type);
        }

        @Override
        public <T> T newInstance(Class<T> type) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.serviceRegistry.newInstance(type);
        }
    }
}

