/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.LockableCollectionProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppApplication;
import org.gradle.language.cpp.internal.DefaultCppExecutable;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.BuildType;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

@Incubating
public class CppApplicationPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public CppApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        final ObjectFactory objectFactory = project.getObjects();
        final DefaultCppApplication application = this.componentFactory.newInstance(CppApplication.class, DefaultCppApplication.class, "main");
        project.getExtensions().add(CppApplication.class, "application", application);
        project.getComponents().add(application);
        application.getBaseName().set(project.getName());
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(final Project project) {
                ((LockableCollectionProperty)((Object)application.getOperatingSystems())).lockNow();
                Set operatingSystemFamilies = (Set)((AbstractProvider)((Object)application.getOperatingSystems())).get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the application.");
                }
                Usage runtimeUsage = objectFactory.named(Usage.class, "native-runtime");
                for (BuildType buildType : BuildType.DEFAULT_BUILD_TYPES) {
                    for (OperatingSystemFamily operatingSystem : operatingSystemFamilies) {
                        String operatingSystemSuffix = CppApplicationPlugin.this.createDimensionSuffix(operatingSystem, operatingSystemFamilies);
                        String variantName = buildType.getName() + operatingSystemSuffix;
                        Provider<String> group = project.provider(new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return project.getGroup().toString();
                            }
                        });
                        Provider<String> version = project.provider(new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return project.getVersion().toString();
                            }
                        });
                        AttributeContainerInternal runtimeAttributes = CppApplicationPlugin.this.attributesFactory.mutable();
                        runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, runtimeUsage);
                        runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, buildType.isDebuggable());
                        runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, buildType.isOptimized());
                        runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, operatingSystem);
                        NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, application.getBaseName(), group, version, buildType.isDebuggable(), buildType.isOptimized(), operatingSystem, null, new DefaultUsageContext(variantName + "Runtime", runtimeUsage, runtimeAttributes));
                        if (DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(operatingSystem.getName())) {
                            ToolChainSelector.Result<CppPlatform> result = CppApplicationPlugin.this.toolChainSelector.select(CppPlatform.class);
                            DefaultCppExecutable executable = application.addExecutable(variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                            if (buildType == BuildType.DEBUG) {
                                application.getDevelopmentBinary().set(executable);
                            }
                            application.getMainPublication().addVariant(executable);
                            continue;
                        }
                        application.getMainPublication().addVariant(variantIdentity);
                    }
                }
                ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
            }
        });
    }

    private String createDimensionSuffix(Named dimensionValue, Collection<? extends Named> multivalueProperty) {
        if (this.isDimensionVisible(multivalueProperty)) {
            return StringUtils.capitalize((String)dimensionValue.getName().toLowerCase());
        }
        return "";
    }

    private boolean isDimensionVisible(Collection<? extends Named> multivalueProperty) {
        return multivalueProperty.size() > 1;
    }
}

