/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.DefaultSymbolExtractorSpec;
import org.gradle.nativeplatform.internal.SymbolExtractorSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class ExtractSymbols
extends DefaultTask {
    private final RegularFileProperty binaryFile;
    private final RegularFileProperty symbolFile;
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;

    public ExtractSymbols() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.binaryFile = this.newInputFile();
        this.symbolFile = this.newOutputFile();
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @InputFile
    public RegularFileProperty getBinaryFile() {
        return this.binaryFile;
    }

    @OutputFile
    public RegularFileProperty getSymbolFile() {
        return this.symbolFile;
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @TaskAction
    public void extractSymbols() {
        BuildOperationLogger operationLogger = this.getServices().get(BuildOperationLoggerFactory.class).newOperationLogger(this.getName(), this.getTemporaryDir());
        DefaultSymbolExtractorSpec spec = new DefaultSymbolExtractorSpec();
        spec.setBinaryFile(((RegularFile)this.binaryFile.get()).getAsFile());
        spec.setSymbolFile(((RegularFile)this.symbolFile.get()).getAsFile());
        spec.setOperationLogger(operationLogger);
        Compiler<SymbolExtractorSpec> symbolExtractor = this.createCompiler();
        symbolExtractor = BuildOperationLoggingCompilerDecorator.wrap(symbolExtractor);
        WorkResult result = symbolExtractor.execute(spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<SymbolExtractorSpec> createCompiler() {
        NativePlatformInternal targetPlatform = Cast.cast(NativePlatformInternal.class, this.targetPlatform.get());
        NativeToolChainInternal toolChain = Cast.cast(NativeToolChainInternal.class, this.getToolChain().get());
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        return toolProvider.newCompiler(SymbolExtractorSpec.class);
    }
}

