/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.AbstractLockableProperty;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.LockableCollectionProperty;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.BuildType;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestExecutable;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XCTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPlatformPathLocator;
import org.gradle.util.GUtil;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;
    private final ToolChainSelector toolChainSelector;
    private final NativeComponentFactory componentFactory;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator, ToolChainSelector toolChainSelector, NativeComponentFactory componentFactory, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
        this.toolChainSelector = toolChainSelector;
        this.componentFactory = componentFactory;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultSwiftXCTestSuite testComponent = this.createTestSuite(project);
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(final Project project) {
                ((LockableCollectionProperty)((Object)testComponent.getOperatingSystems())).lockNow();
                Set operatingSystemFamilies = (Set)((AbstractProvider)((Object)testComponent.getOperatingSystems())).get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the application.");
                }
                Usage runtimeUsage = XCTestConventionPlugin.this.objectFactory.named(Usage.class, "native-runtime");
                BuildType buildType = BuildType.DEBUG;
                for (OperatingSystemFamily operatingSystem : operatingSystemFamilies) {
                    String operatingSystemSuffix = XCTestConventionPlugin.this.createDimensionSuffix(operatingSystem, operatingSystemFamilies);
                    String variantName = buildType.getName() + operatingSystemSuffix;
                    Provider<String> group = project.provider(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getGroup().toString();
                        }
                    });
                    Provider<String> version = project.provider(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getVersion().toString();
                        }
                    });
                    AttributeContainerInternal runtimeAttributes = XCTestConventionPlugin.this.attributesFactory.mutable();
                    runtimeAttributes.attribute(Usage.USAGE_ATTRIBUTE, runtimeUsage);
                    runtimeAttributes.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, buildType.isDebuggable());
                    runtimeAttributes.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, buildType.isOptimized());
                    runtimeAttributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, operatingSystem);
                    NativeVariantIdentity variantIdentity = new NativeVariantIdentity(variantName, testComponent.getModule(), group, version, buildType.isDebuggable(), buildType.isOptimized(), operatingSystem, null, new DefaultUsageContext(variantName + "-runtime", runtimeUsage, runtimeAttributes));
                    if (!DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(operatingSystem.getName())) continue;
                    ToolChainSelector.Result<SwiftPlatform> result = XCTestConventionPlugin.this.toolChainSelector.select(SwiftPlatform.class);
                    DefaultSwiftXCTestBinary binary = result.getTargetPlatform().getOperatingSystemFamily().isMacOs() ? (DefaultSwiftXCTestBinary)((Object)testComponent.addBundle(variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider())) : (DefaultSwiftXCTestBinary)((Object)testComponent.addExecutable(variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider()));
                    testComponent.getTestBinary().set(binary);
                    ProductionSwiftComponent mainComponent = (ProductionSwiftComponent)project.getComponents().withType(ProductionSwiftComponent.class).findByName("main");
                    if (mainComponent == null) continue;
                    testComponent.getTestedComponent().set(mainComponent);
                }
                ((DefaultBinaryCollection)testComponent.getBinaries()).whenElementKnown(DefaultSwiftXCTestBinary.class, new Action<DefaultSwiftXCTestBinary>(){

                    @Override
                    public void execute(DefaultSwiftXCTestBinary binary) {
                        XCTest testingTask = XCTestConventionPlugin.this.createTestingTask(project);
                        binary.getRunTask().set(testingTask);
                        XCTestConventionPlugin.this.configureTestingTask(binary, testingTask);
                        XCTestConventionPlugin.this.configureTestSuiteBuildingTasks((ProjectInternal)project, binary);
                        XCTestConventionPlugin.this.configureTestSuiteWithTestedComponentWhenAvailable(project, testComponent, binary);
                    }
                });
                ((DefaultBinaryCollection)testComponent.getBinaries()).realizeNow();
            }
        });
    }

    private String createDimensionSuffix(Named dimensionValue, Collection<? extends Named> multivalueProperty) {
        if (this.isDimensionVisible(multivalueProperty)) {
            return StringUtils.capitalize((String)dimensionValue.getName().toLowerCase());
        }
        return "";
    }

    private boolean isDimensionVisible(Collection<? extends Named> multivalueProperty) {
        return multivalueProperty.size() > 1;
    }

    private void configureTestSuiteBuildingTasks(ProjectInternal project, final DefaultSwiftXCTestBinary binary) {
        if (binary instanceof SwiftXCTestBundle) {
            TaskContainerInternal tasks = project.getTasks();
            final Names names = binary.getNames();
            SwiftCompile compile = (SwiftCompile)binary.getCompileTask().get();
            DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
            ModelRegistry modelRegistry = project.getModelRegistry();
            NativeToolChain toolChain = (NativeToolChain)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class).getForPlatform(currentPlatform);
            compile.getCompilerArgs().addAll(project.provider(new Callable<List<String>>(){

                @Override
                public List<String> call() {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Arrays.asList("-parse-as-library", "-F" + frameworkDir.getAbsolutePath());
                }
            }));
            LinkMachOBundle link = tasks.create(names.getTaskName("link"), LinkMachOBundle.class);
            link.getLinkerArgs().set(project.provider(new Callable<List<String>>(){

                @Override
                public List<String> call() {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
                }
            }));
            InstallXCTestBundle install = tasks.create(names.getTaskName("install"), InstallXCTestBundle.class);
            install.getBundleBinaryFile().set(link.getLinkedFile());
            install.getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            binary.getInstallDirectory().set(install.getInstallDirectory());
            link.source(binary.getObjects());
            link.lib(binary.getLinkLibraries());
            final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select(currentPlatform);
            Provider<RegularFile> exeLocation = project.getLayout().getBuildDirectory().file(project.getProviders().provider(new Callable<String>(){

                @Override
                public String call() {
                    return toolProvider.getExecutableName("exe/" + names.getDirName() + binary.getBaseName().get());
                }
            }));
            link.getLinkedFile().set(exeLocation);
            link.getTargetPlatform().set(currentPlatform);
            link.getToolChain().set(toolChain);
            link.getDebuggable().set(binary.isDebuggable());
            binary.getExecutableFile().set(link.getLinkedFile());
            DefaultSwiftXCTestBundle bundle = (DefaultSwiftXCTestBundle)binary;
            bundle.getLinkTask().set(link);
            bundle.getRunScriptFile().set(install.getRunScriptFile());
        } else {
            DefaultSwiftXCTestExecutable executable = (DefaultSwiftXCTestExecutable)binary;
            executable.getRunScriptFile().set(((InstallExecutable)executable.getInstallTask().get()).getRunScriptFile());
        }
    }

    private XCTest createTestingTask(Project project) {
        TaskContainer tasks = project.getTasks();
        XCTest testTask = tasks.create("xcTest", XCTest.class);
        testTask.setGroup("verification");
        testTask.setDescription("Executes XCTest suites");
        return testTask;
    }

    private void configureTestingTask(SwiftXCTestBinary binary, XCTest testTask) {
        testTask.getTestInstallDirectory().set(binary.getInstallDirectory());
        testTask.getRunScriptFile().set(binary.getRunScriptFile());
        testTask.getWorkingDirectory().set(binary.getInstallDirectory());
    }

    private DefaultSwiftXCTestSuite createTestSuite(Project project) {
        DefaultSwiftXCTestSuite testSuite = this.componentFactory.newInstance(SwiftXCTestSuite.class, DefaultSwiftXCTestSuite.class, "test");
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", testSuite);
        project.getComponents().add(testSuite);
        testSuite.getModule().set(GUtil.toCamelCase(project.getName() + "Test"));
        return testSuite;
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(final Project project, final DefaultSwiftXCTestSuite testSuite, final DefaultSwiftXCTestBinary testExecutable) {
        SwiftComponent target = (SwiftComponent)testSuite.getTestedComponent().getOrNull();
        if (!(target instanceof ProductionSwiftComponent)) {
            return;
        }
        final ProductionSwiftComponent testedComponent = (ProductionSwiftComponent)target;
        final TaskContainer tasks = project.getTasks();
        testedComponent.getBinaries().whenElementFinalized((Action<? extends SwiftBinary>)new Action<SwiftBinary>(){

            @Override
            public void execute(SwiftBinary testedBinary) {
                FileCollection testableObjects;
                if (testedBinary != testedComponent.getDevelopmentBinary().get()) {
                    return;
                }
                if (((AbstractLockableProperty)((Object)testSuite.getSourceCompatibility())).getOrNull() == null) {
                    testExecutable.getSourceCompatibility().set(testedBinary.getSourceCompatibility());
                }
                testExecutable.getImplementationDependencies().extendsFrom(((DefaultSwiftBinary)testedBinary).getImplementationDependencies());
                Dependency compileDependency = project.getDependencies().create(project.files(testedBinary.getModuleFile()));
                testExecutable.getImportPathConfiguration().getDependencies().add(compileDependency);
                if (testedComponent instanceof SwiftApplication) {
                    UnexportMainSymbol unexportMainSymbol = tasks.create("relocateMainForTest", UnexportMainSymbol.class);
                    unexportMainSymbol.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/main/for-test"));
                    unexportMainSymbol.getObjects().from(testedBinary.getObjects());
                    testableObjects = unexportMainSymbol.getRelocatedObjects();
                } else {
                    testableObjects = testedBinary.getObjects();
                }
                Dependency linkDependency = project.getDependencies().create(testableObjects);
                testExecutable.getLinkConfiguration().getDependencies().add(linkDependency);
            }
        });
    }
}

