/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal;

import java.util.ArrayList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;

public class PluginRequestsSerializer
extends AbstractSerializer<PluginRequests> {
    @Override
    public PluginRequests read(Decoder decoder) throws Exception {
        int requestCount = decoder.readSmallInt();
        if (requestCount == 0) {
            return DefaultPluginRequests.EMPTY;
        }
        ArrayList requests = Lists.newArrayListWithCapacity((int)requestCount);
        for (int i = 0; i < requestCount; ++i) {
            PluginId pluginId = DefaultPluginId.unvalidated(decoder.readString());
            String version = decoder.readNullableString();
            boolean apply = decoder.readBoolean();
            String decodedLineNumber = decoder.readNullableString();
            Integer lineNumber = decodedLineNumber == null ? null : Integer.valueOf(decodedLineNumber);
            String scriptDisplayName = decoder.readString();
            requests.add(i, new DefaultPluginRequest(pluginId, version, apply, lineNumber, scriptDisplayName, null));
        }
        return new DefaultPluginRequests(requests);
    }

    @Override
    public void write(Encoder encoder, PluginRequests requests) throws Exception {
        encoder.writeSmallInt(requests.size());
        for (PluginRequestInternal request : requests) {
            encoder.writeString(request.getId().getId());
            encoder.writeNullableString(request.getVersion());
            encoder.writeBoolean(request.isApply());
            encoder.writeNullableString(request.getLineNumber() == null ? null : request.getLineNumber().toString());
            encoder.writeString(request.getScriptDisplayName());
        }
    }
}

