/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import java.util.Collections;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.plugin.management.internal.DefaultPluginRequest;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedBuildScanPlugin;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;

public class DefaultAutoAppliedPluginRegistry
implements AutoAppliedPluginRegistry {
    private static final ModuleIdentifier AUTO_APPLIED_ID = DefaultModuleIdentifier.newId("com.gradle", "build-scan-plugin");
    private final BuildDefinition buildDefinition;

    public DefaultAutoAppliedPluginRegistry(BuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
    }

    @Override
    public PluginRequests getAutoAppliedPlugins(Project target) {
        if (this.shouldApplyScanPlugin(target)) {
            return new DefaultPluginRequests(Collections.singletonList(this.createScanPluginRequest()));
        }
        return DefaultPluginRequests.EMPTY;
    }

    @Override
    public PluginRequests getAutoAppliedPlugins(Settings target) {
        return this.buildDefinition.getInjectedPluginRequests();
    }

    private boolean shouldApplyScanPlugin(Project target) {
        StartParameter startParameter = this.buildDefinition.getStartParameter();
        return startParameter.isBuildScan() && target.getParent() == null && target.getGradle().getParent() == null;
    }

    private DefaultPluginRequest createScanPluginRequest() {
        ModuleVersionSelector artifact = DefaultModuleVersionSelector.newSelector(AUTO_APPLIED_ID, "1.16");
        return new DefaultPluginRequest(AutoAppliedBuildScanPlugin.ID, "1.16", true, null, DefaultAutoAppliedPluginRegistry.getScriptDisplayName(), artifact);
    }

    private static String getScriptDisplayName() {
        return String.format("auto-applied by using --%s", "scan");
    }
}

