/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import groovy.util.Node;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.JarDirectory;
import org.gradle.plugins.ide.idea.model.ModuleDependency;
import org.gradle.plugins.ide.idea.model.ModuleLibrary;
import org.gradle.plugins.ide.idea.model.Path;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class Module
extends XmlPersistableConfigurationObject {
    public static final String INHERITED = "inherited";
    private static final String CONTENT = "content";
    private Path contentPath;
    private Set<Path> sourceFolders = Sets.newLinkedHashSet();
    private Set<Path> testSourceFolders = Sets.newLinkedHashSet();
    private Set<Path> resourceFolders = Sets.newLinkedHashSet();
    private Set<Path> testResourceFolders = Sets.newLinkedHashSet();
    private Set<Path> generatedSourceFolders = Sets.newLinkedHashSet();
    private Set<Path> excludeFolders = Sets.newLinkedHashSet();
    private boolean inheritOutputDirs;
    private Path outputDir;
    private Path testOutputDir;
    private Set<Dependency> dependencies = Sets.newLinkedHashSet();
    private String jdkName;
    private final PathFactory pathFactory;
    private String languageLevel;

    public Module(XmlTransformer withXmlActions, PathFactory pathFactory) {
        super(withXmlActions);
        this.pathFactory = pathFactory;
    }

    public Path getContentPath() {
        return this.contentPath;
    }

    public void setContentPath(Path contentPath) {
        this.contentPath = contentPath;
    }

    public Set<Path> getSourceFolders() {
        return this.sourceFolders;
    }

    public void setSourceFolders(Set<Path> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    public Set<Path> getTestSourceFolders() {
        return this.testSourceFolders;
    }

    public void setTestSourceFolders(Set<Path> testSourceFolders) {
        this.testSourceFolders = testSourceFolders;
    }

    @Incubating
    public Set<Path> getResourceFolders() {
        return this.resourceFolders;
    }

    @Incubating
    public void setResourceFolders(Set<Path> resourceFolders) {
        this.resourceFolders = resourceFolders;
    }

    @Incubating
    public Set<Path> getTestResourceFolders() {
        return this.testResourceFolders;
    }

    @Incubating
    public void setTestResourceFolders(Set<Path> testResourceFolders) {
        this.testResourceFolders = testResourceFolders;
    }

    public Set<Path> getGeneratedSourceFolders() {
        return this.generatedSourceFolders;
    }

    public void setGeneratedSourceFolders(Set<Path> generatedSourceFolders) {
        this.generatedSourceFolders = generatedSourceFolders;
    }

    public Set<Path> getExcludeFolders() {
        return this.excludeFolders;
    }

    public void setExcludeFolders(Set<Path> excludeFolders) {
        this.excludeFolders = excludeFolders;
    }

    public boolean isInheritOutputDirs() {
        return this.inheritOutputDirs;
    }

    public void setInheritOutputDirs(boolean inheritOutputDirs) {
        this.inheritOutputDirs = inheritOutputDirs;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public Path getTestOutputDir() {
        return this.testOutputDir;
    }

    public void setTestOutputDir(Path testOutputDir) {
        this.testOutputDir = testOutputDir;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public String getJdkName() {
        return this.jdkName;
    }

    public void setJdkName(String jdkName) {
        this.jdkName = jdkName;
    }

    @Override
    protected String getDefaultResourceName() {
        return "defaultModule.xml";
    }

    protected Object configure(Path contentPath, Set<Path> sourceFolders, Set<Path> testSourceFolders, Set<Path> resourceFolders, Set<Path> testResourceFolders, Set<Path> generatedSourceFolders, Set<Path> excludeFolders, Boolean inheritOutputDirs, Path outputDir, Path testOutputDir, Set<Dependency> dependencies, String jdkName, String languageLevel) {
        this.languageLevel = languageLevel;
        this.contentPath = contentPath;
        this.sourceFolders.addAll(sourceFolders);
        this.testSourceFolders.addAll(testSourceFolders);
        this.resourceFolders.addAll(resourceFolders);
        this.testResourceFolders.addAll(testResourceFolders);
        this.generatedSourceFolders.addAll(generatedSourceFolders);
        this.excludeFolders.addAll(excludeFolders);
        if (inheritOutputDirs != null) {
            this.inheritOutputDirs = inheritOutputDirs;
        }
        if (outputDir != null) {
            this.outputDir = outputDir;
        }
        if (testOutputDir != null) {
            this.testOutputDir = testOutputDir;
        }
        this.dependencies = dependencies;
        this.jdkName = !Strings.isNullOrEmpty((String)jdkName) ? jdkName : INHERITED;
        return this.jdkName;
    }

    @Override
    protected void load(Node xml) {
        this.readJdkFromXml();
        this.readSourceAndExcludeFolderFromXml();
        this.readInheritOutputDirsFromXml();
        this.readOutputDirsFromXml();
        this.readDependenciesFromXml();
    }

    @Override
    protected void store(Node xml) {
        this.addJdkToXml();
        this.setContentURL();
        this.removeSourceAndExcludeFolderFromXml();
        this.addSourceAndExcludeFolderToXml();
        this.writeInheritOutputDirsToXml();
        this.writeSourceLanguageLevel();
        this.addOutputDirsToXml();
        this.removeDependenciesFromXml();
        this.addDependenciesToXml();
    }

    private void readJdkFromXml() {
        Node jdk = Module.findFirstWithAttributeValue(this.findOrderEntries(), "type", "jdk");
        this.jdkName = jdk != null ? (String)jdk.attribute((Object)"jdkName") : INHERITED;
    }

    private void readSourceAndExcludeFolderFromXml() {
        for (Node sourceFolder : this.findSourceFolder()) {
            String type;
            String url = (String)sourceFolder.attribute((Object)"url");
            String isTestSource = (String)sourceFolder.attribute((Object)"isTestSource");
            if (isTestSource != null) {
                if ("false".equals(isTestSource)) {
                    this.sourceFolders.add(this.pathFactory.path(url));
                } else {
                    this.testSourceFolders.add(this.pathFactory.path(url));
                }
            }
            if ("true".equals(sourceFolder.attribute((Object)"generated"))) {
                this.generatedSourceFolders.add(this.pathFactory.path(url));
            }
            if ("java-resource".equals(type = (String)sourceFolder.attribute((Object)"type"))) {
                this.resourceFolders.add(this.pathFactory.path(url));
                continue;
            }
            if (!"java-test-resource".equals(type)) continue;
            this.testResourceFolders.add(this.pathFactory.path(url));
        }
        for (Node excludeFolder : this.findExcludeFolder()) {
            this.excludeFolders.add(this.pathFactory.path((String)excludeFolder.attribute((Object)"url")));
        }
    }

    private boolean readInheritOutputDirsFromXml() {
        this.inheritOutputDirs = "true".equals(this.getNewModuleRootManager().attribute((Object)"inherit-compiler-output"));
        return this.inheritOutputDirs;
    }

    private Path readOutputDirsFromXml() {
        Node outputDirNode = this.findOutputDir();
        Node testOutputDirNode = this.findTestOutputDir();
        String outputDirUrl = outputDirNode != null ? (String)outputDirNode.attribute((Object)"url") : null;
        String testOutputDirUrl = testOutputDirNode != null ? (String)testOutputDirNode.attribute((Object)"url") : null;
        this.outputDir = outputDirUrl != null ? this.pathFactory.path(outputDirUrl) : null;
        this.testOutputDir = testOutputDirUrl != null ? this.pathFactory.path(testOutputDirUrl) : null;
        return this.testOutputDir;
    }

    private void readDependenciesFromXml() {
        for (Node orderEntry : this.findOrderEntries()) {
            Object orderEntryType = orderEntry.attribute((Object)"type");
            if ("module-library".equals(orderEntryType)) {
                LinkedHashSet classes = Sets.newLinkedHashSet();
                LinkedHashSet javadoc = Sets.newLinkedHashSet();
                LinkedHashSet sources = Sets.newLinkedHashSet();
                LinkedHashSet jarDirectories = Sets.newLinkedHashSet();
                for (Node library : Module.getChildren(orderEntry, "library")) {
                    for (Node classesNode : Module.getChildren(library, "CLASSES")) {
                        this.readDependenciesPathsFromXml(classes, classesNode);
                    }
                    for (Node javadocNode : Module.getChildren(library, "JAVADOC")) {
                        this.readDependenciesPathsFromXml(javadoc, javadocNode);
                    }
                    for (Node sourcesNode : Module.getChildren(library, "SOURCES")) {
                        this.readDependenciesPathsFromXml(sources, sourcesNode);
                    }
                    for (Node jarDirNode : Module.getChildren(library, "jarDirectory")) {
                        jarDirectories.add(new JarDirectory(this.pathFactory.path((String)jarDirNode.attribute((Object)"url")), Boolean.parseBoolean((String)jarDirNode.attribute((Object)"recursive"))));
                    }
                }
                ModuleLibrary moduleLibrary = new ModuleLibrary(classes, javadoc, sources, jarDirectories, (String)orderEntry.attribute((Object)"scope"));
                this.dependencies.add(moduleLibrary);
                continue;
            }
            if (!"module".equals(orderEntryType)) continue;
            this.dependencies.add(new ModuleDependency((String)orderEntry.attribute((Object)"module-name"), (String)orderEntry.attribute((Object)"scope")));
        }
    }

    private void readDependenciesPathsFromXml(Set<Path> paths, Node node) {
        for (Node classesRoot : Module.getChildren(node, "root")) {
            paths.add(this.pathFactory.path((String)classesRoot.attribute((Object)"url")));
        }
    }

    private void addJdkToXml() {
        Preconditions.checkNotNull((Object)this.jdkName);
        List<Node> orderEntries = this.findOrderEntries();
        Node moduleJdk = Module.findFirstWithAttributeValue(orderEntries, "type", "jdk");
        Node moduleRootManager = this.getNewModuleRootManager();
        if (!this.jdkName.equals(INHERITED)) {
            Node inheritedJdk = Module.findFirstWithAttributeValue(orderEntries, "type", "inheritedJdk");
            if (inheritedJdk != null) {
                inheritedJdk.parent().remove(inheritedJdk);
            }
            if (moduleJdk != null) {
                moduleRootManager.remove(moduleJdk);
            }
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("type", "jdk");
            attributes.put("jdkName", this.jdkName);
            attributes.put("jdkType", "JavaSDK");
            moduleRootManager.appendNode((Object)"orderEntry", (Map)attributes);
        } else if (Module.findFirstWithAttributeValue(orderEntries, "type", "inheritedJdk") == null) {
            if (moduleJdk != null) {
                moduleRootManager.remove(moduleJdk);
            }
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("type", "inheritedJdk");
            moduleRootManager.appendNode((Object)"orderEntry", (Map)attributes);
        }
    }

    private void setContentURL() {
        if (this.contentPath != null) {
            this.findOrCreateContentNode().attributes().put("url", this.contentPath.getUrl());
        }
    }

    private void removeSourceAndExcludeFolderFromXml() {
        Node content = this.findOrCreateContentNode();
        for (Node sourceFolder : this.findSourceFolder()) {
            content.remove(sourceFolder);
        }
        for (Node excludeFolder : this.findExcludeFolder()) {
            content.remove(excludeFolder);
        }
    }

    private void addSourceAndExcludeFolderToXml() {
        LinkedHashMap attributes;
        Node content = this.findOrCreateContentNode();
        for (Path path : this.sourceFolders) {
            if (this.resourceFolders.contains(path)) continue;
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            attributes.put("isTestSource", "false");
            if (this.generatedSourceFolders.contains(path)) {
                attributes.put("generated", "true");
            }
            content.appendNode((Object)"sourceFolder", (Map)attributes);
        }
        for (Path path : this.testSourceFolders) {
            if (this.testResourceFolders.contains(path)) continue;
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            attributes.put("isTestSource", "true");
            if (this.generatedSourceFolders.contains(path)) {
                attributes.put("generated", "true");
            }
            content.appendNode((Object)"sourceFolder", (Map)attributes);
        }
        for (Path path : this.resourceFolders) {
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            attributes.put("type", "java-resource");
            if (this.generatedSourceFolders.contains(path)) {
                attributes.put("generated", "true");
            }
            content.appendNode((Object)"sourceFolder", (Map)attributes);
        }
        for (Path path : this.testResourceFolders) {
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            attributes.put("type", "java-test-resource");
            if (this.generatedSourceFolders.contains(path)) {
                attributes.put("generated", "true");
            }
            content.appendNode((Object)"sourceFolder", (Map)attributes);
        }
        for (Path path : this.excludeFolders) {
            attributes = Maps.newLinkedHashMap();
            attributes.put("url", path.getUrl());
            content.appendNode((Object)"excludeFolder", (Map)attributes);
        }
    }

    private void writeInheritOutputDirsToXml() {
        this.getNewModuleRootManager().attributes().put("inherit-compiler-output", this.inheritOutputDirs);
    }

    private void writeSourceLanguageLevel() {
        if (this.languageLevel != null) {
            this.getNewModuleRootManager().attributes().put("LANGUAGE_LEVEL", this.languageLevel);
        }
    }

    private void addOutputDirsToXml() {
        if (this.outputDir != null) {
            this.findOrCreateOutputDir().attributes().put("url", this.outputDir.getUrl());
        }
        if (this.testOutputDir != null) {
            this.findOrCreateTestOutputDir().attributes().put("url", this.testOutputDir.getUrl());
        }
    }

    private void removeDependenciesFromXml() {
        Node moduleRoot = this.getNewModuleRootManager();
        for (Node orderEntry : this.findOrderEntries()) {
            if (!this.isDependencyOrderEntry(orderEntry)) continue;
            moduleRoot.remove(orderEntry);
        }
    }

    protected boolean isDependencyOrderEntry(Object orderEntry) {
        return Arrays.asList("module-library", "module").contains(((Node)orderEntry).attribute((Object)"type"));
    }

    private void addDependenciesToXml() {
        Node moduleRoot = this.getNewModuleRootManager();
        for (Dependency dependency : this.dependencies) {
            dependency.addToNode(moduleRoot);
        }
    }

    private Node getNewModuleRootManager() {
        Node newModuleRootManager = Module.findFirstWithAttributeValue(Module.getChildren(this.getXml(), "component"), "name", "NewModuleRootManager");
        Preconditions.checkNotNull((Object)newModuleRootManager);
        return newModuleRootManager;
    }

    private Node findOrCreateOutputDir() {
        Node outputDirNode = this.findOutputDir();
        if (outputDirNode != null) {
            return outputDirNode;
        }
        return this.getNewModuleRootManager().appendNode((Object)"output");
    }

    private Node findOrCreateTestOutputDir() {
        Node testOutputDirNode = this.findTestOutputDir();
        if (testOutputDirNode != null) {
            return testOutputDirNode;
        }
        return this.getNewModuleRootManager().appendNode((Object)"output-test");
    }

    private Node findOrCreateContentNode() {
        Node newModuleRootManager = this.getNewModuleRootManager();
        Node contentNode = Module.findFirstChildNamed(newModuleRootManager, CONTENT);
        if (contentNode != null) {
            return contentNode;
        }
        return newModuleRootManager.appendNode((Object)CONTENT);
    }

    private List<Node> findSourceFolder() {
        return Module.getChildren(this.findOrCreateContentNode(), "sourceFolder");
    }

    private List<Node> findExcludeFolder() {
        return Module.getChildren(this.findOrCreateContentNode(), "excludeFolder");
    }

    @Nullable
    private Node findOutputDir() {
        return Module.findFirstChildNamed(this.getNewModuleRootManager(), "output");
    }

    @Nullable
    private Node findTestOutputDir() {
        return Module.findFirstChildNamed(this.getNewModuleRootManager(), "output-test");
    }

    private List<Node> findOrderEntries() {
        return Module.getChildren(this.getNewModuleRootManager(), "orderEntry");
    }

    public String toString() {
        return "Module{dependencies=" + this.dependencies + ", sourceFolders=" + this.sourceFolders + ", testSourceFolders=" + this.testSourceFolders + ", resourceFolders=" + this.resourceFolders + ", testResourceFolders=" + this.testResourceFolders + ", generatedSourceFolders=" + this.generatedSourceFolders + ", excludeFolders=" + this.excludeFolders + ", inheritOutputDirs=" + this.inheritOutputDirs + ", jdkName=" + this.jdkName + ", outputDir=" + this.outputDir + ", testOutputDir=" + this.testOutputDir + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Module module = (Module)o;
        return Objects.equal(this.dependencies, module.dependencies) && Objects.equal(this.excludeFolders, module.excludeFolders) && Objects.equal((Object)this.outputDir, (Object)module.outputDir) && Objects.equal(this.sourceFolders, module.sourceFolders) && Objects.equal(this.generatedSourceFolders, module.generatedSourceFolders) && Objects.equal((Object)this.jdkName, (Object)module.jdkName) && Objects.equal((Object)this.testOutputDir, (Object)module.testOutputDir) && Objects.equal(this.testSourceFolders, module.testSourceFolders) && Objects.equal(this.resourceFolders, module.resourceFolders) && Objects.equal(this.testResourceFolders, module.testResourceFolders);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sourceFolders, this.generatedSourceFolders, this.testSourceFolders, this.resourceFolders, this.testResourceFolders, this.excludeFolders, this.inheritOutputDirs, this.jdkName, this.outputDir, this.testOutputDir, this.dependencies});
    }
}

