/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.tooling.internal.consumer.converters.ConsumerProvidedBuildInvocations;
import org.gradle.tooling.internal.consumer.converters.TaskNameComparator;
import org.gradle.tooling.internal.gradle.ConsumerProvidedTask;
import org.gradle.tooling.internal.gradle.ConsumerProvidedTaskSelector;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;

public class BuildInvocationsConverter {
    public ConsumerProvidedBuildInvocations convert(GradleProject project) {
        List<ConsumerProvidedTaskSelector> selectors = this.buildRecursively(project);
        return new ConsumerProvidedBuildInvocations(project.getProjectIdentifier(), selectors, this.convertTasks(project.getTasks()));
    }

    private List<ConsumerProvidedTaskSelector> buildRecursively(GradleProject project) {
        ArrayListMultimap aggregatedTasks = ArrayListMultimap.create();
        this.collectTasks(project, (Multimap<String, String>)aggregatedTasks);
        ArrayList selectors = Lists.newArrayList();
        for (String selectorName : aggregatedTasks.keySet()) {
            TreeSet selectorTasks = Sets.newTreeSet((Comparator)new TaskNameComparator());
            selectorTasks.addAll(aggregatedTasks.get((Object)selectorName));
            selectors.add(new ConsumerProvidedTaskSelector().setName(selectorName).setTaskNames(selectorTasks).setDescription(project.getParent() != null ? String.format("%s:%s task selector", project.getPath(), selectorName) : String.format("%s task selector", selectorName)).setDisplayName(String.format("%s in %s and subprojects.", selectorName, project.getName())));
        }
        return selectors;
    }

    private void collectTasks(GradleProject project, Multimap<String, String> aggregatedTasks) {
        for (GradleProject gradleProject : project.getChildren()) {
            this.collectTasks(gradleProject, aggregatedTasks);
        }
        for (GradleTask gradleTask : project.getTasks()) {
            aggregatedTasks.put((Object)gradleTask.getName(), (Object)gradleTask.getPath());
        }
    }

    private List<ConsumerProvidedTask> convertTasks(Iterable<? extends GradleTask> tasks) {
        ArrayList result = Lists.newArrayList();
        for (GradleTask gradleTask : tasks) {
            result.add(new ConsumerProvidedTask().setName(gradleTask.getName()).setPath(gradleTask.getPath()).setDescription(gradleTask.getDescription()));
        }
        return result;
    }
}

