/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.util.GUtil;

public class Path
implements Comparable<Path> {
    public static final Path ROOT = new Path(new String[0], true);
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    public static final String SEPARATOR = ":";
    private final String[] segments;
    private final boolean absolute;
    private String fullPath;

    public static Path path(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (path.equals(SEPARATOR)) {
            return ROOT;
        }
        return Path.parsePath(path);
    }

    private static Path parsePath(String path) {
        String[] segments = StringUtils.split((String)path, (String)SEPARATOR);
        boolean absolute = path.startsWith(SEPARATOR);
        return new Path(segments, absolute);
    }

    private Path(String[] segments, boolean absolute) {
        this.segments = segments;
        this.absolute = absolute;
    }

    public String toString() {
        return this.getPath();
    }

    public Path append(Path path) {
        if (path.segments.length == 0) {
            return this;
        }
        String[] concat = new String[this.segments.length + path.segments.length];
        System.arraycopy(this.segments, 0, concat, 0, this.segments.length);
        System.arraycopy(path.segments, 0, concat, this.segments.length, path.segments.length);
        return new Path(concat, this.absolute);
    }

    public String getPath() {
        if (this.fullPath == null) {
            this.fullPath = this.createFullPath();
        }
        return this.fullPath;
    }

    private String createFullPath() {
        StringBuilder path = new StringBuilder();
        if (this.absolute) {
            path.append(SEPARATOR);
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                path.append(SEPARATOR);
            }
            String segment = this.segments[i];
            path.append(segment);
        }
        return path.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        if (this.absolute != path.absolute) {
            return false;
        }
        return Arrays.equals(this.segments, path.segments);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.segments);
        result = 31 * result + (this.absolute ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(Path other) {
        if (this.absolute && !other.absolute) {
            return 1;
        }
        if (!this.absolute && other.absolute) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.segments.length, other.segments.length); ++i) {
            int diff = STRING_COMPARATOR.compare(this.segments[i], other.segments[i]);
            if (diff == 0) continue;
            return diff;
        }
        int lenDiff = this.segments.length - other.segments.length;
        if (lenDiff > 0) {
            return 1;
        }
        if (lenDiff < 0) {
            return -1;
        }
        return 0;
    }

    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        if (this.segments.length == 1) {
            return this.absolute ? ROOT : null;
        }
        String[] parentPath = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, parentPath, 0, parentPath.length);
        return new Path(parentPath, this.absolute);
    }

    @Nullable
    public String getName() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public Path child(String name) {
        String[] childSegments = new String[this.segments.length + 1];
        System.arraycopy(this.segments, 0, childSegments, 0, this.segments.length);
        childSegments[this.segments.length] = name;
        return new Path(childSegments, this.absolute);
    }

    public String absolutePath(String path) {
        return this.absolutePath(Path.path(path)).getPath();
    }

    public Path absolutePath(Path path) {
        if (path.absolute) {
            return path;
        }
        return this.append(path);
    }

    public String relativePath(String path) {
        return this.relativePath(Path.path(path)).getPath();
    }

    public Path relativePath(Path path) {
        if (path.absolute != this.absolute) {
            return path;
        }
        if (path.segments.length < this.segments.length) {
            return path;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (path.segments[i].equals(this.segments[i])) continue;
            return path;
        }
        if (path.segments.length == this.segments.length) {
            return path;
        }
        String[] newSegments = Arrays.copyOfRange(path.segments, this.segments.length, path.segments.length);
        return new Path(newSegments, false);
    }
}

