/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.incremental.CompileContext;

public class TargetOutputIndexImpl
implements TargetOutputIndex {
    private final Map<File, List<BuildTarget<?>>> myOutputToTargets = new THashMap(FileUtil.FILE_HASHING_STRATEGY);

    public TargetOutputIndexImpl(Collection<? extends BuildTarget<?>> allTargets, CompileContext context) {
        for (BuildTarget<?> target : allTargets) {
            Collection<File> roots = target.getOutputRoots(context);
            for (File root : roots) {
                SmartList targets = this.myOutputToTargets.get(root);
                if (targets == null) {
                    targets = new SmartList();
                    this.myOutputToTargets.put(root, (List<BuildTarget<?>>)targets);
                }
                targets.add(target);
            }
        }
    }

    @Override
    public Collection<BuildTarget<?>> getTargetsByOutputFile(@NotNull File file) {
        if (file == null) {
            TargetOutputIndexImpl.$$$reportNull$$$0(0);
        }
        File current = file;
        List<BuildTarget<?>> result = null;
        while (current != null) {
            List<BuildTarget<?>> targets = this.myOutputToTargets.get(current);
            if (targets != null) {
                if (result == null) {
                    result = targets;
                } else {
                    result = new ArrayList(result);
                    result.addAll(targets);
                }
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return result != null ? result : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/builders/impl/TargetOutputIndexImpl", "getTargetsByOutputFile"));
    }
}

