/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.AnnotationsChangeTracker;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileReprExternalizer;
import org.jetbrains.jps.builders.java.dependencyView.ClassRepr;
import org.jetbrains.jps.builders.java.dependencyView.ClassfileAnalyzer;
import org.jetbrains.jps.builders.java.dependencyView.CollectionFactory;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntIntTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.LoggerWrapper;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModulePackageRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRepr;
import org.jetbrains.jps.builders.java.dependencyView.ModuleRequiresRepr;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectPersistentMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectTransientMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMember;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageConstraint;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.storage.FileKeyDescriptor;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class Mappings {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.ether.dependencyView.Mappings");
    private static final String CLASS_TO_SUBCLASSES = "classToSubclasses.tab";
    private static final String CLASS_TO_CLASS = "classToClass.tab";
    private static final String SHORT_NAMES = "shortNames.tab";
    private static final String SOURCE_TO_CLASS = "sourceToClass.tab";
    private static final String CLASS_TO_SOURCE = "classToSource.tab";
    private static final IntInlineKeyDescriptor INT_KEY_DESCRIPTOR = new IntInlineKeyDescriptor();
    private static final int DEFAULT_SET_CAPACITY = 32;
    private static final float DEFAULT_SET_LOAD_FACTOR = 0.98f;
    private final boolean myIsDelta;
    private final boolean myDeltaIsTransient;
    private boolean myIsDifferentiated = false;
    private boolean myIsRebuild = false;
    private final TIntHashSet myChangedClasses;
    private final THashSet<File> myChangedFiles;
    private final Set<Pair<ClassFileRepr, File>> myDeletedClasses;
    private final Set<ClassRepr> myAddedClasses;
    private final Object myLock;
    private final File myRootDir;
    private DependencyContext myContext;
    private final int myInitName;
    private final int myEmptyName;
    private final int myObjectClassName;
    private LoggerWrapper<Integer> myDebugS;
    private IntIntMultiMaplet myClassToSubclasses;
    private IntIntMultiMaplet myClassToClassDependency;
    private ObjectObjectMultiMaplet<File, ClassFileRepr> mySourceFileToClasses;
    private IntObjectMultiMaplet<File> myClassToSourceFile;
    private IntIntMultiMaplet myShortClassNameIndex;
    private IntIntTransientMultiMaplet myRemovedSuperClasses;
    private IntIntTransientMultiMaplet myAddedSuperClasses;
    @Nullable
    private Collection<String> myRemovedFiles;
    private final LinkedBlockingQueue<Runnable> myPostPasses = new LinkedBlockingQueue();
    private static final ClassRepr MOCK_CLASS = null;
    private static final MethodRepr MOCK_METHOD = null;

    private Mappings(Mappings base) throws IOException {
        this.myLock = base.myLock;
        this.myIsDelta = true;
        this.myChangedClasses = new TIntHashSet(32, 0.98f);
        this.myChangedFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        this.myDeletedClasses = new HashSet<Pair<ClassFileRepr, File>>(32, 0.98f);
        this.myAddedClasses = new HashSet<ClassRepr>(32, 0.98f);
        this.myDeltaIsTransient = base.myDeltaIsTransient;
        this.myRootDir = new File(FileUtil.toSystemIndependentName((String)base.myRootDir.getAbsolutePath()) + File.separatorChar + "myDelta");
        this.myContext = base.myContext;
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
        this.myDebugS = base.myDebugS;
        this.createImplementation();
    }

    public Mappings(File rootDir, boolean transientDelta) throws IOException {
        this.myLock = new Object();
        this.myIsDelta = false;
        this.myChangedClasses = null;
        this.myChangedFiles = null;
        this.myDeletedClasses = null;
        this.myAddedClasses = null;
        this.myDeltaIsTransient = transientDelta;
        this.myRootDir = rootDir;
        this.createImplementation();
        this.myInitName = this.myContext.get("<init>");
        this.myEmptyName = this.myContext.get("");
        this.myObjectClassName = this.myContext.get("java/lang/Object");
    }

    private void createImplementation() throws IOException {
        if (!this.myIsDelta) {
            this.myContext = new DependencyContext(this.myRootDir);
            this.myDebugS = this.myContext.getLogger(LOG);
        }
        this.myRemovedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
        this.myAddedSuperClasses = this.myIsDelta ? new IntIntTransientMultiMaplet() : null;
        CollectionFactory<File> fileCollectionFactory = new CollectionFactory<File>(){

            @Override
            public Collection<File> create() {
                return new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            }
        };
        if (this.myIsDelta && this.myDeltaIsTransient) {
            this.myClassToSubclasses = new IntIntTransientMultiMaplet();
            this.myClassToClassDependency = new IntIntTransientMultiMaplet();
            this.myShortClassNameIndex = null;
            this.mySourceFileToClasses = new ObjectObjectTransientMultiMaplet(FileUtil.FILE_HASHING_STRATEGY, () -> new THashSet(5, 0.98f));
            this.myClassToSourceFile = new IntObjectTransientMultiMaplet<File>(fileCollectionFactory);
        } else {
            if (this.myIsDelta) {
                this.myRootDir.mkdirs();
            }
            this.myClassToSubclasses = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SUBCLASSES), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR);
            this.myClassToClassDependency = new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_CLASS), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR);
            this.myShortClassNameIndex = this.myIsDelta ? null : new IntIntPersistentMultiMaplet(DependencyContext.getTableFile(this.myRootDir, SHORT_NAMES), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR);
            this.mySourceFileToClasses = new ObjectObjectPersistentMultiMaplet<File, ClassFileRepr>(DependencyContext.getTableFile(this.myRootDir, SOURCE_TO_CLASS), new FileKeyDescriptor(), new ClassFileReprExternalizer(this.myContext), () -> new THashSet(5, 0.98f));
            this.myClassToSourceFile = new IntObjectPersistentMultiMaplet<File>(DependencyContext.getTableFile(this.myRootDir, CLASS_TO_SOURCE), (KeyDescriptor<Integer>)INT_KEY_DESCRIPTOR, (DataExternalizer<File>)new FileKeyDescriptor(), fileCollectionFactory);
        }
    }

    public String valueOf(int name) {
        return this.myContext.getValue(name);
    }

    public int getName(String string) {
        return this.myContext.get(string);
    }

    public Mappings createDelta() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                return new Mappings(this);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    private void compensateRemovedContent(@NotNull Collection<File> compiled, @NotNull Collection<File> compiledWithErrors) {
        if (compiled == null) {
            Mappings.$$$reportNull$$$0(0);
        }
        if (compiledWithErrors == null) {
            Mappings.$$$reportNull$$$0(1);
        }
        for (File file : compiled) {
            if (compiledWithErrors.contains(file) || this.mySourceFileToClasses.containsKey(file)) continue;
            this.mySourceFileToClasses.put(file, new HashSet());
        }
    }

    @Nullable
    private ClassRepr getClassReprByName(@Nullable File source, int qName) {
        ClassFileRepr reprByName = this.getReprByName(source, qName);
        return reprByName instanceof ClassRepr ? (ClassRepr)reprByName : null;
    }

    @Nullable
    private ClassFileRepr getReprByName(@Nullable File source, int qName) {
        Set<File> sources;
        Collection<File> collection = sources = source != null ? Collections.singleton(source) : this.myClassToSourceFile.get(qName);
        if (sources != null) {
            for (File src : sources) {
                Collection<ClassFileRepr> reprs = this.mySourceFileToClasses.get(src);
                if (reprs == null) continue;
                for (ClassFileRepr repr : reprs) {
                    if (repr.name != qName) continue;
                    return repr;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws IOException {
        if (this.myRootDir != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.close();
                FileUtil.delete((File)this.myRootDir);
                this.createImplementation();
            }
        }
    }

    public IntIntTransientMultiMaplet getRemovedSuperClasses() {
        return this.myRemovedSuperClasses;
    }

    public IntIntTransientMultiMaplet getAddedSuperClasses() {
        return this.myAddedSuperClasses;
    }

    private void runPostPasses() {
        Set<Pair<ClassFileRepr, File>> deleted = this.myDeletedClasses;
        if (deleted != null) {
            for (Pair<ClassFileRepr, File> pair : deleted) {
                int deletedClassName = ((ClassFileRepr)pair.first).name;
                Collection<File> sources = this.myClassToSourceFile.get(deletedClassName);
                if (sources != null && !sources.isEmpty()) continue;
                this.myChangedClasses.remove(deletedClassName);
            }
        }
        Runnable pass = this.myPostPasses.poll();
        while (pass != null) {
            pass.run();
            pass = this.myPostPasses.poll();
        }
    }

    void affectAll(int className, @NotNull File sourceFile, Collection<File> affectedFiles, Collection<File> alreadyCompiledFiles, @Nullable DependentFilesFilter filter) {
        TIntHashSet dependants;
        if (sourceFile == null) {
            Mappings.$$$reportNull$$$0(2);
        }
        if ((dependants = this.myClassToClassDependency.get(className)) != null) {
            dependants.forEach(depClass -> {
                Collection<File> allSources;
                if (sourceFile == null) {
                    Mappings.$$$reportNull$$$0(8);
                }
                if ((allSources = this.myClassToSourceFile.get(depClass)) == null || allSources.isEmpty()) {
                    return true;
                }
                boolean shouldAffect = false;
                for (File depFile : allSources) {
                    if (FileUtil.filesEqual((File)depFile, (File)sourceFile) || alreadyCompiledFiles.contains(depFile) || filter != null && !filter.accept(depFile)) continue;
                    shouldAffect = true;
                    break;
                }
                if (shouldAffect) {
                    for (File depFile : allSources) {
                        if (FileUtil.filesEqual((File)depFile, (File)sourceFile)) continue;
                        affectedFiles.add(depFile);
                    }
                }
                return true;
            });
        }
    }

    private static boolean isVisibleIn(ClassRepr c, ProtoMember m, ClassRepr scope) {
        boolean privacy = m.isPrivate() && c.name != scope.name;
        boolean packageLocality = m.isPackageLocal() && !c.getPackageName().equals(scope.getPackageName());
        return !privacy && !packageLocality;
    }

    private boolean isEmpty(int s) {
        return s == this.myEmptyName;
    }

    @NotNull
    private TIntHashSet getAllSubclasses(int root) {
        TIntHashSet tIntHashSet = this.addAllSubclasses(root, new TIntHashSet(32, 0.98f));
        if (tIntHashSet == null) {
            Mappings.$$$reportNull$$$0(3);
        }
        return tIntHashSet;
    }

    private TIntHashSet addAllSubclasses(int root, TIntHashSet acc) {
        if (!acc.add(root)) {
            return acc;
        }
        TIntHashSet directSubclasses = this.myClassToSubclasses.get(root);
        if (directSubclasses != null) {
            directSubclasses.forEach(s -> {
                this.addAllSubclasses(s, acc);
                return true;
            });
        }
        return acc;
    }

    private boolean incrementalDecision(int owner, Proto member, Collection<File> affectedFiles, Collection<File> currentlyCompiled, final @Nullable DependentFilesFilter filter) {
        boolean isField = member instanceof FieldRepr;
        Util self = new Util();
        if (member.isPublic()) {
            Mappings.debug("Public access, switching to a non-incremental mode");
            return false;
        }
        final THashSet toRecompile = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        if (member.isProtected()) {
            Mappings.debug("Protected access, softening non-incremental decision: adding all relevant subclasses for a recompilation");
            this.debug("Root class: ", owner);
            TIntHashSet propagated = self.propagateFieldAccess(isField ? member.name : this.myEmptyName, owner);
            propagated.forEach(className -> {
                Collection<File> fileNames = this.myClassToSourceFile.get(className);
                if (fileNames != null) {
                    for (File fileName : fileNames) {
                        this.debug("Adding ", fileName);
                    }
                    toRecompile.addAll(fileNames);
                }
                return true;
            });
        }
        final String packageName = ClassRepr.getPackageName(this.myContext.getValue(isField ? owner : member.name));
        Mappings.debug("Softening non-incremental decision: adding all package classes for a recompilation");
        this.debug("Package name: ", packageName);
        this.myClassToSourceFile.forEachEntry(new TIntObjectProcedure<Collection<File>>(){

            public boolean execute(int className, Collection<File> fileNames) {
                if (ClassRepr.getPackageName(Mappings.this.myContext.getValue(className)).equals(packageName)) {
                    for (File fileName : fileNames) {
                        if (filter != null && !filter.accept(fileName)) continue;
                        Mappings.this.debug("Adding: ", fileName);
                        toRecompile.add((Object)fileName);
                    }
                }
                return true;
            }
        });
        toRecompile.removeAll(currentlyCompiled);
        Iterator it = toRecompile.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (file.exists()) continue;
            it.remove();
        }
        affectedFiles.addAll((Collection<File>)toRecompile);
        return true;
    }

    public void differentiateOnRebuild(Mappings delta) {
        new Differential(delta).differentiate();
    }

    public void differentiateOnNonIncrementalMake(Mappings delta, Collection<String> removed, Collection<File> filesToCompile) {
        new Differential(delta, removed, filesToCompile).differentiate();
    }

    public boolean differentiateOnIncrementalMake(Mappings delta, Collection<String> removed, Collection<File> filesToCompile, Collection<File> compiledWithErrors, Collection<File> compiledFiles, Collection<File> affectedFiles, @NotNull DependentFilesFilter filter, @Nullable Callbacks.ConstantAffectionResolver constantSearch) {
        if (filter == null) {
            Mappings.$$$reportNull$$$0(4);
        }
        return new Differential(delta, removed, filesToCompile, compiledWithErrors, compiledFiles, affectedFiles, filter, constantSearch).differentiate();
    }

    private void cleanupBackDependency(int className, @Nullable Set<UsageRepr.Usage> usages, IntIntMultiMaplet buffer) {
        ClassFileRepr repr;
        if (usages == null && (repr = this.getReprByName(null, className)) != null) {
            usages = repr.getUsages();
        }
        if (usages != null) {
            for (UsageRepr.Usage u : usages) {
                buffer.put(u.getOwner(), className);
            }
        }
    }

    private void cleanupRemovedClass(Mappings delta, @NotNull ClassFileRepr cr, File sourceFile, Set<UsageRepr.Usage> usages, IntIntMultiMaplet dependenciesTrashBin) {
        ClassRepr _cr;
        int className;
        Collection<File> currentlyMapped;
        if (cr == null) {
            Mappings.$$$reportNull$$$0(5);
        }
        if ((currentlyMapped = this.myClassToSourceFile.get(className = cr.name)) == null || currentlyMapped.isEmpty()) {
            return;
        }
        if (currentlyMapped.size() == 1) {
            if (!FileUtil.filesEqual((File)sourceFile, (File)currentlyMapped.iterator().next())) {
                return;
            }
        } else {
            for (File file : currentlyMapped) {
                if (FileUtil.filesEqual((File)sourceFile, (File)file) || !file.exists()) continue;
                return;
            }
        }
        if (cr instanceof ClassRepr) {
            for (Object superSomething : (Object)((ClassRepr)cr).getSupers()) {
                delta.registerRemovedSuperClass(className, (int)superSomething);
            }
        }
        this.cleanupBackDependency(className, usages, dependenciesTrashBin);
        this.myClassToClassDependency.remove(className);
        this.myClassToSubclasses.remove(className);
        this.myClassToSourceFile.remove(className);
        if (cr instanceof ClassRepr && !(_cr = (ClassRepr)cr).isLocal() && !_cr.isAnonymous()) {
            this.myShortClassNameIndex.removeFrom(this.myContext.get(_cr.getShortName()), className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(Mappings delta) {
        Object object = this.myLock;
        synchronized (object) {
            try {
                assert (delta.isDifferentiated());
                Collection<String> removed = delta.myRemovedFiles;
                delta.runPostPasses();
                IntIntTransientMultiMaplet dependenciesTrashBin = new IntIntTransientMultiMaplet();
                if (removed != null) {
                    for (String string : removed) {
                        File deletedFile = new File(string);
                        Set fileClasses = (Set)this.mySourceFileToClasses.get(deletedFile);
                        if (fileClasses == null) continue;
                        for (ClassFileRepr aClass2 : fileClasses) {
                            this.cleanupRemovedClass(delta, aClass2, deletedFile, aClass2.getUsages(), dependenciesTrashBin);
                        }
                        this.mySourceFileToClasses.remove(deletedFile);
                    }
                }
                if (!delta.isRebuild()) {
                    for (Pair pair : delta.getDeletedClasses()) {
                        ClassFileRepr deletedClass = (ClassFileRepr)pair.first;
                        this.cleanupRemovedClass(delta, deletedClass, (File)pair.second, deletedClass.getUsages(), dependenciesTrashBin);
                    }
                    for (ClassRepr classRepr : delta.getAddedClasses()) {
                        if (classRepr.isAnonymous() || classRepr.isLocal()) continue;
                        this.myShortClassNameIndex.put(this.myContext.get(classRepr.getShortName()), classRepr.name);
                    }
                    TIntHashSet superClasses = new TIntHashSet();
                    IntIntTransientMultiMaplet intIntTransientMultiMaplet = delta.getAddedSuperClasses();
                    IntIntTransientMultiMaplet removedSuperClasses = delta.getRemovedSuperClasses();
                    Mappings.addAllKeys(superClasses, intIntTransientMultiMaplet);
                    Mappings.addAllKeys(superClasses, removedSuperClasses);
                    superClasses.forEach(superClass -> {
                        TIntHashSet added = addedSuperClasses.get(superClass);
                        TIntHashSet removed12 = removedSuperClasses.get(superClass);
                        TIntHashSet old = this.myClassToSubclasses.get(superClass);
                        if (old == null) {
                            if (added != null && !added.isEmpty()) {
                                this.myClassToSubclasses.replace(superClass, added);
                            }
                        } else {
                            int[] addedAsArray;
                            boolean changed = false;
                            int[] nArray = addedAsArray = added != null && !added.isEmpty() ? added.toArray() : null;
                            if (removed12 != null && !removed12.isEmpty()) {
                                if (addedAsArray != null) {
                                    removed12 = (TIntHashSet)removed12.clone();
                                    removed12.removeAll(addedAsArray);
                                }
                                if (!removed12.isEmpty()) {
                                    changed = old.removeAll(removed12.toArray());
                                }
                            }
                            if (addedAsArray != null) {
                                changed |= old.addAll(addedAsArray);
                            }
                            if (changed) {
                                this.myClassToSubclasses.replace(superClass, old);
                            }
                        }
                        return true;
                    });
                    delta.getChangedClasses().forEach(className -> {
                        Collection<File> sourceFiles = delta.myClassToSourceFile.get(className);
                        this.myClassToSourceFile.replace(className, sourceFiles);
                        this.cleanupBackDependency(className, null, dependenciesTrashBin);
                        return true;
                    });
                    delta.getChangedFiles().forEach(fileName -> {
                        Collection<ClassFileRepr> classes = delta.mySourceFileToClasses.get((File)fileName);
                        this.mySourceFileToClasses.replace((File)fileName, classes);
                        return true;
                    });
                    final THashSet unchangedSources = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    delta.mySourceFileToClasses.forEachEntry(new TObjectObjectProcedure<File, Collection<ClassFileRepr>>(){

                        public boolean execute(File source, Collection<ClassFileRepr> b) {
                            unchangedSources.add((Object)source);
                            return true;
                        }
                    });
                    unchangedSources.removeAll(delta.getChangedFiles());
                    if (!unchangedSources.isEmpty()) {
                        unchangedSources.forEach(unchangedSource -> {
                            Collection<ClassFileRepr> updatedClasses = delta.mySourceFileToClasses.get((File)unchangedSource);
                            if (updatedClasses != null && !updatedClasses.isEmpty()) {
                                ArrayList<ClassFileRepr> classesToPut = new ArrayList<ClassFileRepr>();
                                TIntHashSet updatedClassNames = new TIntHashSet();
                                for (ClassFileRepr aClass : updatedClasses) {
                                    if (!delta.getChangedClasses().contains(aClass.name)) continue;
                                    classesToPut.add(aClass);
                                    updatedClassNames.add(aClass.name);
                                }
                                Collection<ClassFileRepr> currentClasses = this.mySourceFileToClasses.get((File)unchangedSource);
                                if (currentClasses != null) {
                                    for (ClassFileRepr aClass : currentClasses) {
                                        if (updatedClassNames.contains(aClass.name)) continue;
                                        classesToPut.add(aClass);
                                    }
                                }
                                this.mySourceFileToClasses.replace((File)unchangedSource, (Collection<ClassFileRepr>)classesToPut);
                            }
                            return true;
                        });
                    }
                } else {
                    this.myClassToSubclasses.putAll(delta.myClassToSubclasses);
                    this.myClassToSourceFile.replaceAll(delta.myClassToSourceFile);
                    this.mySourceFileToClasses.replaceAll(delta.mySourceFileToClasses);
                    delta.mySourceFileToClasses.forEachEntry(new TObjectObjectProcedure<File, Collection<ClassFileRepr>>(){

                        public boolean execute(File src, Collection<ClassFileRepr> classes) {
                            for (ClassFileRepr repr : classes) {
                                ClassRepr clsRepr;
                                if (!(repr instanceof ClassRepr) || (clsRepr = (ClassRepr)repr).isAnonymous() || clsRepr.isLocal()) continue;
                                Mappings.this.myShortClassNameIndex.put(Mappings.this.myContext.get(clsRepr.getShortName()), repr.name);
                            }
                            return true;
                        }
                    });
                }
                TIntHashSet affectedClasses = new TIntHashSet();
                Mappings.addAllKeys(affectedClasses, dependenciesTrashBin);
                Mappings.addAllKeys(affectedClasses, delta.myClassToClassDependency);
                affectedClasses.forEach(aClass -> {
                    boolean hasDataToAdd;
                    TIntHashSet now = delta.myClassToClassDependency.get(aClass);
                    TIntHashSet toRemove = dependenciesTrashBin.get(aClass);
                    boolean bl = hasDataToAdd = now != null && !now.isEmpty();
                    if (toRemove != null && !toRemove.isEmpty()) {
                        TIntHashSet current = this.myClassToClassDependency.get(aClass);
                        if (current != null && !current.isEmpty()) {
                            boolean added;
                            TIntHashSet before = new TIntHashSet();
                            Mappings.addAll(before, current);
                            boolean removed1 = current.removeAll(toRemove.toArray());
                            boolean bl2 = added = hasDataToAdd && current.addAll(now.toArray());
                            if (removed1 && !added || !removed1 && added || !before.equals((Object)current)) {
                                this.myClassToClassDependency.replace(aClass, current);
                            }
                        } else if (hasDataToAdd) {
                            this.myClassToClassDependency.put(aClass, now);
                        }
                    } else if (hasDataToAdd) {
                        this.myClassToClassDependency.put(aClass, now);
                    }
                    return true;
                });
            }
            finally {
                delta.close();
            }
        }
    }

    public Callbacks.Backend getCallback() {
        return new Callbacks.Backend(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associate(String classFileName, Collection<String> sources, ClassReader cr) {
                Object object = Mappings.this.myLock;
                synchronized (object) {
                    int classFileNameS = Mappings.this.myContext.get(classFileName);
                    ClassFileRepr result = new ClassfileAnalyzer(Mappings.this.myContext).analyze(classFileNameS, cr);
                    if (result != null) {
                        int className = result.name;
                        for (String sourceFileName : sources) {
                            File sourceFile = new File(sourceFileName);
                            Mappings.this.myClassToSourceFile.put(className, sourceFile);
                            Mappings.this.mySourceFileToClasses.put(sourceFile, result);
                        }
                        if (result instanceof ClassRepr) {
                            for (Iterator<UsageRepr.Usage> s : (Iterator<UsageRepr.Usage>)((ClassRepr)result).getSupers()) {
                                Mappings.this.myClassToSubclasses.put((int)s, className);
                            }
                        }
                        for (UsageRepr.Usage u : result.getUsages()) {
                            int owner = u.getOwner();
                            if (owner == className) continue;
                            Mappings.this.myClassToClassDependency.put(owner, className);
                        }
                    }
                }
            }

            @Override
            public void associate(String classFileName, String sourceFileName, ClassReader cr) {
                this.associate(classFileName, Collections.singleton(sourceFileName), cr);
            }

            @Override
            public void registerImports(String className, Collection<String> imports, Collection<String> staticImports) {
                ArrayList<String> allImports = new ArrayList<String>();
                for (String anImport : imports) {
                    if (anImport.endsWith("*")) continue;
                    allImports.add(anImport);
                }
                for (String s : staticImports) {
                    int i = s.length() - 1;
                    while (s.charAt(i) != '.') {
                        --i;
                    }
                    String anImport = s.substring(0, i);
                    if (anImport.endsWith("*")) continue;
                    allImports.add(anImport);
                }
                if (!allImports.isEmpty()) {
                    Mappings.this.myPostPasses.offer(() -> {
                        int rootClassName = Mappings.this.myContext.get(className.replace(".", "/"));
                        Collection fileNames = Mappings.this.myClassToSourceFile.get(rootClassName);
                        ClassRepr repr = fileNames != null && !fileNames.isEmpty() ? Mappings.this.getClassReprByName((File)fileNames.iterator().next(), rootClassName) : null;
                        for (String i : allImports) {
                            int iname = Mappings.this.myContext.get(i.replace('.', '/'));
                            Mappings.this.myClassToClassDependency.put(iname, rootClassName);
                            if (repr == null || !repr.addUsage(UsageRepr.createClassUsage(Mappings.this.myContext, iname))) continue;
                            for (File fileName : fileNames) {
                                Mappings.this.mySourceFileToClasses.put(fileName, repr);
                            }
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Set<ClassRepr> getClasses(String sourceFileName) {
        File f = new File(sourceFileName);
        Object object = this.myLock;
        synchronized (object) {
            Collection<ClassFileRepr> reprs = this.mySourceFileToClasses.get(f);
            if (reprs == null || reprs.isEmpty()) {
                return null;
            }
            THashSet result = new THashSet();
            for (ClassFileRepr repr : reprs) {
                if (!(repr instanceof ClassRepr)) continue;
                result.add((ClassRepr)repr);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Collection<File> getClassSources(int className) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myClassToSourceFile.get(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.myLock;
        synchronized (object) {
            this.myClassToSubclasses.close();
            this.myClassToClassDependency.close();
            this.mySourceFileToClasses.close();
            this.myClassToSourceFile.close();
            if (!this.myIsDelta) {
                this.myShortClassNameIndex.close();
                DependencyContext context = this.myContext;
                if (context != null) {
                    context.close();
                    this.myContext = null;
                }
            } else if (!this.myDeltaIsTransient) {
                FileUtil.delete((File)this.myRootDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean memoryCachesOnly) {
        Object object = this.myLock;
        synchronized (object) {
            this.myClassToSubclasses.flush(memoryCachesOnly);
            this.myClassToClassDependency.flush(memoryCachesOnly);
            this.mySourceFileToClasses.flush(memoryCachesOnly);
            this.myClassToSourceFile.flush(memoryCachesOnly);
            if (!this.myIsDelta) {
                this.myShortClassNameIndex.flush(memoryCachesOnly);
                DependencyContext context = this.myContext;
                if (context != null) {
                    context.clearMemoryCaches();
                    if (!memoryCachesOnly) {
                        context.flush();
                    }
                }
            }
        }
    }

    private static boolean addAll(TIntHashSet whereToAdd, TIntHashSet whatToAdd) {
        if (whatToAdd.isEmpty()) {
            return false;
        }
        Ref changed = new Ref((Object)Boolean.FALSE);
        whatToAdd.forEach(value -> {
            if (whereToAdd.add(value)) {
                changed.set((Object)Boolean.TRUE);
            }
            return true;
        });
        return (Boolean)changed.get();
    }

    private static void addAllKeys(final TIntHashSet whereToAdd, IntIntMultiMaplet maplet) {
        maplet.forEachEntry(new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int key, TIntHashSet b) {
                whereToAdd.add(key);
                return true;
            }
        });
    }

    private void registerAddedSuperClass(int aClass, int superClass) {
        assert (this.myAddedSuperClasses != null);
        this.myAddedSuperClasses.put(superClass, aClass);
    }

    private void registerRemovedSuperClass(int aClass, int superClass) {
        assert (this.myRemovedSuperClasses != null);
        this.myRemovedSuperClasses.put(superClass, aClass);
    }

    private boolean isDifferentiated() {
        return this.myIsDifferentiated;
    }

    private boolean isRebuild() {
        return this.myIsRebuild;
    }

    private void addDeletedClass(ClassFileRepr cr, File fileName) {
        assert (this.myDeletedClasses != null);
        this.myDeletedClasses.add((Pair<ClassFileRepr, File>)Pair.create((Object)cr, (Object)fileName));
        this.addChangedClass(cr.name);
    }

    private void addAddedClass(ClassRepr cr) {
        assert (this.myAddedClasses != null);
        this.myAddedClasses.add(cr);
        this.addChangedClass(cr.name);
    }

    private void addChangedClass(int it) {
        assert (this.myChangedClasses != null && this.myChangedFiles != null);
        this.myChangedClasses.add(it);
        Collection<File> files = this.myClassToSourceFile.get(it);
        if (files != null) {
            this.myChangedFiles.addAll(files);
        }
    }

    @NotNull
    private Set<Pair<ClassFileRepr, File>> getDeletedClasses() {
        Set<Pair<ClassFileRepr, File>> set = this.myDeletedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myDeletedClasses);
        if (set == null) {
            Mappings.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private Set<ClassRepr> getAddedClasses() {
        Set<ClassRepr> set = this.myAddedClasses == null ? Collections.emptySet() : Collections.unmodifiableSet(this.myAddedClasses);
        if (set == null) {
            Mappings.$$$reportNull$$$0(7);
        }
        return set;
    }

    private TIntHashSet getChangedClasses() {
        return this.myChangedClasses;
    }

    private THashSet<File> getChangedFiles() {
        return this.myChangedFiles;
    }

    private static void debug(String s) {
        LOG.debug(s);
    }

    private void debug(String comment, int s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, File f) {
        this.debug(comment, f.getPath());
    }

    private void debug(String comment, String s) {
        this.myDebugS.debug(comment, s);
    }

    private void debug(String comment, boolean s) {
        this.myDebugS.debug(comment, s);
    }

    public void toStream(PrintStream stream) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.mySourceFileToClasses, this.myClassToSourceFile};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "SourceFileToAnnotationUsages", "SourceFileToUsages"};
        for (int i = 0; i < data.length; ++i) {
            stream.print("Begin Of ");
            stream.println(info[i]);
            data[i].toStream(this.myContext, stream);
            stream.print("End Of ");
            stream.println(info[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toStream(File outputRoot) {
        Streamable[] data = new Streamable[]{this.myClassToSubclasses, this.myClassToClassDependency, this.mySourceFileToClasses, this.myClassToSourceFile, this.myShortClassNameIndex};
        String[] info = new String[]{"ClassToSubclasses", "ClassToClassDependency", "SourceFileToClasses", "ClassToSourceFile", "ShortClassNameIndex"};
        for (int i = 0; i < data.length; ++i) {
            File file = new File(outputRoot, info[i]);
            FileUtil.createIfDoesntExist((File)file);
            try (PrintStream stream = new PrintStream(file);){
                data[i].toStream(this.myContext, stream);
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ boolean access$4102(Mappings x0, boolean x1) {
        x0.myIsDifferentiated = x1;
        return x0.myIsDifferentiated;
    }

    static /* synthetic */ boolean access$1800(Mappings x0) {
        return x0.myIsRebuild;
    }

    static /* synthetic */ Set access$4200(Mappings x0) {
        return x0.getAddedClasses();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiled";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledWithErrors";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/dependencyView/Mappings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubclasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compensateRemovedContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "affectAll";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "differentiateOnIncrementalMake";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cleanupRemovedClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$affectAll$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Differential {
        private static final int DESPERATE_MASK = 16;
        final Mappings myDelta;
        final Collection<File> myFilesToCompile;
        final Collection<File> myCompiledFiles;
        final Collection<File> myCompiledWithErrors;
        final Collection<File> myAffectedFiles;
        @Nullable
        final DependentFilesFilter myFilter;
        @Nullable
        final Callbacks.ConstantAffectionResolver myConstantSearch;
        final DelayedWorks myDelayedWorks;
        final Util myFuture;
        final Util myPresent;
        final boolean myEasyMode;
        private final Iterable<AnnotationsChangeTracker> myAnnotationChangeTracker;

        private Differential(Mappings delta) {
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            this.myDelta = delta;
            this.myFilesToCompile = null;
            this.myCompiledFiles = null;
            this.myCompiledWithErrors = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myConstantSearch = null;
            this.myDelayedWorks = null;
            this.myFuture = null;
            this.myPresent = null;
            this.myEasyMode = true;
            delta.myIsRebuild = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<File> filesToCompile) {
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = null;
            this.myCompiledWithErrors = null;
            this.myAffectedFiles = null;
            this.myFilter = null;
            this.myConstantSearch = null;
            this.myDelayedWorks = null;
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = true;
        }

        private Differential(Mappings delta, Collection<String> removed, Collection<File> filesToCompile, Collection<File> compiledWithErrors, Collection<File> compiledFiles, @NotNull Collection<File> affectedFiles, @Nullable DependentFilesFilter filter, Callbacks.ConstantAffectionResolver constantSearch) {
            if (filter == null) {
                Differential.$$$reportNull$$$0(0);
            }
            this.myAnnotationChangeTracker = JpsServiceManager.getInstance().getExtensions(AnnotationsChangeTracker.class);
            delta.myRemovedFiles = removed;
            this.myDelta = delta;
            this.myFilesToCompile = filesToCompile;
            this.myCompiledFiles = compiledFiles;
            this.myCompiledWithErrors = compiledWithErrors;
            this.myAffectedFiles = affectedFiles;
            this.myFilter = filter;
            this.myConstantSearch = constantSearch;
            this.myDelayedWorks = new DelayedWorks();
            this.myFuture = new Util(delta);
            this.myPresent = new Util();
            this.myEasyMode = false;
        }

        private void processDisappearedClasses() {
            Collection removed;
            if (this.myFilesToCompile != null) {
                this.myDelta.compensateRemovedContent(this.myFilesToCompile, this.myCompiledWithErrors != null ? this.myCompiledWithErrors : Collections.emptySet());
            }
            if (!this.myEasyMode && (removed = this.myDelta.myRemovedFiles) != null) {
                for (String file : removed) {
                    File sourceFile = new File(file);
                    Collection classes = Mappings.this.mySourceFileToClasses.get(sourceFile);
                    if (classes == null) continue;
                    for (ClassFileRepr c : classes) {
                        Mappings.this.debug("Affecting usages of removed class ", c.name);
                        Mappings.this.affectAll(c.name, sourceFile, this.myAffectedFiles, this.myCompiledFiles, this.myFilter);
                    }
                }
            }
        }

        private void processAddedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<MethodRepr> added = diff.methods().added();
            if (added.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added methods: ");
            if (it.isAnnotation()) {
                Mappings.debug("Class is annotation, skipping method analysis");
                return;
            }
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myAffectedFiles != null);
            Ref oldItRef = null;
            for (MethodRepr m : added) {
                Mappings.this.debug("Method: ", m.name);
                if (!m.isPrivate() && (it.isInterface() || it.isAbstract() || m.isAbstract())) {
                    Mappings.debug("Class is abstract, or is interface, or added non-private method is abstract => affecting all subclasses");
                    this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                }
                TIntHashSet propagated = null;
                if (!m.isPrivate() && m.name != Mappings.this.myInitName) {
                    ClassRepr oldIt;
                    if (oldItRef == null) {
                        oldItRef = new Ref((Object)Mappings.this.getClassReprByName(null, it.name));
                    }
                    if (!((oldIt = (ClassRepr)oldItRef.get()) != null && this.myPresent.hasOverriddenMethods(oldIt, MethodRepr.equalByJavaRules(m), null) || m.myArgumentTypes.length <= 0)) {
                        propagated = this.myFuture.propagateMethodAccess(m, it.name);
                        Mappings.debug("Conservative case on overriding methods, affecting method usages");
                        this.myFuture.affectMethodUsages(m, propagated, m.createMetaUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    }
                }
                if (m.isPrivate()) continue;
                Collection affectedMethods = this.myFuture.findAllMethodsBySpecificity(m, it);
                MethodRepr.Predicate overrides = MethodRepr.equalByJavaRules(m);
                if (propagated == null) {
                    propagated = this.myFuture.propagateMethodAccess(m, it.name);
                }
                Collection<MethodRepr> lessSpecific = it.findMethods(this.myFuture.lessSpecific(m));
                for (MethodRepr mm : lessSpecific) {
                    if (mm.equals(m)) continue;
                    Mappings.debug("Found less specific method, affecting method usages");
                    this.myFuture.affectMethodUsages(mm, propagated, mm.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                Mappings.debug("Processing affected by specificity methods");
                for (Pair pair : affectedMethods) {
                    MethodRepr method = (MethodRepr)pair.first;
                    ClassRepr methodClass = (ClassRepr)pair.second;
                    if (methodClass == MOCK_CLASS) continue;
                    Boolean inheritorOf = this.myPresent.isInheritorOf(methodClass.name, it.name, null);
                    boolean isInheritor = inheritorOf != null && inheritorOf != false;
                    Mappings.this.debug("Method: ", method.name);
                    Mappings.this.debug("Class : ", methodClass.name);
                    if (overrides.satisfy(method) && isInheritor) {
                        Mappings.debug("Current method overrides that found");
                        Collection files = Mappings.this.myClassToSourceFile.get(methodClass.name);
                        if (files == null) continue;
                        this.myAffectedFiles.addAll(files);
                        for (File file : files) {
                            Mappings.this.debug("Affecting file ", file);
                        }
                        continue;
                    }
                    Mappings.debug("Current method does not override that found");
                    TIntHashSet yetPropagated = this.myPresent.propagateMethodAccess(method, it.name);
                    if (isInheritor) {
                        TIntHashSet deps = Mappings.this.myClassToClassDependency.get(methodClass.name);
                        if (deps != null) {
                            Mappings.addAll(state.myDependants, deps);
                        }
                        this.myFuture.affectMethodUsages(method, yetPropagated, method.createUsage(Mappings.this.myContext, methodClass.name), state.myAffectedUsages, state.myDependants);
                    }
                    Mappings.debug("Affecting method usages for that found");
                    this.myFuture.affectMethodUsages(method, yetPropagated, method.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                }
                TIntHashSet subClasses = Mappings.this.getAllSubclasses(it.name);
                subClasses.forEach(subClass -> {
                    ClassRepr outerClassRepr;
                    int outerClass;
                    ClassRepr r = this.myFuture.classReprByName(subClass);
                    if (r == null) {
                        return true;
                    }
                    Collection sourceFileNames = Mappings.this.myClassToSourceFile.get(subClass);
                    if (sourceFileNames != null && !this.myCompiledFiles.containsAll(sourceFileNames) && !Mappings.this.isEmpty(outerClass = r.getOuterClassName()) && (outerClassRepr = this.myFuture.classReprByName(outerClass)) != null && (this.myFuture.isMethodVisible(outerClassRepr, m) || this.myFuture.extendsLibraryClass(outerClassRepr, null))) {
                        this.myAffectedFiles.addAll(sourceFileNames);
                        for (File sourceFileName : sourceFileNames) {
                            Mappings.this.debug("Affecting file due to local overriding: ", sourceFileName);
                        }
                    }
                    return true;
                });
            }
            Mappings.debug("End of added methods processing");
        }

        private void processRemovedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<MethodRepr> removed = diff.methods().removed();
            if (removed.isEmpty()) {
                return;
            }
            assert (this.myFuture != null);
            assert (this.myAffectedFiles != null);
            assert (this.myCompiledFiles != null);
            Mappings.debug("Processing removed methods:");
            for (MethodRepr m : removed) {
                Mappings.this.debug("Method ", m.name);
                Collection overridenMethods = this.myFuture.findOverriddenMethods(m, it);
                TIntHashSet propagated = this.myFuture.propagateMethodAccess(m, it.name);
                if (overridenMethods.size() == 0) {
                    Mappings.debug("No overridden methods found, affecting method usages");
                    this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else {
                    boolean clear = true;
                    for (Pair overriden : overridenMethods) {
                        MethodRepr mm = (MethodRepr)overriden.first;
                        if (mm != MOCK_METHOD && mm.myType.equals(m.myType) && Mappings.this.isEmpty(mm.signature) && Mappings.this.isEmpty(m.signature) && !m.isMoreAccessibleThan(mm)) continue;
                        clear = false;
                        break;
                    }
                    if (!clear) {
                        Mappings.debug("No clearly overridden methods found, affecting method usages");
                        this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    }
                }
                HashSet overridingMethods = new HashSet();
                this.myFuture.addOverridingMethods(m, it, MethodRepr.equalByJavaRules(m), overridingMethods, null);
                for (Pair p2 : overridingMethods) {
                    Collection fNames = Mappings.this.myClassToSourceFile.get(((ClassRepr)p2.second).name);
                    if (fNames == null) continue;
                    this.myAffectedFiles.addAll(fNames);
                    for (File fName : fNames) {
                        Mappings.this.debug("Affecting file by overriding: ", fName);
                    }
                }
                if (m.isAbstract()) continue;
                propagated.forEach(p -> {
                    ClassRepr s;
                    if (p != it.name && (s = this.myFuture.classReprByName(p)) != null) {
                        Collection sources;
                        Collection overridenInS = this.myFuture.findOverriddenMethods(m, s);
                        overridenInS.addAll(overridenMethods);
                        boolean allAbstract = true;
                        boolean visited = false;
                        for (Pair pp : overridenInS) {
                            ClassRepr cc = (ClassRepr)pp.second;
                            if (cc == MOCK_CLASS) {
                                visited = true;
                                continue;
                            }
                            if (cc.name == it.name) continue;
                            visited = true;
                            allAbstract = ((MethodRepr)pp.first).isAbstract() || cc.isInterface();
                            if (allAbstract) continue;
                            break;
                        }
                        if (allAbstract && visited && (sources = Mappings.this.myClassToSourceFile.get(p)) != null && !this.myCompiledFiles.containsAll(sources)) {
                            this.myAffectedFiles.addAll(sources);
                            Mappings.this.debug("Removed method is not abstract & overrides some abstract method which is not then over-overridden in subclass ", p);
                            for (File source : sources) {
                                Mappings.this.debug("Affecting subclass source file ", source);
                            }
                        }
                    }
                    return true;
                });
            }
            Mappings.debug("End of removed methods processing");
        }

        private void processChangedMethods(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<MethodRepr, MethodRepr.Diff>> changed = diff.methods().changed();
            if (changed.isEmpty()) {
                return;
            }
            Mappings.debug("Processing changed methods:");
            assert (this.myFuture != null);
            assert (this.myAffectedFiles != null);
            for (Pair<MethodRepr, MethodRepr.Diff> mr : changed) {
                MethodRepr m = (MethodRepr)mr.first;
                MethodRepr.Diff d = (MethodRepr.Diff)mr.second;
                boolean throwsChanged = !d.exceptions().unchanged();
                Mappings.this.debug("Method: ", m.name);
                if (it.isAnnotation()) {
                    if (!d.defaultRemoved()) continue;
                    Mappings.debug("Class is annotation, default value is removed => adding annotation query");
                    TIntHashSet l = new TIntHashSet(32, 0.98f);
                    l.add(m.name);
                    UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, it.name), l, null);
                    state.myAnnotationQuery.add(annotationUsage);
                    continue;
                }
                if (d.base() == 0 && !throwsChanged) continue;
                TIntHashSet propagated = this.myFuture.propagateMethodAccess(m, it.name);
                boolean affected = false;
                boolean constrained = false;
                THashSet usages = new THashSet();
                if (d.packageLocalOn()) {
                    Mappings.debug("Method became package-private, affecting method usages outside the package");
                    this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                    for (Object usage : usages) {
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        util.getClass();
                        map.put((UsageRepr.Usage)usage, util.new Util.PackageConstraint(it.getPackageName()));
                    }
                    state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                    affected = true;
                    constrained = true;
                }
                if ((d.base() & 2) != 0 || (d.base() & 8) != 0 || throwsChanged) {
                    if (!affected) {
                        Object usage;
                        Mappings.debug("Return type, throws list or signature changed --- affecting method usages");
                        this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                        LinkedList overridingMethods = new LinkedList();
                        this.myFuture.addOverridingMethods(m, it, MethodRepr.equalByJavaRules(m), overridingMethods, null);
                        usage = overridingMethods.iterator();
                        while (usage.hasNext()) {
                            Collection fileNames;
                            Pair p = (Pair)usage.next();
                            ClassRepr aClass = (ClassRepr)p.getSecond();
                            if (aClass == MOCK_CLASS || (fileNames = Mappings.this.myClassToSourceFile.get(aClass.name)) == null) continue;
                            this.myAffectedFiles.addAll(fileNames);
                        }
                        state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                        affected = true;
                    }
                } else if ((d.base() & 1) != 0) {
                    if ((d.addedModifiers() & 0x104A) != 0 || (d.removedModifiers() & 8) != 0) {
                        if (!affected) {
                            Mappings.debug("Added {static | private | synthetic | bridge} specifier or removed static specifier --- affecting method usages");
                            this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                            affected = true;
                        }
                        if ((d.addedModifiers() & 8) != 0) {
                            Mappings.debug("Added static specifier --- affecting subclasses");
                            this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                        }
                    } else {
                        if ((d.addedModifiers() & 0x10) != 0 || (d.addedModifiers() & 1) != 0 || (d.addedModifiers() & 0x400) != 0) {
                            Mappings.debug("Added final, public or abstract specifier --- affecting subclasses");
                            this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
                        }
                        if ((d.addedModifiers() & 4) != 0 && (d.removedModifiers() & 2) == 0 && !constrained) {
                            Mappings.debug("Added public or package-private method became protected --- affect method usages with protected constraint");
                            if (!affected) {
                                this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                                state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                                affected = true;
                            }
                            for (Object usage : usages) {
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                util.getClass();
                                map.put((UsageRepr.Usage)usage, util.new Util.InheritanceConstraint(it));
                            }
                            constrained = true;
                        }
                    }
                }
                if ((d.base() & 0x40) == 0) continue;
                EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                    if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                    Set<AnnotationsChangeTracker.Recompile> actions = extension.methodAnnotationsChanged(Mappings.this.myContext, m, d.annotations(), d.parameterAnnotations());
                    if (actions.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in annotations list --- affecting method usages");
                    }
                    if (actions.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in method annotations or method parameter annotations list --- affecting subclasses");
                    }
                    toRecompile.addAll(actions);
                }
                if (toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                    this.myFuture.affectMethodUsages(m, propagated, m.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                    state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                    if (constrained) {
                        for (UsageRepr.Usage usage : usages) {
                            state.myUsageConstraints.remove(usage);
                        }
                    }
                }
                if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
            }
            Mappings.debug("End of changed methods processing");
        }

        private boolean processAddedFields(DiffState state, ClassRepr.Diff diff, ClassRepr classRepr) {
            Collection<FieldRepr> added = diff.fields().added();
            if (added.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing added fields");
            assert (this.myFuture != null);
            assert (this.myPresent != null);
            assert (this.myCompiledFiles != null);
            assert (this.myAffectedFiles != null);
            for (FieldRepr f : added) {
                Mappings.this.debug("Field: ", f.name);
                if (!f.isPrivate()) {
                    TIntHashSet subClasses = Mappings.this.getAllSubclasses(classRepr.name);
                    subClasses.forEach(subClass -> {
                        Collection sourceFileNames;
                        ClassRepr r = this.myFuture.classReprByName(subClass);
                        if (r != null && (sourceFileNames = Mappings.this.myClassToSourceFile.get(subClass)) != null && !this.myCompiledFiles.containsAll(sourceFileNames)) {
                            if (r.isLocal()) {
                                for (File sourceFileName : sourceFileNames) {
                                    Mappings.this.debug("Affecting local subclass (introduced field can potentially hide surrounding method parameters/local variables): ", sourceFileName);
                                }
                                this.myAffectedFiles.addAll(sourceFileNames);
                            } else {
                                int outerClass = r.getOuterClassName();
                                if (!Mappings.this.isEmpty(outerClass) && this.myFuture.isFieldVisible(outerClass, f)) {
                                    for (File sourceFileName : sourceFileNames) {
                                        Mappings.this.debug("Affecting inner subclass (introduced field can potentially hide surrounding class fields): ", sourceFileName);
                                    }
                                    this.myAffectedFiles.addAll(sourceFileNames);
                                }
                            }
                        }
                        Mappings.this.debug("Affecting field usages referenced from subclass ", subClass);
                        TIntHashSet propagated = this.myFuture.propagateFieldAccess(f.name, subClass);
                        this.myFuture.affectFieldUsages(f, propagated, f.createUsage(Mappings.this.myContext, subClass), state.myAffectedUsages, state.myDependants);
                        TIntHashSet deps = Mappings.this.myClassToClassDependency.get(subClass);
                        if (deps != null) {
                            Mappings.addAll(state.myDependants, deps);
                        }
                        return true;
                    });
                }
                HashSet<Pair<FieldRepr, ClassRepr>> overriddenFields = new HashSet<Pair<FieldRepr, ClassRepr>>();
                this.myFuture.addOverriddenFields(f, classRepr, overriddenFields, null);
                for (Pair pair : overriddenFields) {
                    boolean sameKind;
                    FieldRepr ff = (FieldRepr)pair.first;
                    ClassRepr cc = (ClassRepr)pair.second;
                    if (ff.isPrivate()) continue;
                    boolean bl = sameKind = f.myType.equals(ff.myType) && f.isStatic() == ff.isStatic() && f.isSynthetic() == ff.isSynthetic() && f.isFinal() == ff.isFinal();
                    if (sameKind && !Difference.weakerAccess(f.access, ff.access)) continue;
                    TIntHashSet propagated = this.myPresent.propagateFieldAccess(ff.name, cc.name);
                    HashSet<UsageRepr.Usage> affectedUsages = new HashSet<UsageRepr.Usage>();
                    Mappings.this.debug("Affecting usages of overridden field in class ", cc.name);
                    this.myFuture.affectFieldUsages(ff, propagated, ff.createUsage(Mappings.this.myContext, cc.name), affectedUsages, state.myDependants);
                    if (sameKind) {
                        Util.PackageConstraint constraint = null;
                        if (f.isProtected()) {
                            Util util = this.myFuture;
                            util.getClass();
                            constraint = util.new Util.InheritanceConstraint(cc);
                        } else if (f.isPackageLocal()) {
                            Util util = this.myFuture;
                            util.getClass();
                            constraint = util.new Util.PackageConstraint(cc.getPackageName());
                        }
                        if (constraint != null) {
                            for (UsageRepr.Usage usage : affectedUsages) {
                                state.myUsageConstraints.put(usage, constraint);
                            }
                        }
                    }
                    state.myAffectedUsages.addAll(affectedUsages);
                }
            }
            Mappings.debug("End of added fields processing");
            return true;
        }

        private boolean processRemovedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<FieldRepr> removed = diff.fields().removed();
            if (removed.isEmpty()) {
                return true;
            }
            assert (this.myFuture != null);
            Mappings.debug("Processing removed fields:");
            for (FieldRepr f : removed) {
                Mappings.this.debug("Field: ", f.name);
                if (!f.isPrivate() && (f.access & 0x10) == 16 && f.hasValue()) {
                    Mappings.debug("Field had value and was (non-private) final static => a switch to non-incremental mode requested");
                    if (this.myConstantSearch != null) {
                        assert (this.myDelayedWorks != null);
                        this.myDelayedWorks.addConstantWork(it.name, f, true, false);
                    } else if (!Mappings.this.incrementalDecision(it.name, f, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                        Mappings.debug("End of Differentiate, returning false");
                        return false;
                    }
                }
                TIntHashSet propagated = this.myFuture.propagateFieldAccess(f.name, it.name);
                this.myFuture.affectFieldUsages(f, propagated, f.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
            }
            Mappings.debug("End of removed fields processing");
            return true;
        }

        private boolean processChangedFields(DiffState state, ClassRepr.Diff diff, ClassRepr it) {
            Collection<Pair<FieldRepr, Difference>> changed = diff.fields().changed();
            if (changed.isEmpty()) {
                return true;
            }
            Mappings.debug("Processing changed fields:");
            assert (this.myFuture != null);
            for (Pair<FieldRepr, Difference> f : changed) {
                Difference d = (Difference)f.second;
                FieldRepr field = (FieldRepr)f.first;
                Mappings.this.debug("Field: ", field.name);
                if (!field.isPrivate() && (field.access & 0x10) == 16 && d.hadValue()) {
                    boolean valueChanged;
                    int changedModifiers = d.addedModifiers() | d.removedModifiers();
                    boolean harmful = (changedModifiers & 0x18) != 0;
                    boolean accessChanged = (changedModifiers & 7) != 0;
                    boolean becameLessAccessible = accessChanged && d.accessRestricted();
                    boolean bl = valueChanged = (d.base() & 4) != 0;
                    if (harmful || valueChanged || becameLessAccessible) {
                        Mappings.debug("Inline field changed it's access or value => a switch to non-incremental mode requested");
                        if (this.myConstantSearch != null) {
                            assert (this.myDelayedWorks != null);
                            this.myDelayedWorks.addConstantWork(it.name, field, false, accessChanged);
                        } else if (!Mappings.this.incrementalDecision(it.name, field, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                            Mappings.debug("End of Differentiate, returning false");
                            return false;
                        }
                    }
                }
                if (d.base() == 0) continue;
                TIntHashSet propagated = this.myFuture.propagateFieldAccess(field.name, it.name);
                if ((d.base() & 2) != 0 || (d.base() & 8) != 0) {
                    Mappings.debug("Type or signature changed --- affecting field usages");
                    this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                } else if ((d.base() & 1) != 0) {
                    if ((d.addedModifiers() & 8) != 0 || (d.removedModifiers() & 8) != 0 || (d.addedModifiers() & 2) != 0 || (d.addedModifiers() & 0x40) != 0) {
                        Mappings.debug("Added/removed static modifier or added private/volatile modifier --- affecting field usages");
                        this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), state.myAffectedUsages, state.myDependants);
                    } else {
                        THashSet usages = new THashSet();
                        if ((d.addedModifiers() & 0x10) != 0) {
                            Mappings.debug("Added final modifier --- affecting field assign usages");
                            this.myFuture.affectFieldUsages(field, propagated, field.createAssignUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                        }
                        if ((d.removedModifiers() & 1) != 0) {
                            Mappings.debug("Removed public modifier, affecting field usages with appropriate constraint");
                            this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                            for (UsageRepr.Usage usage : usages) {
                                if ((d.addedModifiers() & 4) != 0) {
                                    Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                    Util util = this.myFuture;
                                    util.getClass();
                                    map.put(usage, util.new Util.InheritanceConstraint(it));
                                    continue;
                                }
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                util.getClass();
                                map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                            }
                        } else if ((d.removedModifiers() & 4) != 0 && d.accessRestricted()) {
                            Mappings.debug("Removed protected modifier and the field became less accessible, affecting field usages with package constraint");
                            this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                            state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                            for (UsageRepr.Usage usage : usages) {
                                Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                                Util util = this.myFuture;
                                util.getClass();
                                map.put(usage, util.new Util.PackageConstraint(it.getPackageName()));
                            }
                        }
                    }
                }
                if ((d.base() & 0x40) == 0) continue;
                EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                    if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                    Set<AnnotationsChangeTracker.Recompile> res = extension.fieldAnnotationsChanged(Mappings.this.myContext, field, d.annotations());
                    if (res.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in annotations list --- affecting field usages");
                    }
                    if (res.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                        Mappings.debug("Extension " + extension.getClass().getName() + " requested recompilation because of changes in field annotations list --- affecting subclasses");
                    }
                    toRecompile.addAll(res);
                }
                if (toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                    THashSet usages = new THashSet();
                    this.myFuture.affectFieldUsages(field, propagated, field.createUsage(Mappings.this.myContext, it.name), (Set<UsageRepr.Usage>)usages, state.myDependants);
                    state.myAffectedUsages.addAll((Collection<UsageRepr.Usage>)usages);
                    for (UsageRepr.Usage usage : usages) {
                        state.myUsageConstraints.remove(usage);
                    }
                }
                if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                this.myFuture.affectSubclasses(it.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, false, this.myCompiledFiles, null);
            }
            Mappings.debug("End of changed fields processing");
            return true;
        }

        private boolean processChangedClasses(DiffState state) {
            Collection<Pair<ClassRepr, ClassRepr.Diff>> changedClasses = state.myClassDiff.changed();
            if (!changedClasses.isEmpty()) {
                Util.FileFilterConstraint fileFilterConstraint;
                Mappings.debug("Processing changed classes:");
                assert (this.myFuture != null);
                assert (this.myPresent != null);
                if (this.myFilter != null) {
                    Util util = this.myPresent;
                    util.getClass();
                    fileFilterConstraint = util.new Util.FileFilterConstraint(this.myFilter);
                } else {
                    fileFilterConstraint = null;
                }
                Util.FileFilterConstraint fileFilterConstraint2 = fileFilterConstraint;
                for (Pair<ClassRepr, ClassRepr.Diff> changed : changedClasses) {
                    boolean recompileUsages;
                    boolean signatureChanged;
                    ClassRepr changedClass = (ClassRepr)changed.first;
                    ClassRepr.Diff diff = (ClassRepr.Diff)changed.second;
                    this.myDelta.addChangedClass(changedClass.name);
                    Mappings.this.debug("Changed: ", changedClass.name);
                    int addedModifiers = diff.addedModifiers();
                    boolean superClassChanged = (diff.base() & 0x10) != 0;
                    boolean interfacesChanged = !diff.interfaces().unchanged();
                    boolean bl = signatureChanged = (diff.base() & 8) != 0;
                    if (superClassChanged) {
                        this.myDelta.registerRemovedSuperClass(changedClass.name, changedClass.getSuperClass().className);
                        Iterator<TypeRepr.AbstractType> newClass = this.myDelta.getClassReprByName(null, changedClass.name);
                        assert (newClass != null);
                        this.myDelta.registerAddedSuperClass(changedClass.name, ((ClassRepr)((Object)newClass)).getSuperClass().className);
                    }
                    if (interfacesChanged) {
                        for (TypeRepr.AbstractType typ : diff.interfaces().removed()) {
                            this.myDelta.registerRemovedSuperClass(changedClass.name, ((TypeRepr.ClassType)typ).className);
                        }
                        for (TypeRepr.AbstractType typ : diff.interfaces().added()) {
                            this.myDelta.registerAddedSuperClass(changedClass.name, ((TypeRepr.ClassType)typ).className);
                        }
                    }
                    if (this.myEasyMode) continue;
                    this.myPresent.appendDependents(changedClass, state.myDependants);
                    if (superClassChanged || interfacesChanged || signatureChanged) {
                        Mappings.this.debug("Superclass changed: ", superClassChanged);
                        Mappings.this.debug("Interfaces changed: ", interfacesChanged);
                        Mappings.this.debug("Signature changed ", signatureChanged);
                        boolean extendsChanged = superClassChanged && !diff.extendsAdded();
                        boolean interfacesRemoved = interfacesChanged && !diff.interfaces().removed().isEmpty();
                        Mappings.this.debug("Extends changed: ", extendsChanged);
                        Mappings.this.debug("Interfaces removed: ", interfacesRemoved);
                        this.myFuture.affectSubclasses(changedClass.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, extendsChanged || interfacesRemoved || signatureChanged, this.myCompiledFiles, null);
                        if (!changedClass.isAnonymous()) {
                            TIntHashSet parents = new TIntHashSet();
                            this.myPresent.collectSupersRecursively(changedClass.name, parents);
                            TIntHashSet futureParents = new TIntHashSet();
                            this.myFuture.collectSupersRecursively(changedClass.name, futureParents);
                            parents.removeAll(futureParents.toArray());
                            parents.remove(Mappings.this.myObjectClassName);
                            if (!parents.isEmpty()) {
                                parents.forEach(className -> {
                                    TIntHashSet depClasses;
                                    Mappings.this.debug("Affecting usages in generic type parameter bounds of class: ", className);
                                    UsageRepr.Usage usage = UsageRepr.createClassAsGenericBoundUsage(Mappings.this.myContext, className);
                                    state.myAffectedUsages.add(usage);
                                    if (fileFilterConstraint2 != null) {
                                        state.myUsageConstraints.put(usage, fileFilterConstraint2);
                                    }
                                    if ((depClasses = Mappings.this.myClassToClassDependency.get(className)) != null) {
                                        Mappings.addAll(state.myDependants, depClasses);
                                    }
                                    return true;
                                });
                            }
                        }
                    }
                    if ((diff.addedModifiers() & 0x200) != 0 || (diff.removedModifiers() & 0x200) != 0) {
                        Mappings.debug("Class-to-interface or interface-to-class conversion detected, added class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (changedClass.isAnnotation() && changedClass.getRetentionPolicy() == RetentionPolicy.SOURCE) {
                        Mappings.debug("Annotation, retention policy = SOURCE => a switch to non-incremental mode requested");
                        if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                            Mappings.debug("End of Differentiate, returning false");
                            return false;
                        }
                    }
                    if ((addedModifiers & 4) != 0) {
                        Mappings.debug("Introduction of 'protected' modifier detected, adding class usage + inheritance constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        util.getClass();
                        map.put(usage, util.new Util.InheritanceConstraint(changedClass));
                    }
                    if (diff.packageLocalOn()) {
                        Mappings.debug("Introduction of 'package-private' access detected, adding class usage + package constraint to affected usages");
                        UsageRepr.Usage usage = changedClass.createUsage();
                        state.myAffectedUsages.add(usage);
                        Map<UsageRepr.Usage, UsageConstraint> map = state.myUsageConstraints;
                        Util util = this.myFuture;
                        util.getClass();
                        map.put(usage, util.new Util.PackageConstraint(changedClass.getPackageName()));
                    }
                    if ((addedModifiers & 0x10) != 0 || (addedModifiers & 2) != 0) {
                        Mappings.debug("Introduction of 'private' or 'final' modifier(s) detected, adding class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if ((addedModifiers & 0x400) != 0 || (addedModifiers & 8) != 0) {
                        Mappings.debug("Introduction of 'abstract' or 'static' modifier(s) detected, adding class new usage to affected usages");
                        state.myAffectedUsages.add(UsageRepr.createClassNewUsage(Mappings.this.myContext, changedClass.name));
                    }
                    if (!(changedClass.isAnonymous() || Mappings.this.isEmpty(changedClass.getOuterClassName()) || changedClass.isPrivate() || addedModifiers == 0 && diff.removedModifiers() == 0)) {
                        Mappings.debug("Some modifiers (access flags) were changed for non-private inner class, adding class usage to affected usages");
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (changedClass.isAnnotation()) {
                        Mappings.debug("Class is annotation, performing annotation-specific analysis");
                        if (diff.retentionChanged()) {
                            Mappings.debug("Retention policy change detected, adding class usage to affected usages");
                            state.myAffectedUsages.add(changedClass.createUsage());
                        } else if (diff.targetAttributeCategoryMightChange()) {
                            Mappings.debug("Annotation's attribute category in bytecode might be affected because of TYPE_USE target, adding class usage to affected usages");
                            state.myAffectedUsages.add(changedClass.createUsage());
                        } else {
                            Collection<ElemType> removedtargets = diff.targets().removed();
                            if (removedtargets.contains((Object)ElemType.LOCAL_VARIABLE)) {
                                Mappings.debug("Removed target contains LOCAL_VARIABLE => a switch to non-incremental mode requested");
                                if (!Mappings.this.incrementalDecision(changedClass.getOuterClassName(), changedClass, this.myAffectedFiles, this.myFilesToCompile, this.myFilter)) {
                                    Mappings.debug("End of Differentiate, returning false");
                                    return false;
                                }
                            }
                            if (!removedtargets.isEmpty()) {
                                Mappings.debug("Removed some annotation targets, adding annotation query");
                                state.myAnnotationQuery.add((UsageRepr.AnnotationUsage)UsageRepr.createAnnotationUsage(Mappings.this.myContext, TypeRepr.createClassType(Mappings.this.myContext, changedClass.name), null, EnumSet.copyOf(removedtargets)));
                            }
                            for (MethodRepr m : diff.methods().added()) {
                                if (m.hasValue()) continue;
                                Mappings.this.debug("Added method with no default value: ", m.name);
                                Mappings.debug("Adding class usage to affected usages");
                                state.myAffectedUsages.add(changedClass.createUsage());
                            }
                        }
                        Mappings.debug("End of annotation-specific analysis");
                    }
                    this.processAddedMethods(state, diff, changedClass);
                    this.processRemovedMethods(state, diff, changedClass);
                    this.processChangedMethods(state, diff, changedClass);
                    if (!this.processAddedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (!this.processRemovedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if (!this.processChangedFields(state, diff, changedClass)) {
                        return false;
                    }
                    if ((diff.base() & 0x40) == 0) continue;
                    EnumSet<AnnotationsChangeTracker.Recompile> toRecompile = EnumSet.noneOf(AnnotationsChangeTracker.Recompile.class);
                    for (AnnotationsChangeTracker extension : this.myAnnotationChangeTracker) {
                        if (toRecompile.containsAll(AnnotationsChangeTracker.RECOMPILE_ALL)) break;
                        Set<AnnotationsChangeTracker.Recompile> res = extension.classAnnotationsChanged(Mappings.this.myContext, changedClass, diff.annotations());
                        if (res.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                            Mappings.debug("Extension " + extension.getClass().getName() + " requested class usages recompilation because of changes in annotations list --- adding class usage to affected usages");
                        }
                        if (res.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) {
                            Mappings.debug("Extension " + extension.getClass().getName() + " requested subclasses recompilation because of changes in annotations list --- adding subclasses to affected usages");
                        }
                        toRecompile.addAll(res);
                    }
                    if (recompileUsages = toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.USAGES)) {
                        state.myAffectedUsages.add(changedClass.createUsage());
                    }
                    if (!toRecompile.contains((Object)AnnotationsChangeTracker.Recompile.SUBCLASSES)) continue;
                    this.myFuture.affectSubclasses(changedClass.name, this.myAffectedFiles, state.myAffectedUsages, state.myDependants, recompileUsages, this.myCompiledFiles, null);
                }
                Mappings.debug("End of changed classes processing");
            }
            return !this.myEasyMode;
        }

        private void processRemovedClases(DiffState state, @NotNull File fileName) {
            Collection<ClassRepr> removed;
            if (fileName == null) {
                Differential.$$$reportNull$$$0(1);
            }
            if ((removed = state.myClassDiff.removed()).isEmpty()) {
                return;
            }
            assert (this.myPresent != null);
            assert (this.myDelta.myChangedFiles != null);
            this.myDelta.myChangedFiles.add((Object)fileName);
            Mappings.debug("Processing removed classes:");
            for (ClassRepr c : removed) {
                this.myDelta.addDeletedClass(c, fileName);
                if (this.myEasyMode) continue;
                this.myPresent.appendDependents(c, state.myDependants);
                Mappings.this.debug("Adding usages of class ", c.name);
                state.myAffectedUsages.add(c.createUsage());
                Mappings.this.debug("Affecting usages of removed class ", c.name);
                Mappings.this.affectAll(c.name, fileName, this.myAffectedFiles, this.myCompiledFiles, this.myFilter);
            }
            Mappings.debug("End of removed classes processing.");
        }

        private void processAddedClasses(DiffState state, File srcFile) {
            Collection<ClassRepr> addedClasses = state.myClassDiff.added();
            if (addedClasses.isEmpty()) {
                return;
            }
            Mappings.debug("Processing added classes:");
            if (!this.myEasyMode && this.myFilter != null) {
                assert (this.myCompiledFiles != null);
                assert (this.myAffectedFiles != null);
                for (ClassRepr c : addedClasses) {
                    if (c.isLocal() || c.isAnonymous() || !Mappings.this.isEmpty(c.getOuterClassName())) continue;
                    Object candidates = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    Collection currentlyMapped = Mappings.this.myClassToSourceFile.get(c.name);
                    if (currentlyMapped != null) {
                        candidates.addAll(currentlyMapped);
                    }
                    candidates.removeAll(this.myCompiledFiles);
                    Collection newSources = this.myDelta.myClassToSourceFile.get(c.name);
                    if (newSources != null) {
                        candidates.removeAll(newSources);
                    }
                    THashSet nonExistentOrOutOfScope = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    Iterator iterator = candidates.iterator();
                    while (iterator.hasNext()) {
                        File candidate = (File)iterator.next();
                        if (candidate.exists() && this.myFilter.belongsToCurrentTargetChunk(candidate)) continue;
                        nonExistentOrOutOfScope.add(candidate);
                    }
                    candidates.removeAll((Collection<?>)nonExistentOrOutOfScope);
                    if (candidates.isEmpty()) continue;
                    candidates.clear();
                    if (currentlyMapped != null) {
                        candidates.addAll(currentlyMapped);
                    }
                    if (newSources != null) {
                        candidates.addAll(newSources);
                    }
                    candidates.removeAll((Collection<?>)nonExistentOrOutOfScope);
                    if (Mappings.this.myDebugS.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Possibly duplicated classes; Scheduling for recompilation sources: ");
                        Iterator iterator2 = candidates.iterator();
                        while (iterator2.hasNext()) {
                            File file = (File)iterator2.next();
                            msg.append(file.getPath()).append("; ");
                        }
                        Mappings.debug(msg.toString());
                    }
                    this.myAffectedFiles.addAll((Collection<File>)candidates);
                    return;
                }
            }
            for (ClassRepr c : addedClasses) {
                Mappings.this.debug("Class name: ", c.name);
                this.myDelta.addAddedClass(c);
                for (int sup : c.getSupers()) {
                    this.myDelta.registerAddedSuperClass(c.name, sup);
                }
                if (this.myEasyMode || c.isAnonymous() || c.isLocal()) continue;
                TIntHashSet toAffect = new TIntHashSet();
                toAffect.add(c.name);
                TIntHashSet classes = Mappings.this.myShortClassNameIndex.get(Mappings.this.myContext.get(c.getShortName()));
                if (classes != null) {
                    toAffect.addAll(classes.toArray());
                }
                toAffect.forEach(qName -> {
                    TIntHashSet depClasses = Mappings.this.myClassToClassDependency.get(qName);
                    if (depClasses != null) {
                        this.affectCorrespondingSourceFiles(depClasses);
                    }
                    return true;
                });
            }
            Mappings.debug("End of added classes processing.");
        }

        private void affectCorrespondingSourceFiles(TIntHashSet toAffect) {
            assert (this.myAffectedFiles != null);
            toAffect.forEach(depClass -> {
                Collection fNames = Mappings.this.myClassToSourceFile.get(depClass);
                if (fNames != null) {
                    for (File fName : fNames) {
                        if (this.myFilter != null && !this.myFilter.accept(fName)) continue;
                        Mappings.this.debug("Adding dependent file ", fName);
                        this.myAffectedFiles.add(fName);
                    }
                }
                return true;
            });
        }

        private void calculateAffectedFiles(final DiffState state) {
            Mappings.debug("Checking dependent classes:");
            assert (this.myAffectedFiles != null);
            assert (this.myCompiledFiles != null);
            state.myDependants.forEach(new TIntProcedure(){

                public boolean execute(int depClass) {
                    Collection depFiles = Mappings.this.myClassToSourceFile.get(depClass);
                    if (depFiles != null) {
                        for (File depFile : depFiles) {
                            this.processDependentFile(depClass, depFile);
                        }
                    }
                    return true;
                }

                private void processDependentFile(int depClass, @NotNull File depFile) {
                    if (depFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (Differential.this.myAffectedFiles.contains(depFile) || Differential.this.myCompiledFiles.contains(depFile)) {
                        return;
                    }
                    Mappings.this.debug("Dependent class: ", depClass);
                    ClassFileRepr repr = Mappings.this.getReprByName(depFile, depClass);
                    if (repr == null) {
                        return;
                    }
                    Set<UsageRepr.Usage> depUsages = repr.getUsages();
                    if (depUsages == null || depUsages.isEmpty()) {
                        return;
                    }
                    for (UsageRepr.Usage usage : depUsages) {
                        if (usage instanceof UsageRepr.AnnotationUsage) {
                            UsageRepr.AnnotationUsage annotationUsage = (UsageRepr.AnnotationUsage)usage;
                            for (UsageRepr.AnnotationUsage query : state.myAnnotationQuery) {
                                if (!query.satisfies(annotationUsage)) continue;
                                Mappings.debug("Added file due to annotation query");
                                Differential.this.myAffectedFiles.add(depFile);
                                return;
                            }
                            continue;
                        }
                        if (!state.myAffectedUsages.contains(usage)) continue;
                        UsageConstraint constraint = state.myUsageConstraints.get(usage);
                        if (constraint == null) {
                            Mappings.debug("Added file with no constraints");
                            Differential.this.myAffectedFiles.add(depFile);
                            return;
                        }
                        if (!constraint.checkResidence(depClass)) continue;
                        Mappings.debug("Added file with satisfied constraint");
                        Differential.this.myAffectedFiles.add(depFile);
                        return;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depFile", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential$1", "processDependentFile"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean differentiate() {
            var1_1 = Mappings.access$4000(Mappings.this);
            synchronized (var1_1) {
                block26: {
                    block27: {
                        Mappings.access$4102(this.myDelta, true);
                        if (Mappings.access$1800(this.myDelta)) {
                            return true;
                        }
                        Mappings.access$1200("Begin of Differentiate:");
                        Mappings.access$3400(Mappings.this, "Easy mode: ", this.myEasyMode);
                        this.processDisappearedClasses();
                        newClasses = new ArrayList<E>();
                        Mappings.access$2300(this.myDelta).forEachEntry(new TObjectObjectProcedure<File, Collection<ClassFileRepr>>(){

                            public boolean execute(File fileName, Collection<ClassFileRepr> content) {
                                if (Differential.this.myFilesToCompile == null || Differential.this.myFilesToCompile.contains(fileName)) {
                                    newClasses.add(new FileClasses(fileName, content));
                                }
                                return true;
                            }
                        });
                        var3_3 = newClasses.iterator();
lbl14:
                        // 3 sources

                        while (true) {
                            if (var3_3.hasNext()) {
                                compiledFile = (FileClasses)var3_3.next();
                                fileName = compiledFile.myFileName;
                                pastClasses = new THashSet();
                                pastModules = new THashSet();
                                past = Mappings.access$2300(Mappings.this).get(fileName);
                                if (past == null) break block26;
                                var9_11 = past.iterator();
                                break block27;
                            }
                            addedClasses = Mappings.access$4200(this.myDelta);
                            if (!addedClasses.isEmpty()) {
                                addedNames = new TIntHashSet();
                                for (ClassRepr repr : addedClasses) {
                                    addedNames.add(repr.name);
                                }
                                for (FileClasses compiledFile : newClasses) {
                                    for (ClassRepr aClass : compiledFile.myFileClasses) {
                                        for (Object parent : (Iterator<V>)aClass.getSupers()) {
                                            if (!addedNames.contains((int)parent)) continue;
                                            Mappings.access$3300(this.myDelta, aClass.name, (int)parent);
                                        }
                                    }
                                }
                            }
                            Mappings.access$1200("End of Differentiate.");
                            if (this.myEasyMode) {
                                addedNames = false;
                                return addedNames;
                            }
                            if (!Differential.$assertionsDisabled && this.myAffectedFiles == null) {
                                throw new AssertionError();
                            }
                            if (!Differential.$assertionsDisabled && this.myDelayedWorks == null) {
                                throw new AssertionError();
                            }
                            removed = Mappings.access$1900(this.myDelta);
                            if (removed != null) {
                                for (String r : removed) {
                                    this.myAffectedFiles.remove(new File(r));
                                }
                            }
                            var5_7 = this.myDelayedWorks.doWork(this.myAffectedFiles);
                            return var5_7;
                        }
                        finally {
                            if (this.myFilesToCompile != null) {
                                if (!Differential.$assertionsDisabled && Mappings.access$3500(this.myDelta) == null) {
                                    throw new AssertionError();
                                }
                                Mappings.access$3500(this.myDelta).retainAll(this.myFilesToCompile);
                            }
                        }
                    }
                    while (var9_11.hasNext()) {
                        repr = (ClassFileRepr)var9_11.next();
                        if (repr instanceof ClassRepr) {
                            pastClasses.add((ClassRepr)repr);
                            continue;
                        }
                        pastModules.add((ModuleRepr)repr);
                    }
                }
                state = new DiffState(Difference.make(pastClasses, compiledFile.myFileClasses), Difference.make(pastModules, compiledFile.myFileModules));
                if (!this.myEasyMode) {
                    this.processModules(state, fileName);
                }
                if (!this.processChangedClasses(state) && !this.myEasyMode) {
                    var10_13 = false;
                    return var10_13;
                }
                this.processRemovedClases(state, fileName);
                this.processAddedClasses(state, fileName);
                if (this.myEasyMode) ** GOTO lbl14
                this.calculateAffectedFiles(state);
                ** continue;
            }
        }

        private void processModules(DiffState state, File fileName) {
            Difference.Specifier<ModuleRepr, ModuleRepr.Diff> modulesDiff = state.myModulesDiff;
            if (modulesDiff.unchanged()) {
                return;
            }
            for (ModuleRepr moduleRepr : modulesDiff.added()) {
                this.myDelta.addChangedClass(moduleRepr.name);
                this.myFuture.affectModule(moduleRepr, this.myAffectedFiles);
            }
            for (ModuleRepr moduleRepr : modulesDiff.removed()) {
                this.myDelta.addDeletedClass(moduleRepr, fileName);
                this.myPresent.affectDependentModules(state, moduleRepr.name, null, true);
            }
            for (Pair pair : modulesDiff.changed()) {
                final ModuleRepr moduleRepr = (ModuleRepr)pair.first;
                ModuleRepr.Diff d = (ModuleRepr.Diff)pair.second;
                boolean affectSelf = false;
                boolean affectDeps = false;
                UsageConstraint constraint = null;
                this.myDelta.addChangedClass(moduleRepr.name);
                if (d.versionChanged()) {
                    final int version = moduleRepr.getVersion();
                    this.myPresent.affectDependentModules(state, moduleRepr.name, new UsageConstraint(){

                        @Override
                        public boolean checkResidence(int dep) {
                            ModuleRepr depModule = Differential.this.myPresent.moduleReprByName(dep);
                            if (depModule != null) {
                                for (ModuleRequiresRepr requires : depModule.getRequires()) {
                                    if (requires.name != moduleRepr.name || requires.getVersion() != version) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                    }, false);
                }
                Difference.Specifier<ModuleRequiresRepr, ModuleRequiresRepr.Diff> requiresDiff = d.requires();
                for (ModuleRequiresRepr moduleRequiresRepr : requiresDiff.removed()) {
                    affectSelf = true;
                    if (!moduleRequiresRepr.isTransitive()) continue;
                    affectDeps = true;
                    constraint = UsageConstraint.ANY;
                    break;
                }
                for (Pair pair2 : requiresDiff.changed()) {
                    affectSelf |= ((ModuleRequiresRepr.Diff)pair2.second).versionChanged();
                    if (!((ModuleRequiresRepr.Diff)pair2.second).becameNonTransitive()) continue;
                    affectDeps = true;
                    constraint = UsageConstraint.ANY;
                }
                Difference.Specifier<ModulePackageRepr, ModulePackageRepr.Diff> exportsDiff = d.exports();
                if (!affectDeps) {
                    for (ModulePackageRepr modulePackageRepr : exportsDiff.removed()) {
                        affectDeps = true;
                        if (!modulePackageRepr.isQualified()) {
                            constraint = UsageConstraint.ANY;
                            break;
                        }
                        for (Integer name : modulePackageRepr.getModuleNames()) {
                            UsageConstraint matchName = UsageConstraint.exactMatch(name);
                            if (constraint == null) {
                                constraint = matchName;
                                continue;
                            }
                            constraint = constraint.or(matchName);
                        }
                    }
                }
                if (!affectDeps || constraint != UsageConstraint.ANY) {
                    for (Pair<ModulePackageRepr, ModulePackageRepr.Diff> pair3 : exportsDiff.changed()) {
                        Collection<Integer> removedModuleNames = ((ModulePackageRepr.Diff)pair3.second).targetModules().removed();
                        affectDeps |= !removedModuleNames.isEmpty();
                        if (removedModuleNames.isEmpty()) continue;
                        affectDeps = true;
                        for (Integer name : removedModuleNames) {
                            UsageConstraint matchName = UsageConstraint.exactMatch(name);
                            if (constraint == null) {
                                constraint = matchName;
                                continue;
                            }
                            constraint = constraint.or(matchName);
                        }
                    }
                }
                if (affectSelf) {
                    this.myPresent.affectModule(moduleRepr, this.myAffectedFiles);
                }
                if (!affectDeps) continue;
                this.myPresent.affectDependentModules(state, moduleRepr.name, constraint, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processRemovedClases";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class DiffState {
            public final TIntHashSet myDependants = new TIntHashSet(32, 0.98f);
            public final Set<UsageRepr.Usage> myAffectedUsages = new HashSet<UsageRepr.Usage>();
            public final Set<UsageRepr.AnnotationUsage> myAnnotationQuery = new HashSet<UsageRepr.AnnotationUsage>();
            public final Map<UsageRepr.Usage, UsageConstraint> myUsageConstraints = new HashMap<UsageRepr.Usage, UsageConstraint>();
            final Difference.Specifier<ClassRepr, ClassRepr.Diff> myClassDiff;
            final Difference.Specifier<ModuleRepr, ModuleRepr.Diff> myModulesDiff;

            DiffState(Difference.Specifier<ClassRepr, ClassRepr.Diff> classDiff, Difference.Specifier<ModuleRepr, ModuleRepr.Diff> modulesDiff) {
                this.myClassDiff = classDiff;
                this.myModulesDiff = modulesDiff;
            }
        }

        private class FileClasses {
            final File myFileName;
            final Set<ClassRepr> myFileClasses = new THashSet();
            final Set<ModuleRepr> myFileModules = new THashSet();

            FileClasses(File fileName, Collection<ClassFileRepr> fileContent) {
                this.myFileName = fileName;
                for (ClassFileRepr repr : fileContent) {
                    if (repr instanceof ClassRepr) {
                        this.myFileClasses.add((ClassRepr)repr);
                        continue;
                    }
                    this.myFileModules.add((ModuleRepr)repr);
                }
            }
        }

        private class DelayedWorks {
            final Collection<Triple> myQueue = new LinkedList<Triple>();

            private DelayedWorks() {
            }

            void addConstantWork(int ownerClass, FieldRepr changedField, boolean isRemoved, boolean accessChanged) {
                Future<Callbacks.ConstantAffection> future;
                if (Differential.this.myConstantSearch == null) {
                    future = null;
                } else {
                    String className = Mappings.this.myContext.getValue(ownerClass);
                    String fieldName = Mappings.this.myContext.getValue(changedField.name);
                    future = Differential.this.myConstantSearch.request(className.replace('/', '.'), fieldName, changedField.access, isRemoved, accessChanged);
                }
                this.myQueue.add(new Triple(ownerClass, changedField, future));
            }

            boolean doWork(@NotNull Collection<File> affectedFiles) {
                if (affectedFiles == null) {
                    DelayedWorks.$$$reportNull$$$0(0);
                }
                if (!this.myQueue.isEmpty()) {
                    Mappings.debug("Starting delayed works.");
                    for (Triple t : this.myQueue) {
                        Callbacks.ConstantAffection affection = t.getAffection();
                        Mappings.this.debug("Class: ", t.owner);
                        Mappings.this.debug("Field: ", t.field.name);
                        if (!affection.isKnown()) {
                            if (Differential.this.myConstantSearch != null) {
                                Mappings.debug("No external dependency information available.");
                            } else {
                                Mappings.debug("Constant search service not available.");
                            }
                            Mappings.debug("Trying to soften non-incremental decision.");
                            if (Mappings.this.incrementalDecision(t.owner, t.field, affectedFiles, Differential.this.myFilesToCompile, Differential.this.myFilter)) continue;
                            Mappings.debug("No luck.");
                            Mappings.debug("End of delayed work, returning false.");
                            return false;
                        }
                        Mappings.debug("External dependency information retrieved.");
                        Collection<File> files = affection.getAffectedFiles();
                        if (Differential.this.myFilter == null) {
                            affectedFiles.addAll(files);
                            continue;
                        }
                        for (File file : files) {
                            if (!Differential.this.myFilter.accept(file)) continue;
                            affectedFiles.add(file);
                        }
                    }
                    Mappings.debug("End of delayed work, returning true.");
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedFiles", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Differential$DelayedWorks", "doWork"));
            }

            class Triple {
                final int owner;
                final FieldRepr field;
                @Nullable
                final Future<Callbacks.ConstantAffection> affection;

                private Triple(int owner, @Nullable FieldRepr field, Future<Callbacks.ConstantAffection> affection) {
                    this.owner = owner;
                    this.field = field;
                    this.affection = affection;
                }

                Callbacks.ConstantAffection getAffection() {
                    try {
                        return this.affection != null ? this.affection.get() : Callbacks.ConstantAffection.EMPTY;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static interface DependentFilesFilter {
        public boolean accept(File var1);

        public boolean belongsToCurrentTargetChunk(File var1);
    }

    private class Util {
        @Nullable
        private final Mappings myMappings;

        private Util() {
            this.myMappings = null;
        }

        private Util(Mappings mappings2) {
            if (mappings2 == null) {
                Util.$$$reportNull$$$0(0);
            }
            this.myMappings = mappings2;
        }

        void appendDependents(ClassFileRepr c, TIntHashSet result) {
            TIntHashSet depClasses = Mappings.this.myClassToClassDependency.get(c.name);
            if (depClasses != null) {
                Mappings.addAll(result, depClasses);
            }
        }

        void propagateMemberAccessRec(TIntHashSet acc, boolean isField, boolean root, MemberComparator comparator, int reflcass) {
            ClassRepr repr = this.classReprByName(reflcass);
            if (repr != null) {
                TIntHashSet subclasses;
                if (!root) {
                    Set<ProtoMember> members = isField ? repr.getFields() : repr.getMethods();
                    for (ProtoMember m : members) {
                        if (!comparator.isSame(m)) continue;
                        return;
                    }
                    if (!acc.add(reflcass)) {
                        return;
                    }
                }
                if ((subclasses = Mappings.this.myClassToSubclasses.get(reflcass)) != null) {
                    subclasses.forEach(subclass -> {
                        this.propagateMemberAccessRec(acc, isField, false, comparator, subclass);
                        return true;
                    });
                }
            }
        }

        TIntHashSet propagateMemberAccess(boolean isField, MemberComparator comparator, int className) {
            TIntHashSet acc = new TIntHashSet(32, 0.98f);
            this.propagateMemberAccessRec(acc, isField, true, comparator, className);
            return acc;
        }

        TIntHashSet propagateFieldAccess(final int name, int className) {
            return this.propagateMemberAccess(true, new MemberComparator(){

                @Override
                public boolean isSame(ProtoMember member) {
                    return member.name == name;
                }
            }, className);
        }

        TIntHashSet propagateMethodAccess(final MethodRepr m, int className) {
            return this.propagateMemberAccess(false, new MemberComparator(){

                @Override
                public boolean isSame(ProtoMember member) {
                    if (member instanceof MethodRepr) {
                        MethodRepr memberMethod = (MethodRepr)member;
                        return memberMethod.name == m.name && Arrays.equals(memberMethod.myArgumentTypes, m.myArgumentTypes);
                    }
                    return false;
                }
            }, className);
        }

        MethodRepr.Predicate lessSpecific(final MethodRepr than) {
            return new MethodRepr.Predicate(){

                @Override
                public boolean satisfy(MethodRepr m) {
                    if (m.name == Mappings.this.myInitName || m.name != than.name || m.myArgumentTypes.length != than.myArgumentTypes.length) {
                        return false;
                    }
                    for (int i = 0; i < than.myArgumentTypes.length; ++i) {
                        Boolean subtypeOf = Util.this.isSubtypeOf(than.myArgumentTypes[i], m.myArgumentTypes[i]);
                        if (subtypeOf == null || subtypeOf.booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        private void addOverridingMethods(MethodRepr m, ClassRepr fromClass, MethodRepr.Predicate predicate, Collection<Pair<MethodRepr, ClassRepr>> container, TIntHashSet visitedClasses) {
            if (m.name == Mappings.this.myInitName) {
                return;
            }
            TIntHashSet subClasses = Mappings.this.myClassToSubclasses.get(fromClass.name);
            if (subClasses == null) {
                return;
            }
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
            }
            if (!visitedClasses.add(fromClass.name)) {
                return;
            }
            TIntHashSet _visitedClasses = visitedClasses;
            subClasses.forEach(subClassName -> {
                ClassRepr r = this.classReprByName(subClassName);
                if (r != null) {
                    boolean cont = true;
                    Collection<MethodRepr> methods = r.findMethods(predicate);
                    for (MethodRepr mm : methods) {
                        if (!Mappings.isVisibleIn(fromClass, m, r)) continue;
                        container.add(Pair.create((Object)mm, (Object)r));
                        cont = false;
                    }
                    if (cont) {
                        this.addOverridingMethods(m, r, predicate, container, _visitedClasses);
                    }
                }
                return true;
            });
        }

        private Collection<Pair<MethodRepr, ClassRepr>> findAllMethodsBySpecificity(MethodRepr m, ClassRepr c) {
            MethodRepr.Predicate predicate = this.lessSpecific(m);
            HashSet<Pair<MethodRepr, ClassRepr>> result = new HashSet<Pair<MethodRepr, ClassRepr>>();
            this.addOverridenMethods(c, predicate, result, null);
            this.addOverridingMethods(m, c, predicate, result, null);
            return result;
        }

        private Collection<Pair<MethodRepr, ClassRepr>> findOverriddenMethods(MethodRepr m, ClassRepr c) {
            if (m.name == Mappings.this.myInitName) {
                return Collections.emptySet();
            }
            HashSet<Pair<MethodRepr, ClassRepr>> result = new HashSet<Pair<MethodRepr, ClassRepr>>();
            this.addOverridenMethods(c, MethodRepr.equalByJavaRules(m), result, null);
            return result;
        }

        private boolean hasOverriddenMethods(ClassRepr fromClass, MethodRepr.Predicate predicate, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int superName : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(superName) || superName == Mappings.this.myObjectClassName || (superClass = this.classReprByName(superName)) == null) continue;
                for (MethodRepr mm : superClass.findMethods(predicate)) {
                    if (!Mappings.isVisibleIn(superClass, mm, fromClass)) continue;
                    return true;
                }
                if (!this.hasOverriddenMethods(superClass, predicate, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private boolean extendsLibraryClass(ClassRepr fromClass, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int superName : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(superName) || superName == Mappings.this.myObjectClassName || (superClass = this.classReprByName(superName)) != null && !this.extendsLibraryClass(superClass, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private void addOverridenMethods(ClassRepr fromClass, MethodRepr.Predicate predicate, Collection<Pair<MethodRepr, ClassRepr>> container, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int superName : fromClass.getSupers()) {
                if (!visitedClasses.add(superName)) continue;
                ClassRepr superClass = this.classReprByName(superName);
                if (superClass != null) {
                    boolean cont = true;
                    Collection<MethodRepr> methods = superClass.findMethods(predicate);
                    for (MethodRepr mm : methods) {
                        if (!Mappings.isVisibleIn(superClass, mm, fromClass)) continue;
                        container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)mm, (Object)superClass));
                        cont = false;
                    }
                    if (!cont) continue;
                    this.addOverridenMethods(superClass, predicate, container, visitedClasses);
                    continue;
                }
                container.add((Pair<MethodRepr, ClassRepr>)Pair.create((Object)MOCK_METHOD, (Object)MOCK_CLASS));
            }
        }

        void addOverriddenFields(FieldRepr f, ClassRepr fromClass, Collection<Pair<FieldRepr, ClassRepr>> container, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int supername : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(supername) || supername == Mappings.this.myObjectClassName || (superClass = this.classReprByName(supername)) == null) continue;
                FieldRepr ff = superClass.findField(f.name);
                if (ff != null && Mappings.isVisibleIn(superClass, ff, fromClass)) {
                    container.add((Pair<FieldRepr, ClassRepr>)Pair.create((Object)ff, (Object)superClass));
                    continue;
                }
                this.addOverriddenFields(f, superClass, container, visitedClasses);
            }
        }

        boolean hasOverriddenFields(FieldRepr f, ClassRepr fromClass, TIntHashSet visitedClasses) {
            if (visitedClasses == null) {
                visitedClasses = new TIntHashSet();
                visitedClasses.add(fromClass.name);
            }
            for (int supername : fromClass.getSupers()) {
                ClassRepr superClass;
                if (!visitedClasses.add(supername) || supername == Mappings.this.myObjectClassName || (superClass = this.classReprByName(supername)) == null) continue;
                FieldRepr ff = superClass.findField(f.name);
                if (ff != null && Mappings.isVisibleIn(superClass, ff, fromClass)) {
                    return true;
                }
                boolean found = this.hasOverriddenFields(f, superClass, visitedClasses);
                if (!found) continue;
                return true;
            }
            return false;
        }

        @Nullable
        ClassRepr classReprByName(int name) {
            ClassFileRepr r = this.reprByName(name);
            return r instanceof ClassRepr ? (ClassRepr)r : null;
        }

        @Nullable
        ModuleRepr moduleReprByName(int name) {
            ClassFileRepr r = this.reprByName(name);
            return r instanceof ModuleRepr ? (ModuleRepr)r : null;
        }

        @Nullable
        ClassFileRepr reprByName(int name) {
            ClassFileRepr r;
            if (this.myMappings != null && (r = this.myMappings.getReprByName(null, name)) != null) {
                return r;
            }
            return Mappings.this.getReprByName(null, name);
        }

        @Nullable
        private Boolean isInheritorOf(int who, int whom, TIntHashSet visitedClasses) {
            if (who == whom) {
                return Boolean.TRUE;
            }
            ClassRepr repr = this.classReprByName(who);
            if (repr != null) {
                if (visitedClasses == null) {
                    visitedClasses = new TIntHashSet();
                    visitedClasses.add(who);
                }
                for (int s : repr.getSupers()) {
                    Boolean inheritorOf;
                    if (!visitedClasses.add(s) || (inheritorOf = this.isInheritorOf(s, whom, visitedClasses)) == null || !inheritorOf.booleanValue()) continue;
                    return inheritorOf;
                }
            }
            return null;
        }

        @Nullable
        Boolean isSubtypeOf(TypeRepr.AbstractType who, TypeRepr.AbstractType whom) {
            if (who.equals(whom)) {
                return Boolean.TRUE;
            }
            if (who instanceof TypeRepr.PrimitiveType || whom instanceof TypeRepr.PrimitiveType) {
                return Boolean.FALSE;
            }
            if (who instanceof TypeRepr.ArrayType) {
                if (whom instanceof TypeRepr.ArrayType) {
                    return this.isSubtypeOf(((TypeRepr.ArrayType)who).elementType, ((TypeRepr.ArrayType)whom).elementType);
                }
                String descr = whom.getDescr(Mappings.this.myContext);
                if (descr.equals("Ljava/lang/Cloneable") || descr.equals("Ljava/lang/Object") || descr.equals("Ljava/io/Serializable")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (whom instanceof TypeRepr.ClassType) {
                return this.isInheritorOf(((TypeRepr.ClassType)who).className, ((TypeRepr.ClassType)whom).className, null);
            }
            return Boolean.FALSE;
        }

        boolean isMethodVisible(ClassRepr classRepr, MethodRepr m) {
            return classRepr.findMethods(MethodRepr.equalByJavaRules(m)).size() > 0 || this.hasOverriddenMethods(classRepr, MethodRepr.equalByJavaRules(m), null);
        }

        boolean isFieldVisible(int className, FieldRepr field) {
            ClassRepr r = this.classReprByName(className);
            if (r == null || r.getFields().contains(field)) {
                return true;
            }
            return this.hasOverriddenFields(field, r, null);
        }

        void collectSupersRecursively(int className, @NotNull TIntHashSet container) {
            int[] supers;
            ClassRepr classRepr;
            if (container == null) {
                Util.$$$reportNull$$$0(1);
            }
            if ((classRepr = this.classReprByName(className)) != null && container.addAll(supers = classRepr.getSupers())) {
                for (int aSuper : supers) {
                    this.collectSupersRecursively(aSuper, container);
                }
            }
        }

        void affectSubclasses(int className, Collection<File> affectedFiles, Collection<UsageRepr.Usage> affectedUsages, TIntHashSet dependants, boolean usages, Collection<File> alreadyCompiledFiles, TIntHashSet visitedClasses) {
            TIntHashSet directSubclasses;
            TIntHashSet depClasses;
            Mappings.this.debug("Affecting subclasses of class: ", className);
            Collection allSources = Mappings.this.myClassToSourceFile.get(className);
            if (allSources == null || allSources.isEmpty()) {
                Mappings.this.debug("No source file detected for class ", className);
                Mappings.debug("End of affectSubclasses");
                return;
            }
            for (File fName : allSources) {
                Mappings.this.debug("Source file name: ", fName);
                if (alreadyCompiledFiles.contains(fName)) continue;
                affectedFiles.add(fName);
            }
            if (usages) {
                Mappings.debug("Class usages affection requested");
                ClassRepr classRepr = this.classReprByName(className);
                if (classRepr != null) {
                    Mappings.this.debug("Added class usage for ", classRepr.name);
                    affectedUsages.add(classRepr.createUsage());
                }
            }
            if ((depClasses = Mappings.this.myClassToClassDependency.get(className)) != null) {
                Mappings.addAll(dependants, depClasses);
            }
            if ((directSubclasses = Mappings.this.myClassToSubclasses.get(className)) != null) {
                if (visitedClasses == null) {
                    visitedClasses = new TIntHashSet();
                    visitedClasses.add(className);
                }
                TIntHashSet _visitedClasses = visitedClasses;
                directSubclasses.forEach(subClass -> {
                    if (_visitedClasses.add(subClass)) {
                        this.affectSubclasses(subClass, affectedFiles, affectedUsages, dependants, usages, alreadyCompiledFiles, _visitedClasses);
                    }
                    return true;
                });
            }
        }

        void affectFieldUsages(FieldRepr field, TIntHashSet classes, UsageRepr.Usage rootUsage, Set<UsageRepr.Usage> affectedUsages, TIntHashSet dependents) {
            affectedUsages.add(rootUsage);
            classes.forEach(p -> {
                TIntHashSet deps = Mappings.this.myClassToClassDependency.get(p);
                if (deps != null) {
                    Mappings.addAll(dependents, deps);
                }
                Mappings.this.debug("Affect field usage referenced of class ", p);
                affectedUsages.add(rootUsage instanceof UsageRepr.FieldAssignUsage ? field.createAssignUsage(Mappings.this.myContext, p) : field.createUsage(Mappings.this.myContext, p));
                return true;
            });
        }

        void affectMethodUsages(MethodRepr method, TIntHashSet subclasses, UsageRepr.Usage rootUsage, Set<UsageRepr.Usage> affectedUsages, TIntHashSet dependents) {
            affectedUsages.add(rootUsage);
            if (subclasses != null) {
                subclasses.forEach(p -> {
                    TIntHashSet deps = Mappings.this.myClassToClassDependency.get(p);
                    if (deps != null) {
                        Mappings.addAll(dependents, deps);
                    }
                    Mappings.this.debug("Affect method usage referenced of class ", p);
                    UsageRepr.Usage usage = rootUsage instanceof UsageRepr.MetaMethodUsage ? method.createMetaUsage(Mappings.this.myContext, p) : method.createUsage(Mappings.this.myContext, p);
                    affectedUsages.add(usage);
                    return true;
                });
            }
        }

        void affectModule(ModuleRepr m, Collection<File> affectedFiles) {
            Collection depFiles;
            Collection collection = depFiles = this.myMappings != null ? this.myMappings.myClassToSourceFile.get(m.name) : null;
            if (depFiles == null) {
                depFiles = Mappings.this.myClassToSourceFile.get(m.name);
            }
            if (depFiles != null) {
                Mappings.this.debug("Affecting module ", m.name);
                affectedFiles.addAll(depFiles);
            }
        }

        void affectDependentModules(final Differential.DiffState state, int moduleName, final @Nullable UsageConstraint constraint, final boolean checkTransitive) {
            new Object(){
                final TIntHashSet visited = new TIntHashSet();

                void perform(int modName) {
                    TIntHashSet depNames = Mappings.this.myClassToClassDependency.get(modName);
                    if (depNames != null && !depNames.isEmpty()) {
                        TIntHashSet next = new TIntHashSet();
                        UsageRepr.Usage moduleUsage = UsageRepr.createModuleUsage(Mappings.this.myContext, modName);
                        state.myAffectedUsages.add(moduleUsage);
                        UsageConstraint prevConstraint = state.myUsageConstraints.put(moduleUsage, constraint == null ? UsageConstraint.ANY : constraint);
                        if (prevConstraint != null) {
                            state.myUsageConstraints.put(moduleUsage, prevConstraint.or(constraint));
                        }
                        depNames.forEach(depName -> {
                            ClassFileRepr depRepr;
                            if (this.visited.add(depName) && (depRepr = Util.this.reprByName(depName)) instanceof ModuleRepr) {
                                state2.myDependants.add(depName);
                                if (checkTransitive && ((ModuleRepr)depRepr).requiresTransitevely(modName)) {
                                    next.add(depName);
                                }
                            }
                            return true;
                        });
                        next.forEach(m -> {
                            this.perform(m);
                            return true;
                        });
                    }
                }
            }.perform(moduleName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectSupersRecursively";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public class InheritanceConstraint
        extends PackageConstraint {
            public final int rootClass;

            public InheritanceConstraint(ClassRepr rootClass) {
                super(rootClass.getPackageName());
                this.rootClass = rootClass.name;
            }

            public InheritanceConstraint(int rootClass) {
                super(ClassRepr.getPackageName(Mappings.this.myContext.getValue(rootClass)));
                this.rootClass = rootClass;
            }

            @Override
            public boolean checkResidence(int residence) {
                Boolean inheritorOf = Util.this.isInheritorOf(residence, this.rootClass, null);
                return (inheritorOf == null || inheritorOf == false) && super.checkResidence(residence);
            }
        }

        public class PackageConstraint
        implements UsageConstraint {
            public final String packageName;

            public PackageConstraint(String packageName) {
                this.packageName = packageName;
            }

            @Override
            public boolean checkResidence(int residence) {
                return !ClassRepr.getPackageName(Mappings.this.myContext.getValue(residence)).equals(this.packageName);
            }
        }

        public class FileFilterConstraint
        implements UsageConstraint {
            @NotNull
            private final DependentFilesFilter myFilter;

            public FileFilterConstraint(DependentFilesFilter filter) {
                if (filter == null) {
                    FileFilterConstraint.$$$reportNull$$$0(0);
                }
                this.myFilter = filter;
            }

            @Override
            public boolean checkResidence(int residence) {
                Collection fNames = Mappings.this.myClassToSourceFile.get(residence);
                if (fNames == null || fNames.isEmpty()) {
                    return true;
                }
                for (File fName : fNames) {
                    if (!this.myFilter.accept(fName)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/builders/java/dependencyView/Mappings$Util$FileFilterConstraint", "<init>"));
            }
        }
    }

    private static interface MemberComparator {
        public boolean isSame(ProtoMember var1);
    }
}

