/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import com.intellij.util.Consumer;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaCompiler;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.ast.JavacTreeRefScanner;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacFileData;
import org.jetbrains.jps.javac.ast.api.JavacNameTable;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

final class JavacReferenceCollectorListener
implements TaskListener {
    private static final TObjectIntHashMap<JavacRef> EMPTY_T_OBJ_INT_MAP = new TObjectIntHashMap(0);
    private final boolean myDivideImportRefs;
    private final Consumer<? super JavacFileData> myDataConsumer;
    private final JavacTask myJavacTask;
    private final JavacTreeRefScanner myAstScanner;
    private final boolean myAtLeastJdk8;
    private boolean myInitialized;
    private Elements myElementUtility;
    private Types myTypeUtility;
    private Trees myTreeUtility;
    private JavacNameTable myNameTableCache;
    private final Map<String, ReferenceCollector> myIncompletelyProcessedFiles = new HashMap<String, ReferenceCollector>(10);

    static void installOn(JavaCompiler.CompilationTask task, boolean divideImportRefs, Consumer<? super JavacFileData> dataConsumer) {
        Method addTaskMethod;
        JavacTask javacTask = (JavacTask)task;
        try {
            addTaskMethod = JavacTask.class.getMethod("addTaskListener", TaskListener.class);
        }
        catch (NoSuchMethodException e) {
            addTaskMethod = null;
        }
        JavacReferenceCollectorListener taskListener = new JavacReferenceCollectorListener(divideImportRefs, dataConsumer, javacTask, addTaskMethod != null);
        if (addTaskMethod != null) {
            try {
                addTaskMethod.setAccessible(true);
                addTaskMethod.invoke((Object)task, taskListener);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            javacTask.setTaskListener(taskListener);
        }
    }

    private JavacReferenceCollectorListener(boolean divideImportRefs, Consumer<? super JavacFileData> dataConsumer, JavacTask javacTask, boolean atLeastJdk8) {
        this.myDivideImportRefs = divideImportRefs;
        this.myDataConsumer = dataConsumer;
        this.myJavacTask = javacTask;
        this.myAtLeastJdk8 = atLeastJdk8;
        this.myAstScanner = JavacTreeRefScanner.createASTScanner();
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        this.initializeUtilitiesIfNeeded();
        if (e.getKind() == TaskEvent.Kind.ANALYZE) {
            boolean isFileDataComplete;
            boolean collectImportsData;
            CompilationUnitTree unit = e.getCompilationUnit();
            String fileName = new File(e.getSourceFile().toUri().getPath()).getPath();
            ClassTree declarationToProcess = this.myTreeUtility.getTree(e.getTypeElement());
            boolean addedToCache = true;
            ReferenceCollector incompletelyProcessedFile = this.myIncompletelyProcessedFiles.get(fileName);
            if (incompletelyProcessedFile == null) {
                int declarationCount = unit.getTypeDecls().size();
                incompletelyProcessedFile = new ReferenceCollector(declarationCount, fileName, unit);
                if (declarationCount == 1 && declarationToProcess != null) {
                    addedToCache = false;
                } else {
                    this.myIncompletelyProcessedFiles.put(fileName, incompletelyProcessedFile);
                }
                collectImportsData = true;
            } else {
                collectImportsData = false;
            }
            if (incompletelyProcessedFile.decrementRemainDeclarationsAndGet(declarationToProcess) == 0) {
                if (addedToCache) {
                    this.myIncompletelyProcessedFiles.remove(fileName);
                }
                isFileDataComplete = true;
            } else {
                isFileDataComplete = false;
            }
            if (collectImportsData) {
                this.scanImports(unit, incompletelyProcessedFile.myFileData.getRefs(), incompletelyProcessedFile);
                if (this.myDivideImportRefs) {
                    this.scanImports(unit, incompletelyProcessedFile.myFileData.getImportRefs(), incompletelyProcessedFile);
                }
            }
            this.myAstScanner.scan(declarationToProcess, incompletelyProcessedFile);
            if (isFileDataComplete) {
                for (AnnotationTree annotationTree : unit.getPackageAnnotations()) {
                    this.myAstScanner.scan(annotationTree, incompletelyProcessedFile);
                }
                this.myDataConsumer.consume((Object)incompletelyProcessedFile.myFileData);
            }
        }
    }

    private void initializeUtilitiesIfNeeded() {
        if (!this.myInitialized) {
            this.myElementUtility = this.myJavacTask.getElements();
            this.myTypeUtility = this.myJavacTask.getTypes();
            this.myTreeUtility = Trees.instance(this.myJavacTask);
            this.myNameTableCache = new JavacNameTable(this.myElementUtility);
            this.myInitialized = true;
        }
    }

    private void scanImports(CompilationUnitTree compilationUnit, TObjectIntHashMap<JavacRef> elements, ReferenceCollector incompletelyProcessedFile) {
        for (ImportTree importTree : compilationUnit.getImports()) {
            MemberSelectTree id = (MemberSelectTree)importTree.getQualifiedIdentifier();
            Element element = incompletelyProcessedFile.getReferencedElement(id);
            if (element == null) {
                ExpressionTree qExpr = id.getExpression();
                if (!(qExpr instanceof MemberSelectTree)) continue;
                MemberSelectTree classImport = (MemberSelectTree)qExpr;
                Element ownerElement = incompletelyProcessedFile.getReferencedElement(classImport);
                Name name = id.getIdentifier();
                if (!this.myNameTableCache.isAsterisk(name)) {
                    for (Element element2 : this.myElementUtility.getAllMembers((TypeElement)ownerElement)) {
                        if (element2.getSimpleName() != name) continue;
                        JavacReferenceCollectorListener.incrementOrAdd(elements, JavacRef.JavacElementRefBase.fromElement(element2, null, this.myNameTableCache));
                    }
                }
                this.collectClassImports(ownerElement, elements);
                continue;
            }
            this.collectClassImports(element, elements);
        }
    }

    private void collectClassImports(Element baseImport, TObjectIntHashMap<JavacRef> collector) {
        for (Element element = baseImport; element != null && element.getKind() != ElementKind.PACKAGE; element = element.getEnclosingElement()) {
            JavacReferenceCollectorListener.incrementOrAdd(collector, JavacRef.JavacElementRefBase.fromElement(element, null, this.myNameTableCache));
        }
    }

    private static TObjectIntHashMap<JavacRef> createReferenceHolder() {
        return new TObjectIntHashMap();
    }

    private static List<JavacDef> createDefinitionHolder() {
        return new ArrayList<JavacDef>();
    }

    private static void incrementOrAdd(TObjectIntHashMap<JavacRef> map, JavacRef key) {
        if (!map.adjustValue((Object)key, 1)) {
            map.put((Object)key, 1);
        }
    }

    private static Element getElementIfJdkUnder8(Tree tree) {
        Field symField;
        if (tree == null || tree instanceof PrimitiveTypeTree || tree instanceof ArrayTypeTree) {
            return null;
        }
        if (tree instanceof ParameterizedTypeTree) {
            return JavacReferenceCollectorListener.getElementIfJdkUnder8(((ParameterizedTypeTree)tree).getType());
        }
        try {
            symField = tree.getClass().getField(tree instanceof NewClassTree ? "constructor" : "sym");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(tree.getClass().getName());
        }
        try {
            return (Element)symField.get(tree);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private class JavacTreeHelper {
        private final TreePath myUnitPath;
        private final Trees myTreeUtil;
        private final SourcePositions myPositions;

        private JavacTreeHelper(CompilationUnitTree unit, Trees treeUtil) {
            this.myUnitPath = new TreePath(unit);
            this.myTreeUtil = treeUtil;
            this.myPositions = treeUtil.getSourcePositions();
        }

        private long getStartOffset(Tree tree) {
            return this.myPositions.getStartPosition(this.myUnitPath.getCompilationUnit(), tree);
        }

        private long getEndOffset(Tree tree) {
            return this.myPositions.getEndPosition(this.myUnitPath.getCompilationUnit(), tree);
        }

        private Element getReferencedElement(Tree tree) {
            TreePath path = new TreePath(this.myUnitPath, tree);
            if (JavacReferenceCollectorListener.this.myAtLeastJdk8) {
                return this.myTreeUtil.getElement(path);
            }
            return JavacReferenceCollectorListener.getElementIfJdkUnder8(tree);
        }

        private TypeMirror getType(Tree tree) {
            return this.myTreeUtil.getTypeMirror(new TreePath(this.myUnitPath, tree));
        }
    }

    class ReferenceCollector {
        private final JavacFileData myFileData;
        private final JavacTreeHelper myTreeHelper;
        private int myRemainDeclarations;

        private ReferenceCollector(int remainDeclarations, String filePath, CompilationUnitTree unitTree) {
            this.myRemainDeclarations = remainDeclarations;
            this.myFileData = new JavacFileData(filePath, (TObjectIntHashMap<JavacRef>)JavacReferenceCollectorListener.createReferenceHolder(), (TObjectIntHashMap<JavacRef>)(JavacReferenceCollectorListener.this.myDivideImportRefs ? JavacReferenceCollectorListener.createReferenceHolder() : EMPTY_T_OBJ_INT_MAP), new ArrayList<JavacTypeCast>(), JavacReferenceCollectorListener.createDefinitionHolder(), (Set<JavacRef>)new THashSet());
            this.myTreeHelper = new JavacTreeHelper(unitTree, JavacReferenceCollectorListener.this.myTreeUtility);
        }

        void sinkReference(@Nullable JavacRef.JavacElementRefBase ref) {
            JavacReferenceCollectorListener.incrementOrAdd((TObjectIntHashMap<JavacRef>)this.myFileData.getRefs(), ref);
        }

        void sinkDeclaration(JavacDef def) {
            this.myFileData.getDefs().add(def);
        }

        void sinkImplicitToString(@Nullable JavacRef ref) {
            if (ref != null) {
                this.myFileData.getImplicitToStringRefs().add(ref);
            }
        }

        public void sinkTypeCast(JavacTypeCast typeCast) {
            this.myFileData.getCasts().add(typeCast);
        }

        @Nullable
        JavacRef.JavacElementRefBase asJavacRef(Element element) {
            return this.asJavacRef(element, null);
        }

        @Nullable
        JavacRef.JavacElementRefBase asJavacRef(Element element, Element qualifier) {
            return JavacRef.JavacElementRefBase.fromElement(element, qualifier, JavacReferenceCollectorListener.this.myNameTableCache);
        }

        @Nullable
        JavacRef.JavacElementRefBase asJavacRef(TypeMirror typeMirror) {
            Element element = this.getTypeUtility().asElement(typeMirror);
            return element == null ? null : JavacRef.JavacElementRefBase.fromElement(element, null, JavacReferenceCollectorListener.this.myNameTableCache);
        }

        Element getReferencedElement(Tree tree) {
            return this.myTreeHelper.getReferencedElement(tree);
        }

        TypeMirror getType(Tree tree) {
            return this.myTreeHelper.getType(tree);
        }

        Types getTypeUtility() {
            return JavacReferenceCollectorListener.this.myTypeUtility;
        }

        JavacNameTable getNameTable() {
            return JavacReferenceCollectorListener.this.myNameTableCache;
        }

        long getStartOffset(Tree tree) {
            return this.myTreeHelper.getStartOffset(tree);
        }

        long getEndOffset(Tree tree) {
            return this.myTreeHelper.getEndOffset(tree);
        }

        private int decrementRemainDeclarationsAndGet(Tree declarationToProcess) {
            return declarationToProcess == null ? this.myRemainDeclarations : (this.myRemainDeclarations = this.myRemainDeclarations - 1);
        }
    }
}

