/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.ast.api.JavacNameTable;

public interface JavacRef {
    public static final JavacRef[] EMPTY_ARRAY = new JavacRef[0];

    @NotNull
    public String getName();

    public Set<Modifier> getModifiers();

    @NotNull
    public String getOwnerName();

    public static class JavacElementFieldImpl
    extends JavacElementRefBase
    implements JavacField {
        public JavacElementFieldImpl(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache) {
            if (element == null) {
                JavacElementFieldImpl.$$$reportNull$$$0(0);
            }
            super(element, qualifier, nameTableCache);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementFieldImpl", "<init>"));
        }
    }

    public static class JavacElementMethodImpl
    extends JavacElementRefBase
    implements JavacMethod {
        public JavacElementMethodImpl(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache) {
            if (element == null) {
                JavacElementMethodImpl.$$$reportNull$$$0(0);
            }
            super(element, qualifier, nameTableCache);
        }

        @Override
        public byte getParamCount() {
            return (byte)((ExecutableElement)this.myOriginalElement).getParameters().size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementMethodImpl", "<init>"));
        }
    }

    public static class JavacElementClassImpl
    extends JavacElementRefBase
    implements JavacClass {
        public JavacElementClassImpl(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache) {
            if (element == null) {
                JavacElementClassImpl.$$$reportNull$$$0(0);
            }
            super(element, qualifier, nameTableCache);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myNameTableCache.parseBinaryName(this.myOriginalElement);
            if (string == null) {
                JavacElementClassImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isAnonymous() {
            return this.myNameTableCache.parseName(this.myOriginalElement.getSimpleName()).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementClassImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementClassImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class JavacElementRefBase
    implements JavacRef {
        @NotNull
        protected final Element myOriginalElement;
        @Nullable
        private final Element myQualifier;
        protected final JavacNameTable myNameTableCache;

        protected JavacElementRefBase(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache) {
            if (element == null) {
                JavacElementRefBase.$$$reportNull$$$0(0);
            }
            this.myOriginalElement = element;
            this.myQualifier = qualifier;
            this.myNameTableCache = nameTableCache;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myNameTableCache.parseName(this.myOriginalElement.getSimpleName());
            if (string == null) {
                JavacElementRefBase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.myOriginalElement.getModifiers();
        }

        @Override
        @NotNull
        public String getOwnerName() {
            String string = this.myNameTableCache.parseBinaryName(this.myQualifier != null ? this.myQualifier : this.myOriginalElement.getEnclosingElement());
            if (string == null) {
                JavacElementRefBase.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public static JavacElementRefBase fromElement(Element element, Element qualifier, JavacNameTable nameTableCache) {
            TypeMirror type;
            if (qualifier != null && !JavacElementRefBase.isValidType(type = qualifier.asType())) {
                return null;
            }
            if (element instanceof TypeElement) {
                return new JavacElementClassImpl(element, qualifier, nameTableCache);
            }
            if (element instanceof VariableElement) {
                if (qualifier == null && !JavacElementRefBase.checkEnclosingElement(element)) {
                    return null;
                }
                return new JavacElementFieldImpl(element, qualifier, nameTableCache);
            }
            if (element instanceof ExecutableElement) {
                if (qualifier == null && !JavacElementRefBase.checkEnclosingElement(element)) {
                    return null;
                }
                return new JavacElementMethodImpl(element, qualifier, nameTableCache);
            }
            if (element == null || element.getKind() == ElementKind.OTHER || element.getKind() == ElementKind.TYPE_PARAMETER) {
                return null;
            }
            throw new AssertionError((Object)("unexpected element: " + element + " class: " + element.getClass()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavacElementRefBase base = (JavacElementRefBase)o;
            return this.myOriginalElement == base.myOriginalElement && this.myQualifier == base.myQualifier;
        }

        public int hashCode() {
            int hashCode = this.myOriginalElement.hashCode();
            if (this.myQualifier != null) {
                hashCode += this.myQualifier.hashCode();
            }
            return hashCode;
        }

        private static boolean checkEnclosingElement(Element element) {
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement == null) {
                return false;
            }
            TypeMirror type = enclosingElement.asType();
            return JavacElementRefBase.isValidType(type);
        }

        private static boolean isValidType(TypeMirror type) {
            return type != null && type.getKind() != TypeKind.NONE && type.getKind() != TypeKind.OTHER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementRefBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javac/ast/api/JavacRef$JavacElementRefBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class JavacFieldImpl
    extends JavacRefBase
    implements JavacField {
        private final String myOwnerName;

        public JavacFieldImpl(String ownerName, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myOwnerName = ownerName;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            String string = this.myOwnerName;
            if (string == null) {
                JavacFieldImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacFieldImpl", "getOwnerName"));
        }
    }

    public static class JavacMethodImpl
    extends JavacRefBase
    implements JavacMethod {
        private final String myOwnerName;
        private final byte myParamCount;

        public JavacMethodImpl(String ownerName, byte paramCount, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myOwnerName = ownerName;
            this.myParamCount = paramCount;
        }

        @Override
        public byte getParamCount() {
            return this.myParamCount;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            String string = this.myOwnerName;
            if (string == null) {
                JavacMethodImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacMethodImpl", "getOwnerName"));
        }
    }

    public static class JavacClassImpl
    extends JavacRefBase
    implements JavacClass {
        private final boolean myAnonymous;

        public JavacClassImpl(boolean anonymous, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myAnonymous = anonymous;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnonymous() {
            return this.myAnonymous;
        }
    }

    public static abstract class JavacRefBase
    implements JavacRef {
        private final String myName;
        private final Set<Modifier> myModifiers;

        protected JavacRefBase(String name, Set<Modifier> modifiers) {
            this.myName = name;
            this.myModifiers = modifiers;
        }

        @Override
        @NotNull
        public final String getName() {
            String string = this.myName;
            if (string == null) {
                JavacRefBase.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public final Set<Modifier> getModifiers() {
            return this.myModifiers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacRef$JavacRefBase", "getName"));
        }
    }

    public static interface JavacField
    extends JavacRef {
    }

    public static interface JavacMethod
    extends JavacRef {
        public byte getParamCount();
    }

    public static interface JavacClass
    extends JavacRef {
        public boolean isAnonymous();
    }
}

