/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class JavaFxApplicationIcons {
    private String myLinuxIcon;
    private String myMacIcon;
    private String myWindowsIcon;

    public String getLinuxIcon() {
        return this.myLinuxIcon;
    }

    public String getLinuxIcon(String relativeToPath) {
        return JavaFxApplicationIcons.getRelativeIcon(relativeToPath, this.myLinuxIcon);
    }

    public void setLinuxIcon(String linuxIcon) {
        this.myLinuxIcon = linuxIcon;
    }

    public String getMacIcon() {
        return this.myMacIcon;
    }

    public String getMacIcon(String relativeToPath) {
        return JavaFxApplicationIcons.getRelativeIcon(relativeToPath, this.myMacIcon);
    }

    public void setMacIcon(String macIcon) {
        this.myMacIcon = macIcon;
    }

    public String getWindowsIcon() {
        return this.myWindowsIcon;
    }

    public String getWindowsIcon(String relativeToPath) {
        return JavaFxApplicationIcons.getRelativeIcon(relativeToPath, this.myWindowsIcon);
    }

    public void setWindowsIcon(String windowsIcon) {
        this.myWindowsIcon = windowsIcon;
    }

    public boolean isEmpty() {
        return StringUtil.isEmpty((String)this.myLinuxIcon) && StringUtil.isEmpty((String)this.myMacIcon) && StringUtil.isEmpty((String)this.myWindowsIcon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaFxApplicationIcons icons = (JavaFxApplicationIcons)o;
        if (this.myLinuxIcon != null ? !this.myLinuxIcon.equals(icons.myLinuxIcon) : icons.myLinuxIcon != null) {
            return false;
        }
        if (this.myMacIcon != null ? !this.myMacIcon.equals(icons.myMacIcon) : icons.myMacIcon != null) {
            return false;
        }
        return !(this.myWindowsIcon != null ? !this.myWindowsIcon.equals(icons.myWindowsIcon) : icons.myWindowsIcon != null);
    }

    public int hashCode() {
        int result = this.myLinuxIcon != null ? this.myLinuxIcon.hashCode() : 0;
        result = 31 * result + (this.myMacIcon != null ? this.myMacIcon.hashCode() : 0);
        result = 31 * result + (this.myWindowsIcon != null ? this.myWindowsIcon.hashCode() : 0);
        return result;
    }

    @Nullable
    private static String getRelativeIcon(String relativeToPath, String icon) {
        if (!StringUtil.isEmpty((String)icon) && !StringUtil.isEmpty((String)relativeToPath)) {
            return FileUtil.getRelativePath((String)relativeToPath, (String)icon, (char)'/');
        }
        return icon;
    }
}

