/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.source;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.DragSourceShadow;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.klass.ComponentClassMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ImagePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignImage;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.stage.Window;

public class ExternalDragSource
extends AbstractDragSource {
    private final Dragboard dragboard;
    private final FXOMDocument targetDocument;
    private List<FXOMObject> draggedObjects;
    private List<File> inputFiles;
    private boolean nodeOnly;
    private boolean singleImageViewOnly;
    private boolean singleTooltipOnly;
    private boolean singleContextMenuOnly;
    private int errorCount;
    private Exception lastException;
    static final PropertyName imageName = new PropertyName("image");
    static final PropertyName fitWidthName = new PropertyName("fitWidth");
    static final PropertyName fitHeightName = new PropertyName("fitHeight");

    public ExternalDragSource(Dragboard clipboardContent, FXOMDocument targetDocument, Window ownerWindow) {
        super(ownerWindow);
        assert (clipboardContent != null);
        assert (targetDocument != null);
        this.dragboard = clipboardContent;
        this.targetDocument = targetDocument;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public boolean isAcceptable() {
        return true;
    }

    @Override
    public List<FXOMObject> getDraggedObjects() {
        if (this.draggedObjects == null) {
            this.draggedObjects = new ArrayList<FXOMObject>();
            this.inputFiles = new ArrayList<File>();
            for (File file : this.dragboard.getFiles()) {
                try {
                    FXOMObject newObject = FXOMNodes.newObject(this.targetDocument, file);
                    if (newObject == null) continue;
                    this.draggedObjects.add(newObject);
                    this.inputFiles.add(file);
                }
                catch (IOException x) {
                    ++this.errorCount;
                    this.lastException = x;
                }
            }
            Group group = new Group();
            double dxy = 0.0;
            for (FXOMObject o : this.draggedObjects) {
                if (!(o.getSceneGraphObject() instanceof Node)) continue;
                Node sceneGraphNode = (Node)o.getSceneGraphObject();
                sceneGraphNode.setLayoutX(dxy);
                sceneGraphNode.setLayoutY(dxy);
                dxy += 20.0;
                group.getChildren().add((Object)sceneGraphNode);
            }
            Scene scene = new Scene((Parent)group);
            scene.getClass();
            group.applyCss();
            group.layout();
            if (this.draggedObjects.size() != 1) {
                this.singleImageViewOnly = false;
                this.singleTooltipOnly = false;
                this.singleContextMenuOnly = false;
            } else {
                FXOMObject draggedObject = this.getDraggedObjects().get(0);
                if (draggedObject instanceof FXOMInstance) {
                    Object sceneGraphObject = draggedObject.getSceneGraphObject();
                    this.singleImageViewOnly = sceneGraphObject instanceof ImageView;
                    this.singleTooltipOnly = sceneGraphObject instanceof Tooltip;
                    this.singleContextMenuOnly = sceneGraphObject instanceof ContextMenu;
                } else {
                    this.singleImageViewOnly = false;
                    this.singleTooltipOnly = false;
                    this.singleContextMenuOnly = false;
                }
            }
        }
        return this.draggedObjects;
    }

    @Override
    public FXOMObject getHitObject() {
        FXOMObject result = this.getDraggedObjects().isEmpty() ? null : this.getDraggedObjects().get(0);
        return result;
    }

    @Override
    public double getHitX() {
        double result;
        FXOMObject hitObject = this.getHitObject();
        if (hitObject == null) {
            result = Double.NaN;
        } else if (hitObject.isNode()) {
            Node hitNode = (Node)hitObject.getSceneGraphObject();
            Bounds b = hitNode.getLayoutBounds();
            result = (b.getMinX() + b.getMaxX()) / 2.0;
        } else {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getHitY() {
        double result;
        FXOMObject hitObject = this.getHitObject();
        if (hitObject == null) {
            result = Double.NaN;
        } else if (hitObject.isNode()) {
            Node hitNode = (Node)hitObject.getSceneGraphObject();
            Bounds b = hitNode.getLayoutBounds();
            result = (b.getMinY() + b.getMaxY()) / 2.0;
        } else {
            result = 0.0;
        }
        return result;
    }

    @Override
    public ClipboardContent makeClipboardContent() {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public Image makeDragView() {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public Node makeShadow() {
        Group result = new Group();
        result.getStylesheets().add((Object)EditorController.getStylesheet().toString());
        for (FXOMObject draggedObject : this.getDraggedObjects()) {
            if (!(draggedObject.getSceneGraphObject() instanceof Node)) continue;
            Node sceneGraphNode = (Node)draggedObject.getSceneGraphObject();
            DragSourceShadow shadowNode = new DragSourceShadow();
            shadowNode.setupForNode(sceneGraphNode);
            shadowNode.getTransforms().add((Object)sceneGraphNode.getLocalToSceneTransform());
            result.getChildren().add((Object)shadowNode);
        }
        Bounds b = result.getBoundsInParent();
        double centerX = (b.getMinX() + b.getMaxX()) / 2.0;
        double centerY = (b.getMinY() + b.getMaxY()) / 2.0;
        result.setTranslateX(-centerX);
        result.setTranslateY(-centerY);
        return result;
    }

    @Override
    public String makeDropJobDescription() {
        String result;
        if (this.inputFiles.size() == 1) {
            Path inputPath = Paths.get(this.inputFiles.get(0).toURI());
            result = I18N.getString("drop.job.insert.from.single.file", inputPath.getFileName());
        } else {
            result = I18N.getString("drop.job.insert.from.multiple.files", this.inputFiles.size());
        }
        return result;
    }

    @Override
    public boolean isNodeOnly() {
        if (this.draggedObjects == null) {
            int nonNodeCount = 0;
            for (FXOMObject draggedObject : this.getDraggedObjects()) {
                if (draggedObject.isNode()) continue;
                ++nonNodeCount;
            }
            this.nodeOnly = nonNodeCount == 0;
        }
        return this.nodeOnly;
    }

    @Override
    public boolean isSingleImageViewOnly() {
        this.getDraggedObjects();
        return this.singleImageViewOnly;
    }

    @Override
    public boolean isSingleTooltipOnly() {
        this.getDraggedObjects();
        return this.singleTooltipOnly;
    }

    @Override
    public boolean isSingleContextMenuOnly() {
        this.getDraggedObjects();
        return this.singleContextMenuOnly;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": dragboard=(" + this.dragboard + ")";
    }

    static FXOMDocument makeFxomDocumentFromImageURL(Image image, double fitSize) throws IOException {
        double fitHeight;
        double fitWidth;
        double imageHeight;
        assert (image != null);
        assert (fitSize > 0.0);
        double imageWidth = image.getWidth();
        double imageSize = Math.max(imageWidth, imageHeight = image.getHeight());
        if (imageSize < fitSize) {
            fitWidth = 0.0;
            fitHeight = 0.0;
        } else {
            double widthScale = fitSize / imageSize;
            double heightScale = fitSize / imageHeight;
            double scale = Math.min(widthScale, heightScale);
            fitWidth = Math.floor(imageWidth * scale);
            fitHeight = Math.floor(imageHeight * scale);
        }
        return ExternalDragSource.makeFxomDocumentFromImageURL(image, fitWidth, fitHeight);
    }

    static FXOMDocument makeFxomDocumentFromImageURL(Image image, double fitWidth, double fitHeight) {
        FXOMDocument result = new FXOMDocument();
        FXOMInstance imageView = new FXOMInstance(result, ImageView.class);
        ComponentClassMetadata imageViewMeta = Metadata.getMetadata().queryComponentMetadata(ImageView.class);
        PropertyMetadata imagePropMeta = imageViewMeta.lookupProperty(imageName);
        PropertyMetadata fitWidthPropMeta = imageViewMeta.lookupProperty(fitWidthName);
        PropertyMetadata fitHeightPropMeta = imageViewMeta.lookupProperty(fitHeightName);
        assert (imagePropMeta instanceof ImagePropertyMetadata);
        assert (fitWidthPropMeta instanceof DoublePropertyMetadata);
        assert (fitHeightPropMeta instanceof DoublePropertyMetadata);
        ImagePropertyMetadata imageMeta = (ImagePropertyMetadata)imagePropMeta;
        DoublePropertyMetadata fitWidthMeta = (DoublePropertyMetadata)fitWidthPropMeta;
        DoublePropertyMetadata fitHeightMeta = (DoublePropertyMetadata)fitHeightPropMeta;
        imageMeta.setValue(imageView, new DesignImage(image));
        fitWidthMeta.setValue(imageView, fitWidth);
        fitHeightMeta.setValue(imageView, fitHeight);
        result.setFxomRoot(imageView);
        return result;
    }
}

