/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;

public class ReplacePropertyValueJobT
extends Job {
    private final FXOMPropertyT hostProperty;
    private final FXOMObject newValue;
    private FXOMInstance hostInstance;
    private FXOMPropertyC newProperty;

    public ReplacePropertyValueJobT(FXOMPropertyT hostProperty, FXOMObject newValue, EditorController editorController) {
        super(editorController);
        assert (hostProperty != null);
        assert (newValue != null);
        this.hostProperty = hostProperty;
        this.newValue = newValue;
    }

    @Override
    public boolean isExecutable() {
        return this.hostProperty.getParentInstance() != null;
    }

    @Override
    public void execute() {
        this.hostInstance = this.hostProperty.getParentInstance();
        this.newProperty = new FXOMPropertyC(this.hostProperty.getFxomDocument(), this.hostProperty.getName());
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.hostProperty.getParentInstance() == null);
        assert (this.newProperty.getParentInstance() == this.hostInstance);
        this.newProperty.removeFromParentInstance();
        this.newValue.removeFromParentProperty();
        this.hostProperty.addToParentInstance(-1, this.hostInstance);
    }

    @Override
    public void redo() {
        assert (this.hostProperty.getParentInstance() == this.hostInstance);
        assert (this.newProperty.getParentInstance() == null);
        this.hostProperty.removeFromParentInstance();
        this.newValue.addToParentProperty(-1, this.newProperty);
        this.newProperty.addToParentInstance(-1, this.hostInstance);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

