/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ColumnConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public class InsertColumnConstraintsJob
extends Job {
    private static final ColumnConstraintsListPropertyMetadata columnContraintsMeta = new ColumnConstraintsListPropertyMetadata(new PropertyName("columnConstraints"), true, Collections.emptyList(), InspectorPath.UNUSED);
    private final FXOMInstance gridPaneObject;
    private final int columnIndex;
    private final int insertCount;

    public InsertColumnConstraintsJob(FXOMObject gridPaneObject, int columnIndex, int insertCount, EditorController editorController) {
        super(editorController);
        assert (gridPaneObject instanceof FXOMInstance);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        assert (columnIndex >= 0);
        assert (columnIndex <= columnContraintsMeta.getValue((FXOMInstance)gridPaneObject).size());
        assert (insertCount >= 1);
        this.gridPaneObject = (FXOMInstance)gridPaneObject;
        this.columnIndex = columnIndex;
        this.insertCount = insertCount;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        ArrayList constraintsList = new ArrayList(columnContraintsMeta.getValue(this.gridPaneObject));
        assert (this.columnIndex < constraintsList.size());
        for (int i = 0; i < this.insertCount; ++i) {
            constraintsList.remove(this.columnIndex);
        }
        columnContraintsMeta.setValue(this.gridPaneObject, constraintsList);
    }

    @Override
    public void redo() {
        ArrayList constraintsList = new ArrayList(columnContraintsMeta.getValue(this.gridPaneObject));
        ColumnConstraints template = this.columnIndex >= 1 ? (ColumnConstraints)constraintsList.get(this.columnIndex - 1) : null;
        for (int i = 0; i < this.insertCount; ++i) {
            constraintsList.add(this.columnIndex, this.makeColumnConstraints(template));
        }
        columnContraintsMeta.setValue(this.gridPaneObject, constraintsList);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }

    private ColumnConstraints makeColumnConstraints(ColumnConstraints template) {
        ColumnConstraints result = new ColumnConstraints();
        if (this.columnIndex >= 1) {
            result.setFillWidth(template.isFillWidth());
            result.setHalignment(template.getHalignment());
            result.setHgrow(template.getHgrow());
            result.setMaxWidth(template.getMaxWidth());
            result.setMinWidth(template.getMinWidth());
            result.setPercentWidth(template.getPercentWidth());
            result.setPrefWidth(template.getPrefWidth());
        }
        return result;
    }
}

