/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PaintPopupEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditorValidation;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.layout.Pane;

public abstract class PopupEditor
extends PropertyEditor
implements PopupEditorValidation {
    @FXML
    MenuButton popupMb;
    @FXML
    CustomMenuItem popupMenuItem;
    @FXML
    Pane editorHost;
    private Object value;
    private boolean initialized = false;

    public PopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initializeEditor();
    }

    private void initializeEditor() {
        EditorUtils.loadPopupFxml("PopupEditor.fxml", this);
        this.popupMb.showingProperty().addListener((ov, previousVal, newVal) -> {
            if (newVal.booleanValue()) {
                if (!this.initialized) {
                    this.initializePopup();
                    this.initialized = true;
                }
                this.setPopupContentValue(this.value);
            }
        });
    }

    private void initializePopup() {
        this.initializePopupContent();
        this.editorHost.getChildren().add((Object)this.getPopupContentNode());
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.popupMb);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (this.popupMb.isShowing()) {
            this.setPopupContentValue(value);
        }
        this.popupMb.setText(this.getPreviewString(value));
        if (this instanceof PaintPopupEditor) {
            this.popupMb.setGraphic(((PaintPopupEditor)this).getPreviewGraphic(value));
        }
        this.commitValue(value);
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.popupMb.setText(null);
    }

    @Override
    protected void valueIsIndeterminate() {
        PopupEditor.handleIndeterminate((Node)this.popupMb);
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.popupMb.requestFocus());
    }

    @Override
    public void commitValue(Object value) {
        this.userUpdateValueProperty(value);
        this.popupMb.setText(this.getPreviewString(value));
        this.value = value;
    }

    @Override
    public void transientValue(Object value) {
        this.userUpdateTransientValueProperty(value);
    }

    @Override
    public void invalidValue(Object value) {
    }

    public abstract void initializePopupContent();

    public abstract Node getPopupContentNode();

    public abstract void setPopupContentValue(Object var1);

    public abstract String getPreviewString(Object var1);
}

