/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.selection;

import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;

public class Selection {
    private AbstractSelectionGroup group;
    private final SimpleIntegerProperty revision = new SimpleIntegerProperty();
    private boolean lock;
    private long lastListenerInvocationTime;
    private int updateDepth;

    public ReadOnlyIntegerProperty revisionProperty() {
        return this.revision;
    }

    public int getRevision() {
        return this.revision.get();
    }

    public void select(FXOMObject fxomObject) {
        assert (fxomObject != null);
        this.select(fxomObject, null);
    }

    public void select(FXOMObject fxomObject, Node hitNode) {
        this.select(new ObjectSelectionGroup(fxomObject, hitNode));
    }

    public void select(Collection<FXOMObject> fxomObjects) {
        assert (fxomObjects != null);
        FXOMObject hitObject = fxomObjects.isEmpty() ? null : fxomObjects.iterator().next();
        this.select(fxomObjects, hitObject, null);
    }

    public void select(Collection<FXOMObject> fxomObjects, FXOMObject hitObject, Node hitNode) {
        assert (fxomObjects != null);
        ObjectSelectionGroup newGroup = fxomObjects.isEmpty() ? null : new ObjectSelectionGroup(fxomObjects, hitObject, hitNode);
        this.select(newGroup);
    }

    public void toggleSelection(FXOMObject fxomObject) {
        this.toggleSelection(fxomObject, null);
    }

    public void toggleSelection(FXOMObject fxomObject, Node hitNode) {
        ObjectSelectionGroup newGroup;
        assert (fxomObject != null);
        if (this.group instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)this.group;
            Set<FXOMObject> currentItems = osg.getItems();
            if (currentItems.contains(fxomObject)) {
                if (currentItems.size() == 1) {
                    newGroup = null;
                } else {
                    HashSet<FXOMObject> newItems = new HashSet<FXOMObject>();
                    newItems.addAll(currentItems);
                    newItems.remove(fxomObject);
                    FXOMObject newHitItem = (FXOMObject)newItems.iterator().next();
                    newGroup = new ObjectSelectionGroup(newItems, newHitItem, null);
                }
            } else {
                HashSet<FXOMObject> newItems = new HashSet<FXOMObject>();
                newItems.addAll(currentItems);
                newItems.add(fxomObject);
                newGroup = new ObjectSelectionGroup(newItems, fxomObject, hitNode);
            }
        } else {
            newGroup = new ObjectSelectionGroup(fxomObject, hitNode);
        }
        this.select(newGroup);
    }

    public void updateHitObject(FXOMObject hitObject, Node hitNode) {
        if (this.isSelected(hitObject)) {
            assert (this.group instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)this.group;
            this.select(osg.getItems(), hitObject, hitNode);
        } else {
            this.select(hitObject, hitNode);
        }
    }

    public boolean isSelected(FXOMObject fxomObject) {
        boolean result;
        assert (fxomObject != null);
        if (this.group instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)this.group;
            result = osg.getItems().contains(fxomObject);
        } else {
            result = false;
        }
        return result;
    }

    public FXOMObject getHitItem() {
        FXOMObject result;
        if (this.group instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)this.group;
            result = osg.getHitItem();
        } else if (this.group instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)this.group;
            result = gsg.getParentObject();
        } else {
            result = null;
        }
        return result;
    }

    public Node getCheckedHitNode() {
        Node result;
        if (this.group instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)this.group;
            result = osg.getCheckedHitNode();
        } else {
            result = null;
        }
        return result;
    }

    public void select(FXOMInstance gridPaneObject, GridSelectionGroup.Type feature, int featureIndex) {
        assert (gridPaneObject != null);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        this.select(new GridSelectionGroup((FXOMObject)gridPaneObject, feature, featureIndex));
    }

    public void toggleSelection(FXOMInstance gridPaneObject, GridSelectionGroup.Type feature, int featureIndex) {
        AbstractSelectionGroup newGroup;
        assert (gridPaneObject != null);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        if (this.group instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)this.group;
            if (gsg.getType() == feature) {
                Set<Integer> indexes = gsg.getIndexes();
                if (indexes.contains(featureIndex)) {
                    if (indexes.size() == 1) {
                        newGroup = new ObjectSelectionGroup(gridPaneObject, null);
                    } else {
                        HashSet<Integer> newIndexes = new HashSet<Integer>();
                        newIndexes.addAll(indexes);
                        newIndexes.remove(featureIndex);
                        newGroup = new GridSelectionGroup((FXOMObject)gridPaneObject, feature, newIndexes);
                    }
                } else {
                    HashSet<Integer> newIndexes = new HashSet<Integer>();
                    newIndexes.addAll(indexes);
                    newIndexes.add(featureIndex);
                    newGroup = new GridSelectionGroup((FXOMObject)gridPaneObject, feature, newIndexes);
                }
            } else {
                newGroup = new GridSelectionGroup((FXOMObject)gridPaneObject, feature, featureIndex);
            }
        } else {
            newGroup = new GridSelectionGroup((FXOMObject)gridPaneObject, feature, featureIndex);
        }
        this.select(newGroup);
    }

    public boolean isSelected(FXOMInstance gridPaneObject, GridSelectionGroup.Type feature, int featureIndex) {
        GridSelectionGroup gsg;
        assert (gridPaneObject != null);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        boolean result = this.group instanceof GridSelectionGroup ? (gsg = (GridSelectionGroup)this.group).getType() == feature && gsg.getIndexes().contains(featureIndex) : false;
        return result;
    }

    public void select(AbstractSelectionGroup newGroup) {
        if (this.lock) {
            throw new IllegalStateException("Changing selection from a selection listener is forbidden");
        }
        if (!Objects.equals(this.group, newGroup)) {
            this.beginUpdate();
            this.group = newGroup;
            this.endUpdate();
        }
    }

    public FXOMObject lookupSelectedAncestor(FXOMObject fxomObject) {
        assert (fxomObject != null);
        FXOMObject result = null;
        for (FXOMObject parent = fxomObject.getParentObject(); parent != null && result == null; parent = parent.getParentObject()) {
            if (!this.isSelected(parent)) continue;
            result = parent;
        }
        return result;
    }

    public void clear() {
        if (this.group != null) {
            this.beginUpdate();
            this.group = null;
            this.endUpdate();
        }
    }

    public boolean isEmpty() {
        return this.getGroup() == null;
    }

    public AbstractSelectionGroup getGroup() {
        return this.group;
    }

    public long getLastListenerInvocationTime() {
        return this.lastListenerInvocationTime;
    }

    public void beginUpdate() {
        ++this.updateDepth;
    }

    public void endUpdate() {
        assert (this.updateDepth >= 1);
        --this.updateDepth;
        if (this.updateDepth == 0) {
            this.incrementRevision();
        }
    }

    public FXOMObject getAncestor() {
        FXOMObject result = this.group == null ? null : this.group.getAncestor();
        return result;
    }

    public boolean isValid(FXOMDocument fxomDocument) {
        assert (fxomDocument != null);
        boolean result = this.group == null ? true : this.group.isValid(fxomDocument);
        return result;
    }

    private void incrementRevision() {
        this.lock = true;
        long startTime = System.nanoTime();
        try {
            this.revision.set(this.revision.get() + 1);
        }
        finally {
            this.lock = false;
        }
        this.lastListenerInvocationTime = System.nanoTime() - startTime;
    }
}

