/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FXOMIntrinsic
extends FXOMObject {
    private final Map<PropertyName, FXOMProperty> properties = new LinkedHashMap<PropertyName, FXOMProperty>();
    private Object sourceSceneGraphObject;

    FXOMIntrinsic(FXOMDocument document, GlueElement glueElement, Object targetSceneGraphObject) {
        super(document, glueElement, null);
        this.sourceSceneGraphObject = targetSceneGraphObject;
    }

    public FXOMIntrinsic(FXOMDocument document, Type type, String source) {
        super(document, FXOMIntrinsic.makeTagNameFromType(type));
        this.getGlueElement().getAttributes().put("source", source);
    }

    public Type getType() {
        Type result;
        switch (this.getGlueElement().getTagName()) {
            case "fx:include": {
                result = Type.FX_INCLUDE;
                break;
            }
            case "fx:reference": {
                result = Type.FX_REFERENCE;
                break;
            }
            case "fx:copy": {
                result = Type.FX_COPY;
                break;
            }
            default: {
                result = Type.UNDEFINED;
            }
        }
        return result;
    }

    public String getSource() {
        return this.getGlueElement().getAttributes().get("source");
    }

    public void setSource(String source) {
        if (source == null) {
            this.getGlueElement().getAttributes().remove("source");
        } else {
            this.getGlueElement().getAttributes().put("source", source);
        }
    }

    public Object getSourceSceneGraphObject() {
        return this.sourceSceneGraphObject;
    }

    public void setSourceSceneGraphObject(Object sourceSceneGraphObject) {
        this.sourceSceneGraphObject = sourceSceneGraphObject;
    }

    public Map<PropertyName, FXOMProperty> getProperties() {
        return this.properties;
    }

    @Override
    public List<FXOMObject> getChildObjects() {
        return Collections.emptyList();
    }

    @Override
    public FXOMObject searchWithSceneGraphObject(Object sceneGraphObject) {
        FXOMObject result = this.getType() == Type.FX_INCLUDE ? super.searchWithSceneGraphObject(sceneGraphObject) : null;
        return result;
    }

    @Override
    public FXOMObject searchWithFxId(String fxId) {
        FXOMObject result = this.getType() == Type.FX_INCLUDE ? super.searchWithFxId(fxId) : null;
        return result;
    }

    @Override
    protected void collectDeclaredClasses(Set<Class<?>> result) {
    }

    @Override
    protected void collectNullProperties(List<FXOMPropertyT> result) {
    }

    @Override
    protected void collectPropertiesT(List<FXOMPropertyT> result) {
    }

    @Override
    protected void collectProperties(PropertyName propertyName, List<FXOMProperty> result) {
    }

    @Override
    protected void collectReferences(String source, List<FXOMIntrinsic> result) {
        assert (result != null);
        if (this.getType() == Type.FX_REFERENCE && (source == null || source.equals(this.getSource()))) {
            result.add(this);
        }
    }

    @Override
    protected void collectReferences(String source, FXOMObject scope, List<FXOMNode> result) {
        assert (result != null);
        if (!(scope != null && scope == this || this.getType() != Type.FX_REFERENCE || source != null && !source.equals(this.getSource()))) {
            result.add(this);
        }
    }

    @Override
    protected void collectIncludes(String source, List<FXOMIntrinsic> result) {
        assert (result != null);
        if (this.getType() == Type.FX_INCLUDE && (source == null || source.equals(this.getSource()))) {
            result.add(this);
        }
    }

    @Override
    protected void collectFxIds(Map<String, FXOMObject> result) {
        String fxId = this.getFxId();
        if (fxId != null) {
            result.put(fxId, this);
        }
    }

    @Override
    protected void collectObjectWithSceneGraphObjectClass(Class<?> sceneGraphObjectClass, List<FXOMObject> result) {
    }

    @Override
    protected void collectEventHandlers(List<FXOMPropertyT> result) {
    }

    @Override
    public void documentLocationWillChange(URL newLocation) {
    }

    private static String makeTagNameFromType(Type type) {
        String result;
        switch (type) {
            case FX_COPY: {
                result = "fx:copy";
                break;
            }
            case FX_REFERENCE: {
                result = "fx:reference";
                break;
            }
            case FX_INCLUDE: {
                result = "fx:include";
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException("Unexpected intrinsic type " + (Object)((Object)type));
            }
        }
        return result;
    }

    public static enum Type {
        FX_INCLUDE,
        FX_REFERENCE,
        FX_COPY,
        UNDEFINED;

    }
}

